/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.cuboid.algorithm.greedy;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kylin.cube.cuboid.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.cube.cuboid.algorithm.BenefitPolicy;
import org.apache.kylin.cube.cuboid.algorithm.CuboidBenefitModel;
import org.apache.kylin.cube.cuboid.algorithm.CuboidStats;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.apache.kylin.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyAlgorithm
extends AbstractRecommendAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(GreedyAlgorithm.class);
    private static final int THREAD_NUM = 8;
    private ExecutorService executor;
    private Set<Long> selected = Sets.newLinkedHashSet();
    private List<Long> remaining = Lists.newLinkedList();

    public GreedyAlgorithm(long timeout, BenefitPolicy benefitPolicy, CuboidStats cuboidStats) {
        super(timeout, benefitPolicy, cuboidStats);
    }

    @Override
    public List<Long> start(double spaceLimit) {
        logger.info("Greedy Algorithm started.");
        this.executor = Executors.newFixedThreadPool(8, new ThreadFactoryBuilder().setNameFormat("greedy-algorithm-benefit-calculator-pool-%d").build());
        this.selected.clear();
        double remainingSpace = spaceLimit;
        for (Long mandatoryOne : this.cuboidStats.getAllCuboidsForMandatory()) {
            this.selected.add(mandatoryOne);
            if (this.cuboidStats.getCuboidSize(mandatoryOne) == null) continue;
            remainingSpace -= this.cuboidStats.getCuboidSize(mandatoryOne).doubleValue();
        }
        this.remaining.clear();
        this.remaining.addAll(this.cuboidStats.getAllCuboidsForSelection());
        long round = 0L;
        boolean doesRemainSpace = true;
        while (!this.shouldCancel() && doesRemainSpace) {
            CuboidBenefitModel best = this.recommendBestOne();
            if (best != null && this.benefitPolicy.ifEfficient(best)) {
                if ((remainingSpace -= this.cuboidStats.getCuboidSize(best.getCuboidId()).doubleValue()) > 0.0) {
                    this.selected.add(best.getCuboidId());
                    this.remaining.remove(best.getCuboidId());
                    this.benefitPolicy.propagateAggregationCost(best.getCuboidId(), this.selected);
                    ++round;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Recommend in round {} : {}", (Object)round, (Object)best);
                    continue;
                }
                doesRemainSpace = false;
                continue;
            }
            doesRemainSpace = false;
        }
        this.executor.shutdown();
        ArrayList<Long> excluded = Lists.newArrayList(this.remaining);
        this.remaining.retainAll(this.selected);
        Preconditions.checkArgument(this.remaining.isEmpty(), "There should be no intersection between excluded list and selected list.");
        logger.info("Greedy Algorithm finished.");
        if (logger.isDebugEnabled()) {
            logger.debug("Excluded cuboidId size: {}", (Object)excluded.size());
            logger.debug("Excluded cuboidId detail:");
            for (Long cuboid : excluded) {
                logger.debug("cuboidId {} and Cost: {} and Space: {}", cuboid, this.cuboidStats.getCuboidQueryCost(cuboid), this.cuboidStats.getCuboidSize(cuboid));
            }
            logger.debug("Total Space: {}", (Object)(spaceLimit - remainingSpace));
            logger.debug("Space Expansion Rate: {}", (Object)((spaceLimit - remainingSpace) / this.cuboidStats.getBaseCuboidSize()));
        }
        return Lists.newArrayList(this.selected);
    }

    private CuboidBenefitModel recommendBestOne() {
        int selectedSize = this.selected.size();
        AtomicReference best = new AtomicReference();
        CountDownLatch counter = new CountDownLatch(this.remaining.size());
        for (Long cuboid : this.remaining) {
            this.executor.submit(() -> {
                CuboidBenefitModel currentBest = (CuboidBenefitModel)best.get();
                assert (this.selected.size() == selectedSize);
                CuboidBenefitModel.BenefitModel benefitModel = this.benefitPolicy.calculateBenefit(cuboid, this.selected);
                if (benefitModel != null && (currentBest == null || currentBest.getBenefit() == null || benefitModel.benefit > currentBest.getBenefit())) {
                    while (!best.compareAndSet(currentBest, new CuboidBenefitModel(this.cuboidStats.getCuboidModel(cuboid), benefitModel)) && !(benefitModel.benefit <= (currentBest = (CuboidBenefitModel)best.get()).getBenefit())) {
                    }
                }
                counter.countDown();
            });
        }
        try {
            counter.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (CuboidBenefitModel)best.get();
    }
}

