/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.metadata.cube.PathManager;
import org.apache.kylin.engine.spark.utils.MetaDumpUtil;
import org.apache.kylin.engine.spark.utils.UpdateMetadataUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkOptimizingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkOptimizingStep.class);

    public NSparkOptimizingStep() {
    }

    public NSparkOptimizingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Build recommend cuboid from parent cuboid");
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        String cubeId = this.getParam("cubeId");
        CubeInstance cubeInstance = CubeManager.getInstance(config).getCubeByUuid(cubeId);
        return MetaDumpUtil.collectCubeMetadata(cubeInstance);
    }

    @Override
    public boolean needMergeMetadata() {
        return true;
    }

    @Override
    protected Map<String, String> getJobMetricsInfo(KylinConfig config) {
        CubeManager cubeManager = CubeManager.getInstance(config);
        CubeInstance cube = cubeManager.getCube(this.getCubeName());
        HashMap<String, String> joblogInfo = Maps.newHashMap();
        joblogInfo.put("sourceSizeBytes", String.valueOf(cube.getInputRecordSizeBytes()));
        joblogInfo.put("byteSizeBytes", String.valueOf(cube.getSizeKB()));
        return joblogInfo;
    }

    @Override
    public void cleanup(ExecuteResult result) throws ExecuteException {
        if (result != null && result.state().ordinal() == ExecuteResult.State.SUCCEED.ordinal()) {
            PathManager.deleteJobTempPath(this.getConfig(), this.getParam("project"), this.getParam("jobId"));
        }
    }

    @Override
    protected void updateMetaAfterOperation(KylinConfig config) throws IOException {
        UpdateMetadataUtil.syncLocalMetadataToRemote(config, this);
    }

    public static class Mockup {
        public static void main(String[] args) {
            logger.info(NSparkCubingStep.Mockup.class + ".main() invoked, args: " + Arrays.toString(args));
        }
    }
}

