/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.NBuildSourceInfo;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.ParentSourceChooser;
import org.apache.kylin.engine.spark.metadata.SegmentInfo;
import org.apache.kylin.engine.spark.metadata.cube.ManagerHub;
import org.apache.kylin.engine.spark.metadata.cube.model.ForestSpanningTree;
import org.apache.kylin.engine.spark.metadata.cube.model.SpanningTree;
import org.apache.kylin.engine.spark.utils.SparkUtils;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConversions;

public class ResourceDetectBeforeOptimizingJob
extends SparkApplication {
    protected static final Logger logger = LoggerFactory.getLogger(ResourceDetectBeforeOptimizingJob.class);
    protected volatile SpanningTree spanningTree;
    protected volatile List<NBuildSourceInfo> sources = new ArrayList<NBuildSourceInfo>();

    public static void main(String[] args) {
        ResourceDetectBeforeOptimizingJob resourceDetectJob = new ResourceDetectBeforeOptimizingJob();
        resourceDetectJob.execute(args);
    }

    @Override
    protected void doExecute() throws Exception {
        logger.info("Start detect resource before optimize.");
        String segId = this.getParam("segmentId");
        String cubeId = this.getParam("cubeId");
        CubeManager cubeManager = CubeManager.getInstance(this.config);
        CubeInstance cubeInstance = cubeManager.getCubeByUuid(cubeId);
        SegmentInfo segInfo = ManagerHub.getSegmentInfo(this.config, cubeId, segId);
        CubeSegment segment = cubeInstance.getSegmentById(segId);
        this.infos.recordOptimizingSegment(segInfo);
        this.spanningTree = new ForestSpanningTree(JavaConversions.asJavaCollection(segInfo.toBuildLayouts()));
        segInfo.removeLayout(segment.getCuboidScheduler().getBaseCuboidId());
        ResourceDetectUtils.write(new Path(this.config.getJobTmpShareDir(this.project, this.jobId), ResourceDetectUtils.countDistinctSuffix()), false);
        ParentSourceChooser datasetChooser = new ParentSourceChooser(this.spanningTree, segInfo, segment, this.jobId, this.ss, this.config, false);
        datasetChooser.decideSources();
        NBuildSourceInfo buildFromFlatTable = datasetChooser.flatTableSource();
        if (buildFromFlatTable != null) {
            this.sources.add(buildFromFlatTable);
        }
        Map<Long, NBuildSourceInfo> buildFromLayouts = datasetChooser.reuseSources();
        this.sources.addAll(buildFromLayouts.values());
        HashMap resourcePaths = Maps.newHashMap();
        HashMap<String, Integer> layoutLeafTaskNums = Maps.newHashMap();
        this.infos.clearSparkPlans();
        for (NBuildSourceInfo source : this.sources) {
            Dataset<Row> dataset = source.getParentDS();
            RDD actionRdd = dataset.queryExecution().toRdd();
            logger.info("leaf nodes is: {} ", (Object)SparkUtils.leafNodes(actionRdd));
            this.infos.recordSparkPlan(dataset.queryExecution().sparkPlan());
            List paths = JavaConversions.seqAsJavaList(ResourceDetectUtils.getPaths(dataset.queryExecution().sparkPlan()));
            List pathList = paths.stream().map(Path::toString).collect(Collectors.toList());
            resourcePaths.put(String.valueOf(source.getLayoutId()), pathList);
            layoutLeafTaskNums.put(String.valueOf(source.getLayoutId()), SparkUtils.leafNodePartitionNums(actionRdd));
        }
        ResourceDetectUtils.write(new Path(this.config.getJobTmpShareDir(this.project, this.jobId), segId + "_" + ResourceDetectUtils.fileName()), resourcePaths);
        ResourceDetectUtils.write(new Path(this.config.getJobTmpShareDir(this.project, this.jobId), segId + "_" + ResourceDetectUtils.cubingDetectItemFileSuffix()), layoutLeafTaskNums);
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeOptimizeJobInfo();
    }
}

