/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.AutoDeleteDirectory;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDumpUtil {
    private static final Logger logger = LoggerFactory.getLogger(MetaDumpUtil.class);

    public static Set<String> collectCubeMetadata(CubeInstance cube) {
        TableMetadataManager tableMgr = TableMetadataManager.getInstance(cube.getConfig());
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        dumpList.add(cube.getResourcePath());
        dumpList.add(cube.getDescriptor().getModel().getResourcePath());
        dumpList.add(cube.getDescriptor().getResourcePath());
        dumpList.add(cube.getProjectInstance().getResourcePath());
        for (TableRef tableRef : cube.getDescriptor().getModel().getAllTables()) {
            TableDesc table = tableRef.getTableDesc();
            dumpList.add(table.getResourcePath());
            dumpList.add(tableMgr.getTableExt(table).getResourcePath());
        }
        return dumpList;
    }

    public static void dumpAndUploadKylinPropsAndMetadata(Set<String> dumpList, KylinConfig kylinConfig, String metadataUrl) throws IOException {
        try (AutoDeleteDirectory tmpDir = new AutoDeleteDirectory("kylin_job_meta", "");
             AutoDeleteDirectory metaDir = tmpDir.child("meta");){
            MetaDumpUtil.dumpResources(kylinConfig, metaDir.getFile().getAbsolutePath(), dumpList);
            Properties props = kylinConfig.exportToProperties();
            props.setProperty("kylin.metadata.url", metadataUrl);
            File kylinPropsFile = new File(metaDir.getFile(), "kylin.properties");
            try (FileOutputStream os = new FileOutputStream(kylinPropsFile);){
                props.store(os, kylinPropsFile.getAbsolutePath());
            }
            KylinConfig dstConfig = KylinConfig.createKylinConfig(props);
            new ResourceTool().copy(KylinConfig.createInstanceFromUri(metaDir.getAbsolutePath()), dstConfig);
        }
    }

    public static void dumpResources(KylinConfig kylinConfig, String metaOutDir, Set<String> dumpList) throws IOException {
        long startTime = System.currentTimeMillis();
        ResourceStore from = ResourceStore.getStore(kylinConfig);
        KylinConfig localConfig = KylinConfig.createInstanceFromUri(metaOutDir);
        ResourceStore to = ResourceStore.getStore(localConfig);
        String[] tolerantResources = new String[]{"/table_exd"};
        for (String path : dumpList) {
            RawResource res = from.getResource(path);
            if (res == null) {
                if (StringUtils.startsWithAny(path, tolerantResources)) continue;
                throw new IllegalStateException("No resource found at -- " + path);
            }
            to.putResource(path, res.content(), res.lastModified());
            res.content().close();
        }
        logger.debug("Dump resources to {} took {} ms", (Object)metaOutDir, (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KylinConfig loadKylinConfigFromHdfs(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("StorageUrl should not be null");
        }
        if (!uri.contains("@hdfs")) {
            throw new IllegalArgumentException("StorageUrl should like @hdfs schema");
        }
        logger.info("Ready to load KylinConfig from uri: {}", (Object)uri);
        StorageURL url = StorageURL.valueOf(uri);
        String metaDir = url.getParameter("path") + "/" + "kylin.properties";
        Path path = new Path(metaDir);
        try (FSDataInputStream is = path.getFileSystem(HadoopUtil.getCurrentConfiguration()).open(new Path(metaDir));){
            Properties prop = KylinConfig.streamToProps((InputStream)is);
            KylinConfig kylinConfig = KylinConfig.createKylinConfig(prop);
            return kylinConfig;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

