/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.job.engine.JobEngineConfig;

public class JobBuilderSupport {
    protected final JobEngineConfig config;
    protected final CubeSegment seg;
    protected final String submitter;
    protected final Integer priorityOffset;
    public static final String LayeredCuboidFolderPrefix = "level_";
    public static final String PathNameCuboidBase = "base_cuboid";
    public static final String PathNameCuboidOld = "old";
    public static final String PathNameCuboidInMem = "in_memory";
    public static final Pattern JOB_NAME_PATTERN = Pattern.compile("kylin-([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

    public JobBuilderSupport(CubeSegment seg, String submitter) {
        this(seg, submitter, 0);
    }

    public JobBuilderSupport(CubeSegment seg, String submitter, Integer priorityOffset) {
        Preconditions.checkNotNull((Object)seg, (Object)"segment cannot be null");
        this.config = new JobEngineConfig(seg.getConfig());
        this.seg = seg;
        this.submitter = submitter;
        this.priorityOffset = priorityOffset;
    }

    public String getJobWorkingDir(String jobId) {
        return JobBuilderSupport.getJobWorkingDir(this.config, jobId);
    }

    public String getRealizationRootPath(String jobId) {
        return this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName();
    }

    public String getCuboidRootPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/cuboid/";
    }

    public String getCuboidRootPath(CubeSegment seg) {
        return this.getCuboidRootPath(seg.getLastBuildJobID());
    }

    public void appendMapReduceParameters(StringBuilder buf) {
        this.appendMapReduceParameters(buf, "");
    }

    public void appendMapReduceParameters(StringBuilder buf, String jobType) {
        try {
            String jobConf = this.config.getHadoopJobConfFilePath(jobType);
            if (jobConf != null && jobConf.length() > 0) {
                buf.append(" -conf ").append(jobConf);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getOptimizationRootPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/optimize";
    }

    public static String getJobWorkingDir(JobEngineConfig conf, String jobId) {
        return JobBuilderSupport.getJobWorkingDir(conf.getHdfsWorkingDirectory(), jobId);
    }

    public static String getJobWorkingDir(String hdfsDir, String jobId) {
        if (!hdfsDir.endsWith("/")) {
            hdfsDir = hdfsDir + "/";
        }
        return hdfsDir + "kylin-" + jobId;
    }

    public static StringBuilder appendExecCmdParameters(StringBuilder buf, String paraName, String paraValue) {
        return buf.append(" -").append(paraName).append(" ").append(paraValue);
    }

    public static String getCuboidOutputPathsByLevel(String cuboidRootPath, int level) {
        if (level == 0) {
            return cuboidRootPath + LayeredCuboidFolderPrefix + PathNameCuboidBase;
        }
        return cuboidRootPath + LayeredCuboidFolderPrefix + level + "_cuboid";
    }

    public static String getBaseCuboidPath(String cuboidRootPath) {
        return cuboidRootPath + PathNameCuboidBase;
    }

    public static String getInMemCuboidPath(String cuboidRootPath) {
        return cuboidRootPath + PathNameCuboidInMem;
    }

    public String getDumpMetadataPath(String jobId) {
        return this.getRealizationRootPath(jobId) + "/metadata";
    }

    public static String extractJobIDFromPath(String path) {
        Matcher matcher = JOB_NAME_PATTERN.matcher(path);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalStateException("Can not extract job ID from file path : " + path);
    }

    public String getSegmentMetadataUrl(KylinConfig kylinConfig, String jobId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("path", this.getDumpMetadataPath(jobId));
        return new StorageURL(kylinConfig.getMetadataUrl().getIdentifier(), "hdfs", param).toString();
    }

    public static void scanFiles(String input, FileSystem fs, List<FileStatus> outputs) throws IOException {
        FileStatus[] fileStatuses;
        Path path = new Path(input);
        if (!fs.exists(path)) {
            return;
        }
        for (FileStatus stat : fileStatuses = fs.listStatus(path, p -> !p.getName().startsWith("_"))) {
            if (stat.isDirectory()) {
                JobBuilderSupport.scanFiles(stat.getPath().toString(), fs, outputs);
                continue;
            }
            outputs.add(stat);
        }
    }

    public static long getFileSize(String input, FileSystem fs) throws IOException {
        ArrayList outputs = Lists.newArrayList();
        JobBuilderSupport.scanFiles(input, fs, outputs);
        long size = 0L;
        for (FileStatus stat : outputs) {
            size += stat.getLen();
        }
        return size;
    }
}

