/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.util;

import java.io.IOException;
import java.util.HashMap;
import org.apache.kylin.common.constant.JobTypeEnum;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.job.JobInstance;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.org.apache.http.HttpResponse;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.HttpGet;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.HttpPut;
import org.apache.kylin.tool.shaded.org.apache.http.entity.StringEntity;

public class JobRestClient
extends RestClient {
    private static final String JOBS = "/jobs/";

    public JobRestClient(String host, int port, String userName, String password) {
        this(host, port, userName, password, null, null);
    }

    public JobRestClient(String host, int port, String userName, String password, Integer httpConnectionTimeoutMs, Integer httpSocketTimeoutMs) {
        super(host, port, userName, password, httpConnectionTimeoutMs, httpSocketTimeoutMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInstance buildCubeV2(String cubeName, long startTime, long endTime, JobTypeEnum buildType) throws IOException {
        JobInstance jobInstance;
        String url = this.baseUrl + "/cubes/" + cubeName + "/build";
        HttpPut put = this.newPut(url);
        HttpResponse response = null;
        try {
            HashMap<String, String> paraMap = new HashMap<String, String>();
            paraMap.put("startTime", startTime + "");
            paraMap.put("endTime", endTime + "");
            paraMap.put("buildType", buildType.toString());
            String jsonMsg = new ObjectMapper().writeValueAsString(paraMap);
            put.setEntity(new StringEntity(jsonMsg, "UTF-8"));
            response = this.client.execute(put);
            String result = this.getContent(response);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + result + " with build cube url " + url + "\n" + jsonMsg);
            }
            jobInstance = this.json2JobInstance(result);
        }
        catch (Throwable throwable) {
            this.cleanup(put, response);
            throw throwable;
        }
        this.cleanup(put, response);
        return jobInstance;
    }

    protected JobInstance json2JobInstance(String json) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JobInstance jobInstance = mapper.readValue(json, JobInstance.class);
        return jobInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInstance getJobStatus(String jobId) throws IOException {
        String url = this.baseUrl + JOBS + jobId;
        HttpGet get = this.newGet(url);
        HttpResponse response = null;
        try {
            response = this.client.execute(get);
            String result = this.getContent(response);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + result + " with get job status " + jobId);
            }
            JobInstance jobInstance = this.json2JobInstance(result);
            return jobInstance;
        }
        finally {
            this.cleanup(get, response);
        }
    }

    public String JobInstance2JsonString(JobInstance jobInstance) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        String jsonString = mapper.writeValueAsString(jobInstance);
        return jsonString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInstance resumeJob(String jobId) throws IOException {
        String url = this.baseUrl + JOBS + jobId + "/resume";
        HttpPut put = this.newPut(url);
        HttpResponse response = null;
        try {
            response = this.client.execute(put);
            String result = this.getContent(response);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + result + " with resume job " + jobId);
            }
            JobInstance jobInstance = this.json2JobInstance(result);
            return jobInstance;
        }
        finally {
            this.cleanup(put, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJob(String jobId) throws IOException {
        String url = this.baseUrl + JOBS + jobId + "/cancel";
        HttpPut put = this.newPut(url);
        HttpResponse response = null;
        try {
            response = this.client.execute(put);
            String result = this.getContent(response);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + result + " with discard job " + jobId);
            }
        }
        finally {
            this.cleanup(put, response);
        }
    }
}

