/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metrics.lib.ActiveReservoir;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.metrics.lib.Sink;
import org.apache.kylin.metrics.lib.impl.MetricsSystem;
import org.apache.kylin.metrics.lib.impl.ReporterBuilder;
import org.apache.kylin.metrics.lib.impl.StubSink;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.shaded.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsManager {
    public static final String SYSTEM_PROJECT = "KYLIN_SYSTEM";
    private static final Logger logger = LoggerFactory.getLogger(MetricsManager.class);
    private static final MetricsManager instance = new MetricsManager();
    private static final String METHOD_FOR_REGISTRY = "forRegistry";
    private static Map<ActiveReservoir, List<Pair<Class<? extends ActiveReservoirReporter>, Properties>>> sourceReporterBindProps = Maps.newHashMap();
    private static Sink scSink;
    private final Set<String> activeReservoirPointers = Sets.newHashSet();

    private MetricsManager() {
    }

    public static MetricsManager getInstance() {
        return instance;
    }

    public static void initMetricsManager(Sink systemCubeSink, Map<ActiveReservoir, List<Pair<String, Properties>>> sourceReporterBindProperties) {
        MetricsManager.setSystemCubeSink(systemCubeSink);
        MetricsManager.setSourceReporterBindProps(sourceReporterBindProperties);
        instance.init();
    }

    private static void setSystemCubeSink(Sink systemCubeSink) {
        if (systemCubeSink == null) {
            logger.warn("SystemCubeSink is not set and the default one will be chosen");
            try {
                Class<?> clz = Class.forName(KylinConfig.getInstanceFromEnv().getKylinSystemCubeSinkDefaultClass());
                systemCubeSink = (Sink)clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Failed to initialize the " + KylinConfig.getInstanceFromEnv().getKylinSystemCubeSinkDefaultClass() + ". The StubSink will be used");
                systemCubeSink = new StubSink();
            }
        }
        scSink = systemCubeSink;
        System.gc();
    }

    private static void setSourceReporterBindProps(Map<ActiveReservoir, List<Pair<String, Properties>>> sourceReporterBindProperties) {
        sourceReporterBindProps = Maps.newHashMapWithExpectedSize(sourceReporterBindProperties.size());
        for (ActiveReservoir activeReservoir : sourceReporterBindProperties.keySet()) {
            ArrayList<Pair<Class<?>, Properties>> values = Lists.newArrayListWithExpectedSize(sourceReporterBindProperties.get(activeReservoir).size());
            sourceReporterBindProps.put(activeReservoir, values);
            for (Pair<String, Properties> entry : sourceReporterBindProperties.get(activeReservoir)) {
                try {
                    Class<?> clz = Class.forName(entry.getFirst());
                    if (ActiveReservoirReporter.class.isAssignableFrom(clz)) {
                        values.add(new Pair(clz, entry.getSecond()));
                        continue;
                    }
                    logger.warn("The class {} is not a sub class of {}.", (Object)clz, (Object)ActiveReservoir.class);
                }
                catch (ClassNotFoundException e) {
                    logger.warn("Cannot find class {}", (Object)entry.getFirst());
                }
            }
        }
    }

    private void init() {
        if (KylinConfig.getInstanceFromEnv().isKylinMetricsMonitorEnabled()) {
            logger.info("Kylin metrics monitor is enabled.");
            int nameIdx = 0;
            for (ActiveReservoir activeReservoir : sourceReporterBindProps.keySet()) {
                String registerName = MetricsSystem.name(MetricsManager.class, (String[])new String[]{"-" + nameIdx + "-" + activeReservoir.toString()});
                this.activeReservoirPointers.add(registerName);
                List<Pair<Class<? extends ActiveReservoirReporter>, Properties>> reportProps = sourceReporterBindProps.get(activeReservoir);
                for (Pair<Class<? extends ActiveReservoirReporter>, Properties> subEntry : reportProps) {
                    try {
                        Method method = subEntry.getFirst().getMethod(METHOD_FOR_REGISTRY, ActiveReservoir.class);
                        ((ReporterBuilder)method.invoke(null, activeReservoir)).setConfig(subEntry.getSecond()).build().start();
                    }
                    catch (Exception e) {
                        logger.warn("Cannot initialize ActiveReservoirReporter: Builder class - " + subEntry.getFirst() + ", Properties - " + subEntry.getSecond(), e);
                    }
                }
                MetricsSystem.Metrics.register(registerName, activeReservoir);
            }
            Preconditions.checkArgument(this.activeReservoirPointers.size() == sourceReporterBindProps.keySet().size(), "Duplicate register names exist!!!");
        } else {
            logger.info("Kylin metrics monitor is not enabled");
        }
    }

    public void update(Record record) {
        for (String registerName : this.activeReservoirPointers) {
            MetricsSystem.Metrics.activeReservoir(registerName).update(record);
        }
    }

    public static String getSystemTableFromSubject(String subject) {
        return scSink.getTableFromSubject(subject);
    }
}

