/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.service.CubeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/cube_desc"})
public class CubeDescController
extends BasicController {
    @Autowired
    @Qualifier(value="cubeMgmtService")
    private CubeService cubeService;

    @RequestMapping(value={"/{cubeName}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public CubeDesc[] getCube(@PathVariable String cubeName) {
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cubeName);
        if (cubeInstance == null) {
            return null;
        }
        CubeDesc cSchema = cubeInstance.getDescriptor();
        if (cSchema != null) {
            return new CubeDesc[]{cSchema};
        }
        return null;
    }

    @RequestMapping(value={"/{cubeName}/mdx"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse getCubeForMdx(@PathVariable String cubeName) {
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cubeName);
        if (cubeInstance == null) {
            return new EnvelopeResponse<Object>("000", null, "");
        }
        CubeDesc cSchema = cubeInstance.getDescriptor();
        if (cSchema == null) {
            return new EnvelopeResponse<Object>("000", null, "");
        }
        return new EnvelopeResponse<CubeDesc>("000", cSchema, "");
    }

    @RequestMapping(value={"/{cubeName}/desc"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public CubeDesc getDesc(@PathVariable String cubeName) {
        CubeInstance cubeInstance = this.cubeService.getCubeManager().getCube(cubeName);
        if (cubeInstance == null) {
            return null;
        }
        CubeDesc cSchema = cubeInstance.getDescriptor();
        if (cSchema != null) {
            return cSchema;
        }
        return null;
    }

    public void setCubeService(CubeService cubeService) {
        this.cubeService = cubeService;
    }
}

