/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.tool.metrics.systemcube.def.MetricsSinkDesc;

public class CubeInstanceCreator {
    public static void main(String[] args) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        CubeInstance cubeInstance = CubeInstanceCreator.generateKylinCubeInstanceForMetricsQueryExecution("ADMIN", config, new MetricsSinkDesc());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        CubeManager.CUBE_SERIALIZER.serialize(cubeInstance, dout);
        dout.close();
        buf.close();
        System.out.println(buf.toString("UTF-8"));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsQueryExecution(String owner, KylinConfig config, MetricsSinkDesc sinkDesc) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectQueryExecution()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsQuerySparkJob(String owner, KylinConfig config, MetricsSinkDesc sinkDesc) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectQuerySparkJob()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsQuerySparkStage(String owner, KylinConfig config, MetricsSinkDesc sinkDesc) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectQuerySparkStage()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsJob(String owner, KylinConfig config, MetricsSinkDesc sinkDesc) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectJob()));
    }

    public static CubeInstance generateKylinCubeInstanceForMetricsJobException(String owner, KylinConfig config, MetricsSinkDesc sinkDesc) {
        return CubeInstanceCreator.generateKylinCubeInstance(owner, sinkDesc.getTableNameForMetrics(config.getKylinMetricsSubjectJobException()));
    }

    public static CubeInstance generateKylinCubeInstance(String owner, String tableName) {
        CubeInstance cubeInstance = new CubeInstance();
        cubeInstance.setName(tableName.replace('.', '_'));
        cubeInstance.setSegments(new Segments());
        cubeInstance.setDescName(tableName.replace('.', '_'));
        cubeInstance.setStatus(RealizationStatusEnum.DISABLED);
        cubeInstance.setOwner(owner);
        cubeInstance.setCreateTimeUTC(0L);
        cubeInstance.updateRandomUuid();
        return cubeInstance;
    }
}

