/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkEnv$;
import org.apache.spark.TaskContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.CacheFilePartition;
import org.apache.spark.sql.execution.datasources.CachePartitionedFile;
import org.apache.spark.sql.execution.datasources.FilePartition;
import org.apache.spark.sql.execution.datasources.FileScanRDD;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001y4Aa\u0003\u0007\u00013!Aa\u0004\u0001BC\u0002\u0013%q\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003!\u0011!a\u0003A!A!\u0002\u0013i\u0003\u0002C#\u0001\u0005\u000b\u0007I\u0011\u0001$\t\u00115\u0003!\u0011!Q\u0001\n\u001dCQa\u0014\u0001\u0005\u0002ACQ!\u0016\u0001\u0005\u0002YCQA\u001b\u0001\u0005B-DQa\u001e\u0001\u0005RaDQA\u001f\u0001\u0005Rm\u0014\u0001cQ1dQ\u00164\u0015\u000e\\3TG\u0006t'\u000b\u0012#\u000b\u00055q\u0011a\u00033bi\u0006\u001cx.\u001e:dKNT!a\u0004\t\u0002\u0013\u0015DXmY;uS>t'BA\t\u0013\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003'Q\tQa\u001d9be.T!!\u0006\f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0012aA8sO\u000e\u00011C\u0001\u0001\u001b!\tYB$D\u0001\r\u0013\tiBBA\u0006GS2,7kY1o%\u0012#\u0015\u0001D:qCJ\\7+Z:tS>tW#\u0001\u0011\u0011\u0005\u0005\u0012S\"\u0001\t\n\u0005\r\u0002\"\u0001D*qCJ\\7+Z:tS>t\u0017!D:qCJ\\7+Z:tS>t\u0007\u0005\u000b\u0002\u0003MA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\tIAO]1og&,g\u000e^\u0001\re\u0016\fGMR;oGRLwN\u001c\t\u0005O9\u00024'\u0003\u00020Q\tIa)\u001e8di&|g.\r\t\u00037EJ!A\r\u0007\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u00042\u0001\u000e\u001f@\u001d\t)$H\u0004\u00027s5\tqG\u0003\u000291\u00051AH]8pizJ\u0011!K\u0005\u0003w!\nq\u0001]1dW\u0006<W-\u0003\u0002>}\tA\u0011\n^3sCR|'O\u0003\u0002<QA\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tE\u0001\tG\u0006$\u0018\r\\=ti&\u0011A)\u0011\u0002\f\u0013:$XM\u001d8bYJ{w/A\ndC\u000eDWMR5mKB\u000b'\u000f^5uS>t7/F\u0001H!\r!\u0004JS\u0005\u0003\u0013z\u00121aU3r!\tY2*\u0003\u0002M\u0019\t\u00112)Y2iK\u001aKG.\u001a)beRLG/[8o\u0003Q\u0019\u0017m\u00195f\r&dW\rU1si&$\u0018n\u001c8tA!\u0012QAJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\tE\u00136\u000b\u0016\t\u00037\u0001AQA\b\u0004A\u0002\u0001BQ\u0001\f\u0004A\u00025BQ!\u0012\u0004A\u0002\u001d\u000b1b\u00195fG.\u001c\u0015m\u00195fIR\u0011qK\u0017\t\u0003OaK!!\u0017\u0015\u0003\u000f\t{w\u000e\\3b]\")1l\u0002a\u00019\u0006q1-Y2iK2{7-\u0019;j_:\u001c\bcA\u0014^?&\u0011a\f\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0005O\u0001\u0014'-\u0003\u0002bQ\t1A+\u001e9mKJ\u0002\"aY4\u000f\u0005\u0011,\u0007C\u0001\u001c)\u0013\t1\u0007&\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014)\u0003\u001d\u0019w.\u001c9vi\u0016$2a\r7s\u0011\u0015i\u0007\u00021\u0001o\u0003\u0015\u0019\b\u000f\\5u!\ty\u0007/D\u0001\u0013\u0013\t\t(CA\u0005QCJ$\u0018\u000e^5p]\")1\u000f\u0003a\u0001i\u000691m\u001c8uKb$\bCA8v\u0013\t1(CA\u0006UCN\\7i\u001c8uKb$\u0018!D4fiB\u000b'\u000f^5uS>t7/F\u0001z!\r9SL\\\u0001\u0016O\u0016$\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t)\taX\u0010E\u00025\u0011\nDQ!\u001c\u0006A\u00029\u0004")
public class CacheFileScanRDD
extends FileScanRDD {
    private final transient SparkSession sparkSession;
    private final transient Seq<CacheFilePartition> cacheFilePartitions;

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    public Seq<CacheFilePartition> cacheFilePartitions() {
        return this.cacheFilePartitions;
    }

    public boolean checkCached(Tuple2<String, String>[] cacheLocations) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cacheLocations)).map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._1(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).contains((Object)SparkEnv$.MODULE$.get().executorId());
    }

    public Iterator<InternalRow> compute(Partition split, TaskContext context) {
        boolean bl;
        long start = System.currentTimeMillis();
        CacheFilePartition cacheFilePartition = (CacheFilePartition)split;
        FilePartition cacheSplit = new FilePartition(cacheFilePartition.index(), (PartitionedFile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cacheFilePartition.files())).map((Function1 & Serializable & scala.Serializable)f -> new PartitionedFile(f.partitionValues(), f.filePath(), f.start(), f.length(), (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.locations())).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2._2(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PartitionedFile.class))));
        ObjectRef currFilePath = ObjectRef.create((Object)"empty");
        if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cacheFilePartition.files())).isEmpty()) {
            currFilePath.elem = ((CachePartitionedFile)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cacheFilePartition.files())).head()).filePath();
            bl = this.checkCached(((CachePartitionedFile)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cacheFilePartition.files())).head()).locations());
        } else {
            bl = false;
        }
        boolean isCache = bl;
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("SAMetrics=File ").append((String)currFilePath$1.elem).append(" running in task ").append(context.taskAttemptId()).append(" ").append("on executor ").append(SparkEnv$.MODULE$.get().executorId()).append(" with cached ").append(isCache).append(" , ").append("took ").append(System.currentTimeMillis() - start).toString());
        context.getLocalProperties().setProperty("spark.kylin.local-cache.for.current.files", Boolean.toString(isCache));
        return super.compute((Partition)cacheSplit, context);
    }

    public Partition[] getPartitions() {
        return (Partition[])this.cacheFilePartitions().toArray(ClassTag$.MODULE$.apply(Partition.class));
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])((CacheFilePartition)split).preferredLocations());
    }

    public CacheFileScanRDD(SparkSession sparkSession, Function1<PartitionedFile, Iterator<InternalRow>> readFunction, Seq<CacheFilePartition> cacheFilePartitions) {
        this.sparkSession = sparkSession;
        this.cacheFilePartitions = cacheFilePartitions;
        super(sparkSession, readFunction, (Seq)Nil$.MODULE$);
    }
}

