/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.acls.afterinvocation;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.AuthorizationServiceException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.acls.afterinvocation.AbstractAclProvider;
import org.springframework.security.acls.afterinvocation.ArrayFilterer;
import org.springframework.security.acls.afterinvocation.CollectionFilterer;
import org.springframework.security.acls.afterinvocation.Filterer;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;

public class AclEntryAfterInvocationCollectionFilteringProvider
extends AbstractAclProvider {
    protected static final Log logger = LogFactory.getLog(AclEntryAfterInvocationCollectionFilteringProvider.class);

    public AclEntryAfterInvocationCollectionFilteringProvider(AclService aclService, List<Permission> requirePermission) {
        super(aclService, "AFTER_ACL_COLLECTION_READ", requirePermission);
    }

    @Override
    public Object decide(Authentication authentication, Object object, Collection<ConfigAttribute> config, Object returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            logger.debug((Object)"Return object is null, skipping");
            return null;
        }
        for (ConfigAttribute attr : config) {
            if (!this.supports(attr)) continue;
            Filterer filterer = this.getFilterer(returnedObject);
            for (Object domainObject : filterer) {
                if (domainObject == null || !this.getProcessDomainObjectClass().isAssignableFrom(domainObject.getClass()) || this.hasPermission(authentication, domainObject)) continue;
                filterer.remove(domainObject);
                logger.debug((Object)LogMessage.of(() -> "Principal is NOT authorised for element: " + domainObject));
            }
            return filterer.getFilteredObject();
        }
        return returnedObject;
    }

    private Filterer getFilterer(Object returnedObject) {
        if (returnedObject instanceof Collection) {
            return new CollectionFilterer((Collection)returnedObject);
        }
        if (returnedObject.getClass().isArray()) {
            return new ArrayFilterer<Object>((Object[])returnedObject);
        }
        throw new AuthorizationServiceException("A Collection or an array (or null) was required as the returnedObject, but the returnedObject was: " + returnedObject);
    }
}

