/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCostImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.query.QueryExtension;
import org.apache.kylin.query.engine.KylinConnectionConfig;
import org.apache.kylin.query.engine.SqlConverter;
import org.apache.kylin.query.engine.UdfRegistry;
import org.apache.kylin.query.schema.OlapSchema;

public class OlapRelUtil {
    private static final String CTX = "ctx=";

    private OlapRelUtil() {
    }

    public static RelNode toRel(String project, KylinConfig kylinConfig, String sql) throws SqlParseException {
        KylinConnectionConfig connectionConfig = KylinConnectionConfig.fromKapConfig(kylinConfig);
        CalciteSchema rootSchema = OlapRelUtil.createRootSchema(project, kylinConfig);
        String defaultSchemaName = "DEFAULT";
        Prepare.CatalogReader catalogReader = SqlConverter.createCatalogReader((CalciteConnectionConfig)connectionConfig, rootSchema, defaultSchemaName);
        LinkedHashSet<ReduceExpressionsRule.ProjectReduceExpressionsRule> optRules = new LinkedHashSet<ReduceExpressionsRule.ProjectReduceExpressionsRule>();
        optRules.add(CoreRules.PROJECT_REDUCE_EXPRESSIONS);
        HepProgram program = HepProgram.builder().addRuleCollection(optRules).build();
        HepPlanner planner = new HepPlanner(program, null, true, null, RelOptCostImpl.FACTORY);
        SqlConverter sqlConverter = new SqlConverter(connectionConfig, (RelOptPlanner)planner, catalogReader);
        RelRoot relRoot = sqlConverter.convertSqlToRelNode(sql);
        planner.setRoot(relRoot.rel);
        return planner.findBestExp();
    }

    private static CalciteSchema createRootSchema(String project, KylinConfig kylinConfig) {
        Map<String, List<TableDesc>> schemasMap = QueryExtension.getFactory().getSchemaMapExtension().getAuthorizedTablesAndColumns(kylinConfig, project, true, null, null);
        Map modelsMap = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).getModelsGroupbyTable();
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        schemasMap.forEach((schemaName, list) -> {
            OlapSchema olapSchema = new OlapSchema(kylinConfig, project, (String)schemaName, (List)schemasMap.get(schemaName), modelsMap);
            CalciteSchema schema = rootSchema.add(schemaName, (Schema)olapSchema);
            for (Map.Entry entry : UdfRegistry.allUdfMap.entries()) {
                schema.plus().add(((String)entry.getKey()).toUpperCase(Locale.ROOT), (Function)entry.getValue());
            }
        });
        return rootSchema;
    }

    public static String replaceDigestCtxValueByLayoutIdAndModelId(String digestId, long layoutId, String modelId) {
        if (layoutId <= 0L || "".equals(modelId)) {
            return digestId;
        }
        StringBuilder digestBuilder = new StringBuilder();
        char[] digestArray = digestId.toCharArray();
        char[] compareArray = CTX.toCharArray();
        int len = digestArray.length;
        for (int i = 0; i < len; ++i) {
            char c1 = digestArray[i];
            if (c1 == compareArray[0] && i + 3 < len && digestArray[i + 1] == compareArray[1] && digestArray[i + 2] == compareArray[2] && digestArray[i + 3] == compareArray[3]) {
                digestBuilder.append(CTX);
                i += 2;
                while (digestArray[i + 1] != ',' && digestArray[i + 1] != ')') {
                    ++i;
                }
                digestBuilder.append(modelId).append("_").append(layoutId);
                continue;
            }
            digestBuilder.append(c1);
        }
        return digestBuilder.toString();
    }

    public static RexNode isNotDistinctFrom(RelNode left, RelNode right, RexNode condition, List<Pair<Integer, Integer>> pairs, List<Boolean> filterNulls) {
        ArrayList leftKeys = new ArrayList();
        ArrayList rightKeys = new ArrayList();
        RexNode rexNode = RelOptUtil.splitJoinCondition((RelNode)left, (RelNode)right, (RexNode)condition, leftKeys, rightKeys, filterNulls);
        for (int i = 0; i < leftKeys.size(); ++i) {
            pairs.add((Pair<Integer, Integer>)new Pair(leftKeys.get(i), (Object)((Integer)rightKeys.get(i) + left.getRowType().getFieldCount())));
        }
        return rexNode;
    }
}

