/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.data.rest;

import com.fasterxml.classmate.ResolvedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import springfox.documentation.RequestHandler;
import springfox.documentation.RequestHandlerKey;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spring.data.rest.ActionSpecification;
import springfox.documentation.spring.data.rest.EntityContext;
import springfox.documentation.spring.web.WebMvcPatternsRequestConditionWrapper;
import springfox.documentation.spring.web.plugins.CombinedRequestHandler;
import springfox.documentation.spring.wrapper.NameValueExpression;
import springfox.documentation.spring.wrapper.RequestMappingInfo;

class SpringDataRestRequestHandler
implements RequestHandler {
    private final EntityContext entityContext;
    private final ActionSpecification actionSpecification;
    private final String contextPath;

    SpringDataRestRequestHandler(EntityContext entityContext, ActionSpecification actionSpecification) {
        this.contextPath = entityContext.contextPath();
        this.entityContext = entityContext;
        this.actionSpecification = actionSpecification;
    }

    @Override
    public Class<?> declaringClass() {
        return this.actionSpecification.getDeclaringClass().orElse(null);
    }

    @Override
    public boolean isAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.findAnnotation(annotation).isPresent();
    }

    @Override
    public springfox.documentation.spring.wrapper.PatternsRequestCondition getPatternsCondition() {
        return new WebMvcPatternsRequestConditionWrapper(this.contextPath, new PatternsRequestCondition(new String[]{this.actionSpecification.getPath()}));
    }

    @Override
    public String groupName() {
        return String.format("%s Entity", this.entityContext.getName());
    }

    @Override
    public String getName() {
        return this.actionSpecification.getName();
    }

    @Override
    public Set<RequestMethod> supportedMethods() {
        return this.actionSpecification.getSupportedMethods().stream().collect(Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet));
    }

    @Override
    public Set<MediaType> produces() {
        return this.actionSpecification.getProduces();
    }

    @Override
    public Set<MediaType> consumes() {
        return this.actionSpecification.getConsumes();
    }

    @Override
    public Set<NameValueExpression<String>> headers() {
        return new HashSet<NameValueExpression<String>>();
    }

    @Override
    public Set<NameValueExpression<String>> params() {
        return new HashSet<NameValueExpression<String>>();
    }

    @Override
    public <T extends Annotation> Optional<T> findAnnotation(Class<T> annotation) {
        if (this.getHandlerMethod() != null) {
            return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)this.getHandlerMethod().getMethod(), annotation));
        }
        return Optional.empty();
    }

    @Override
    public RequestHandlerKey key() {
        return new RequestHandlerKey(this.getPatternsCondition().getPatterns(), this.supportedMethods(), this.consumes(), this.produces());
    }

    @Override
    public List<ResolvedMethodParameter> getParameters() {
        return new ArrayList<ResolvedMethodParameter>(this.actionSpecification.getParameters());
    }

    @Override
    public ResolvedType getReturnType() {
        return this.actionSpecification.getReturnType();
    }

    @Override
    public <T extends Annotation> Optional<T> findControllerAnnotation(Class<T> annotation) {
        if (this.getHandlerMethod() != null) {
            return Optional.ofNullable(AnnotationUtils.findAnnotation((Class)this.getHandlerMethod().getBeanType(), annotation));
        }
        return Optional.empty();
    }

    @Override
    public HandlerMethod getHandlerMethod() {
        return this.actionSpecification.getHandlerMethod().orElse(null);
    }

    @Override
    public RequestMappingInfo<?> getRequestMapping() {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestHandler combine(RequestHandler other) {
        return new CombinedRequestHandler(this, other);
    }

    public String toString() {
        return new StringJoiner(", ", SpringDataRestRequestHandler.class.getSimpleName() + "{", "}").add("entityContext=" + this.entityContext).add("actionSpecification=" + this.actionSpecification).add("key=" + this.key()).toString();
    }
}

