/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.TreeRangeSetDeserializer;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.TreeRangeSet;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.project.NProjectManager;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class NDataLayoutDetails
extends RootPersistentEntity
implements Serializable {
    public static final String SEPARATOR = "-";
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="dataflow")
    private String modelId;
    @JsonProperty(value="layout")
    private long layoutId;
    @JsonProperty(value="fragment_range_set")
    @JsonDeserialize(using=TreeRangeSetDeserializer.class)
    private TreeRangeSet<Long> fragmentRangeSet = TreeRangeSet.create();
    @JsonProperty(value="partition_columns")
    private List<String> partitionColumns;
    @JsonProperty(value="zorder_by_columns")
    private List<String> zorderByColumns;
    @JsonProperty(value="max_compaction_file_size_in_bytes")
    private long maxCompactionFileSizeInBytes;
    @JsonProperty(value="min_compaction_file_size_in_bytes")
    private long minCompactionFileSizeInBytes;
    @JsonProperty(value="compaction_after_update")
    private boolean compactionAfterUpdate = NProjectManager.getProjectConfig(this.project).isCompactionAfterDataUpdateEnabled();
    @JsonProperty(value="location")
    private String location;
    @JsonProperty(value="num_of_files")
    private long numOfFiles;
    @JsonProperty(value="num_of_remove_files")
    private long numOfRemoveFiles;
    @JsonProperty(value="size_in_bytes")
    private long sizeInBytes;
    @JsonProperty(value="properties")
    private Map<String, String> properties;
    @JsonProperty(value="table_version")
    private long tableVersion;
    private final AtomicReference<Object> rangeFilterExpr = new AtomicReference();
    private KylinConfigExt config = null;

    public String resourceName() {
        return this.modelId + SEPARATOR + this.layoutId;
    }

    public MetadataType resourceType() {
        return MetadataType.LAYOUT_DETAILS;
    }

    public KylinConfig getConfig() {
        return this.config == null ? KylinConfig.getInstanceFromEnv() : this.config;
    }

    public String getLocation() {
        String result = this.location;
        if (StringUtils.isBlank((CharSequence)this.location)) {
            String hdfsWorkingDir = KapConfig.wrap((KylinConfig)this.getConfig()).getMetadataWorkingDirectory();
            String storagePath1WithoutPrefix = String.format(Locale.ROOT, "%s/delta/%s/%s", this.project, this.modelId, this.layoutId);
            result = hdfsWorkingDir + storagePath1WithoutPrefix;
        }
        return result;
    }

    public String genRangerFilterExpr() {
        NDataflowManager dfManager = NDataflowManager.getInstance(this.getConfig(), this.project);
        NDataflow df = dfManager.getDataflow(this.modelId);
        if (df.getModel().isIncrementBuildOnExpertMode()) {
            PartitionDesc partitionDesc = df.getModel().getPartitionDesc();
            PartitionDesc.IPartitionConditionBuilder conditionBuilder = partitionDesc.getPartitionConditionBuilder();
            String expr = this.fragmentRangeSet.asRanges().stream().map(longRange -> {
                SegmentRange.TimePartitionedSegmentRange segmentRange = new SegmentRange.TimePartitionedSegmentRange((Long)longRange.lowerEndpoint(), (Long)longRange.upperEndpoint());
                return conditionBuilder.buildDateRangeCondition(partitionDesc, null, segmentRange).replace(partitionDesc.getPartitionDateColumnRef().getBackTickExp(), "`" + df.getModel().getPartitionColumnId() + "`");
            }).reduce((current, res) -> res + " or " + current).orElse("");
            return expr;
        }
        return null;
    }

    public List<String> getPartitionColumns() {
        NDataflowManager dfManager = NDataflowManager.getInstance(this.getConfig(), this.project);
        NDataflow df = dfManager.getDataflow(this.modelId);
        if (this.partitionColumns == null || this.partitionColumns.isEmpty()) {
            String overrideConfig = df.getIndexPlan().getOverrideProps().get("kylin.model.layout.storage.v3-partition-by-columns");
            if (!StringUtils.isEmpty((CharSequence)overrideConfig)) {
                return Lists.newArrayList((Object[])overrideConfig.split("\u0001"));
            }
            return Lists.newArrayList();
        }
        return this.partitionColumns;
    }

    public List<String> getZorderByColumns() {
        NDataflowManager dfManager = NDataflowManager.getInstance(this.getConfig(), this.project);
        NDataflow df = dfManager.getDataflow(this.modelId);
        if (this.zorderByColumns == null || this.zorderByColumns.isEmpty()) {
            String overrideConfig = df.getIndexPlan().getOverrideProps().get("kylin.model.layout.storage.v3-zorder-by-columns");
            if (!StringUtils.isEmpty((CharSequence)overrideConfig)) {
                return Lists.newArrayList((Object[])overrideConfig.split("\u0001"));
            }
            return Lists.newArrayList();
        }
        return this.zorderByColumns;
    }

    public long getMaxCompactionFileSizeInBytes() {
        NDataflowManager dfManager = NDataflowManager.getInstance(this.getConfig(), this.project);
        NDataflow df = dfManager.getDataflow(this.modelId);
        if (this.maxCompactionFileSizeInBytes == 0L) {
            return Long.parseLong(df.getIndexPlan().getOverrideProps().getOrDefault("kylin.model.layout.storage.v3-max-file-size-in-bytes", "0"));
        }
        return this.maxCompactionFileSizeInBytes;
    }

    public long getMinCompactionFileSizeInBytes() {
        NDataflowManager dfManager = NDataflowManager.getInstance(this.getConfig(), this.project);
        NDataflow df = dfManager.getDataflow(this.modelId);
        if (this.minCompactionFileSizeInBytes == 0L) {
            return Long.parseLong(df.getIndexPlan().getOverrideProps().getOrDefault("kylin.model.layout.storage.v3-min-file-size-in-bytes", "0"));
        }
        return this.minCompactionFileSizeInBytes;
    }

    public String getRelativeStoragePath() {
        return this.project + "/delta/" + this.getModelId() + "/" + this.getLayoutId();
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public long getLayoutId() {
        return this.layoutId;
    }

    @Generated
    public TreeRangeSet<Long> getFragmentRangeSet() {
        return this.fragmentRangeSet;
    }

    @Generated
    public boolean isCompactionAfterUpdate() {
        return this.compactionAfterUpdate;
    }

    @Generated
    public long getNumOfFiles() {
        return this.numOfFiles;
    }

    @Generated
    public long getNumOfRemoveFiles() {
        return this.numOfRemoveFiles;
    }

    @Generated
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Generated
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Generated
    public long getTableVersion() {
        return this.tableVersion;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setLayoutId(long layoutId) {
        this.layoutId = layoutId;
    }

    @Generated
    public void setFragmentRangeSet(TreeRangeSet<Long> fragmentRangeSet) {
        this.fragmentRangeSet = fragmentRangeSet;
    }

    @Generated
    public void setPartitionColumns(List<String> partitionColumns) {
        this.partitionColumns = partitionColumns;
    }

    @Generated
    public void setZorderByColumns(List<String> zorderByColumns) {
        this.zorderByColumns = zorderByColumns;
    }

    @Generated
    public void setMaxCompactionFileSizeInBytes(long maxCompactionFileSizeInBytes) {
        this.maxCompactionFileSizeInBytes = maxCompactionFileSizeInBytes;
    }

    @Generated
    public void setMinCompactionFileSizeInBytes(long minCompactionFileSizeInBytes) {
        this.minCompactionFileSizeInBytes = minCompactionFileSizeInBytes;
    }

    @Generated
    public void setCompactionAfterUpdate(boolean compactionAfterUpdate) {
        this.compactionAfterUpdate = compactionAfterUpdate;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setNumOfFiles(long numOfFiles) {
        this.numOfFiles = numOfFiles;
    }

    @Generated
    public void setNumOfRemoveFiles(long numOfRemoveFiles) {
        this.numOfRemoveFiles = numOfRemoveFiles;
    }

    @Generated
    public void setSizeInBytes(long sizeInBytes) {
        this.sizeInBytes = sizeInBytes;
    }

    @Generated
    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Generated
    public void setTableVersion(long tableVersion) {
        this.tableVersion = tableVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public String getRangeFilterExpr() {
        Object value = this.rangeFilterExpr.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.rangeFilterExpr;
            synchronized (atomicReference) {
                value = this.rangeFilterExpr.get();
                if (value == null) {
                    String actualValue = this.genRangerFilterExpr();
                    value = actualValue == null ? this.rangeFilterExpr : actualValue;
                    this.rangeFilterExpr.set(value);
                }
            }
        }
        return (String)(value == this.rangeFilterExpr ? null : value);
    }

    @Generated
    public void setConfig(KylinConfigExt config) {
        this.config = config;
    }
}

