/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;

public class TableRef
implements Serializable {
    private final transient NDataModel model;
    private final String alias;
    private final TableDesc table;
    private final Map<String, TblColRef> columns;
    private final String modelId;

    public TableRef(NDataModel model, String alias, TableDesc table, boolean filterOutComputedColumns) {
        this.model = model;
        this.modelId = model.getUuid();
        this.alias = alias;
        this.table = table;
        this.columns = TableRef.filterColumns(table, filterOutComputedColumns).stream().collect(Collectors.toMap(ColumnDesc::getName, k -> new TblColRef(this, (ColumnDesc)k)));
    }

    public static Set<ColumnDesc> filterColumns(TableDesc table, boolean filterOutCC) {
        HashSet columns = Sets.newHashSet();
        for (ColumnDesc col : table.getColumns()) {
            if (filterOutCC && col.isComputedColumn()) continue;
            columns.add(col);
        }
        return columns;
    }

    public TableDesc getTableDesc() {
        return this.table;
    }

    public String getTableName() {
        return this.table.getName();
    }

    public String getTableIdentity() {
        return this.table.getIdentity();
    }

    public TblColRef getColumn(String name) {
        return this.columns.get(name);
    }

    public Collection<TblColRef> getColumns() {
        return Collections.unmodifiableCollection(this.columns.values());
    }

    public TblColRef makeFakeColumn(String name) {
        ColumnDesc colDesc = new ColumnDesc();
        colDesc.setName(name);
        colDesc.setTable(this.table);
        return new TblColRef(this, colDesc);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableRef t = (TableRef)o;
        return Objects.equals(this.modelId, t.modelId) && Objects.equals(this.alias, t.alias) && Objects.equals(this.table.getIdentity(), t.table.getIdentity());
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.modelId.hashCode();
        result = 31 * result + this.alias.hashCode();
        result = 31 * result + this.table.getIdentity().hashCode();
        return result;
    }

    public String toString() {
        if (this.alias.equals(this.table.getName())) {
            return "TableRef[" + this.table.getName() + "]";
        }
        return "TableRef[" + this.alias + ":" + this.table.getName() + "]";
    }

    @Generated
    public NDataModel getModel() {
        return this.model;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }
}

