/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.recommendation.ref;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

public abstract class RecommendationRef {
    private int id;
    private String name;
    private String content;
    private String dataType;
    private boolean isBroken;
    private boolean existed;
    private boolean crossModel;
    private boolean isExcluded;
    private Object entity;
    private List<RecommendationRef> dependencies = Lists.newArrayList();

    public abstract void rebuild(String var1);

    protected <T extends RecommendationRef> List<RecommendationRef> validate(List<T> refs) {
        if (CollectionUtils.isEmpty(refs)) {
            return Lists.newArrayList();
        }
        return refs.stream().filter(ref -> !ref.isBroken() && !ref.isExisted()).collect(Collectors.toList());
    }

    public boolean isEffective() {
        return !this.isBroken() && !this.isExisted() && this.getId() < 0;
    }

    public boolean isLegal() {
        return !this.isBroken() && (this.getId() >= 0 || !this.isExisted());
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getContent() {
        return this.content;
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public boolean isBroken() {
        return this.isBroken;
    }

    @Generated
    public boolean isExisted() {
        return this.existed;
    }

    @Generated
    public boolean isCrossModel() {
        return this.crossModel;
    }

    @Generated
    public boolean isExcluded() {
        return this.isExcluded;
    }

    @Generated
    public Object getEntity() {
        return this.entity;
    }

    @Generated
    public List<RecommendationRef> getDependencies() {
        return this.dependencies;
    }

    @Generated
    protected void setId(int id) {
        this.id = id;
    }

    @Generated
    protected void setName(String name) {
        this.name = name;
    }

    @Generated
    protected void setContent(String content) {
        this.content = content;
    }

    @Generated
    protected void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    protected void setBroken(boolean isBroken) {
        this.isBroken = isBroken;
    }

    @Generated
    protected void setExisted(boolean existed) {
        this.existed = existed;
    }

    @Generated
    protected void setCrossModel(boolean crossModel) {
        this.crossModel = crossModel;
    }

    @Generated
    protected void setExcluded(boolean isExcluded) {
        this.isExcluded = isExcluded;
    }

    @Generated
    protected void setEntity(Object entity) {
        this.entity = entity;
    }

    @Generated
    protected void setDependencies(List<RecommendationRef> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecommendationRef)) {
            return false;
        }
        RecommendationRef other = (RecommendationRef)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        if (this.isBroken() != other.isBroken()) {
            return false;
        }
        if (this.isExisted() != other.isExisted()) {
            return false;
        }
        if (this.isCrossModel() != other.isCrossModel()) {
            return false;
        }
        if (this.isExcluded() != other.isExcluded()) {
            return false;
        }
        Object this$entity = this.getEntity();
        Object other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        List<RecommendationRef> this$dependencies = this.getDependencies();
        List<RecommendationRef> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RecommendationRef;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        result = result * 59 + (this.isBroken() ? 79 : 97);
        result = result * 59 + (this.isExisted() ? 79 : 97);
        result = result * 59 + (this.isCrossModel() ? 79 : 97);
        result = result * 59 + (this.isExcluded() ? 79 : 97);
        Object $entity = this.getEntity();
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        List<RecommendationRef> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    @Generated
    public RecommendationRef() {
    }

    @Generated
    public String toString() {
        return "RecommendationRef(id=" + this.getId() + ", name=" + this.getName() + ", content=" + this.getContent() + ", isBroken=" + this.isBroken() + ", existed=" + this.isExisted() + ", crossModel=" + this.isCrossModel() + ", isExcluded=" + this.isExcluded() + ", entity=" + this.getEntity() + ", dependencies=" + this.getDependencies() + ")";
    }
}

