/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Context;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.interpreter.Scalar;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;

public class ValuesNode
implements Node {
    private final Sink sink;
    private final int fieldCount;
    private final ImmutableList<Row> rows;

    public ValuesNode(Compiler compiler, Values rel) {
        this.sink = compiler.sink(rel);
        this.fieldCount = rel.getRowType().getFieldCount();
        this.rows = ValuesNode.createRows(compiler, this.fieldCount, rel.getTuples());
    }

    private static ImmutableList<Row> createRows(Compiler compiler, int fieldCount, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        ArrayList<RexNode> nodes = new ArrayList<RexNode>();
        for (ImmutableList tuple : tuples) {
            nodes.addAll((Collection<RexNode>)tuple);
        }
        Scalar scalar = compiler.compile(nodes, null);
        Object[] values = new Object[nodes.size()];
        Context context = compiler.createContext();
        scalar.execute(context, values);
        ImmutableList.Builder rows = ImmutableList.builder();
        Object[] subValues = new Object[fieldCount];
        int n = tuples.size();
        for (int r = 0; r < n; ++r) {
            System.arraycopy(values, r * fieldCount, subValues, 0, fieldCount);
            rows.add((Object)Row.asCopy(subValues));
        }
        return rows.build();
    }

    @Override
    public void run() throws InterruptedException {
        for (Row row : this.rows) {
            this.sink.send(row);
        }
        this.sink.end();
    }
}

