/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.cache;

import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;

public class ProcessorListener<T> {
    private long resyncPeriodInMillis;
    private ZonedDateTime nextResync;
    private ResourceEventHandler<? super T> handler;

    public ProcessorListener(ResourceEventHandler<? super T> handler, long resyncPeriodInMillis) {
        this.resyncPeriodInMillis = resyncPeriodInMillis;
        this.handler = handler;
        this.determineNextResync(ZonedDateTime.now());
    }

    public void add(Notification<T> notification) {
        notification.handle(this.handler);
    }

    public void determineNextResync(ZonedDateTime now) {
        this.nextResync = now.plus(this.resyncPeriodInMillis, ChronoUnit.MILLIS);
    }

    public boolean shouldResync(ZonedDateTime now) {
        return this.resyncPeriodInMillis != 0L && (now.isAfter(this.nextResync) || now.equals(this.nextResync));
    }

    public ResourceEventHandler<? super T> getHandler() {
        return this.handler;
    }

    public static final class DeleteNotification<T>
    extends Notification<T> {
        private boolean unknownFinalState;

        public DeleteNotification(T oldObject) {
            this(oldObject, false);
        }

        public DeleteNotification(T oldObject, boolean unknownFinalState) {
            super(oldObject, null);
            this.unknownFinalState = unknownFinalState;
        }

        @Override
        public void handle(ResourceEventHandler<? super T> resourceEventHandler) {
            resourceEventHandler.onDelete(this.getOldObject(), this.unknownFinalState);
        }
    }

    public static final class AddNotification<T>
    extends Notification<T> {
        public AddNotification(T newObject) {
            super(null, newObject);
        }

        @Override
        public void handle(ResourceEventHandler<? super T> resourceEventHandler) {
            resourceEventHandler.onAdd(this.getNewObject());
        }
    }

    public static final class UpdateNotification<T>
    extends Notification<T> {
        public UpdateNotification(T oldObject, T newObject) {
            super(oldObject, newObject);
        }

        @Override
        public void handle(ResourceEventHandler<? super T> resourceEventHandler) {
            resourceEventHandler.onUpdate(this.getOldObject(), this.getNewObject());
        }
    }

    public static abstract class Notification<T> {
        private final T oldObject;
        private final T newObject;

        public Notification(T oldObject, T newObject) {
            this.oldObject = oldObject;
            this.newObject = newObject;
        }

        public T getOldObject() {
            return this.oldObject;
        }

        public T getNewObject() {
            return this.newObject;
        }

        public abstract void handle(ResourceEventHandler<? super T> var1);
    }
}

