/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.app;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTree;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTreeFactory;
import org.apache.kylin.metadata.cube.model.NCubeJoinedFlatTableDesc;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.streaming.CreateStreamingFlatTable;
import org.apache.kylin.streaming.CreateStreamingFlatTable$;
import org.apache.kylin.streaming.app.StreamingBuildApplication;
import org.apache.kylin.streaming.app.StreamingEntry$;
import org.apache.kylin.streaming.common.BuildJobEntry;
import org.apache.kylin.streaming.common.CreateFlatTableEntry;
import org.apache.kylin.streaming.common.MicroBatchEntry;
import org.apache.kylin.streaming.jobs.StreamingDFBuildJob;
import org.apache.kylin.streaming.jobs.StreamingJobUtils;
import org.apache.kylin.streaming.jobs.StreamingSegmentManager;
import org.apache.kylin.streaming.manager.StreamingJobManager;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.apache.kylin.streaming.request.StreamingJobStatsRequest;
import org.apache.kylin.streaming.rest.RestSupport;
import org.apache.kylin.streaming.util.JobKiller;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.StreamingQueryProgress;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005-w!B\u0010!\u0011\u0003Yc!B\u0017!\u0011\u0003q\u0003\"B\u001f\u0002\t\u0003q\u0004\"C \u0002\u0001\u0004\u0005\r\u0011\"\u0001A\u0011-\t\t,\u0001a\u0001\u0002\u0004%\t!a-\t\u0015\u0005e\u0016\u00011A\u0001B\u0003&\u0011\tC\u0004\u0002<\u0006!\t!!0\t\u000f\u0005%\u0017\u0001\"\u0001\u0002\u000e\u0019!Q\u0006\t\u0001C\u0011\u0015i\u0004\u0002\"\u0001G\u0011\u001d9\u0005B1A\u0005\u0002!Ca!\u0016\u0005!\u0002\u0013I\u0005b\u0002,\t\u0005\u0004%\ta\u0016\u0005\u00077\"\u0001\u000b\u0011\u0002-\t\u000fqC!\u0019!C\u0001;\"1\u0011\u000e\u0003Q\u0001\nyCqA\u001b\u0005C\u0002\u0013\u00051\u000e\u0003\u0004p\u0011\u0001\u0006I\u0001\u001c\u0005\ta\"A)\u0019!C\u0001c\"AA\u0010\u0003EC\u0002\u0013\u0005Q\u0010C\u0004\u0002\f!!\t!!\u0004\t\u000f\u0005U\u0001\u0002\"\u0001\u0002\u0018!9\u0011Q\f\u0005\u0005\u0002\u0005}\u0003bBA:\u0011\u0011\u0005\u0011Q\u000f\u0005\b\u0003{BA\u0011AA@\u0011\u001d\ty\t\u0003C\u0001\u0003#Cq!!&\t\t\u0003\t9\nC\u0004\u0002\u001c\"!\t!!\u0004\t\u000f\u0005u\u0005\u0002\"\u0001\u0002\u000e!9\u0011q\u0014\u0005\u0005B\u0005\u0005\u0006bBAU\u0011\u0011\u0005\u00131V\u0001\u000f'R\u0014X-Y7j]\u001e,e\u000e\u001e:z\u0015\t\t#%A\u0002baBT!a\t\u0013\u0002\u0013M$(/Z1nS:<'BA\u0013'\u0003\u0015Y\u0017\u0010\\5o\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001A\u0011A&A\u0007\u0002A\tq1\u000b\u001e:fC6LgnZ#oiJL8cA\u00010kA\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u0011%tG/\u001a:oC2T!A\u000f\u0014\u0002\u000bM\u0004\u0018M]6\n\u0005q:$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\nQ!\u001a8uef,\u0012!\u0011\t\u0003Y!\u00192\u0001C\"6!\taC)\u0003\u0002FA\tI2\u000b\u001e:fC6Lgn\u001a\"vS2$\u0017\t\u001d9mS\u000e\fG/[8o)\u0005\t\u0015a\u0004;bE2,'+\u001a4sKND\u0017iY2\u0016\u0003%\u0003\"AS*\u000e\u0003-S!\u0001T'\u0002\r\u0005$x.\\5d\u0015\tqu*\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001U)\u0002\tU$\u0018\u000e\u001c\u0006\u0002%\u0006!!.\u0019<b\u0013\t!6J\u0001\u0006Bi>l\u0017n\u0019'p]\u001e\f\u0001\u0003^1cY\u0016\u0014VM\u001a:fg\"\f5m\u0019\u0011\u0002'I\fG/\u001a+sS\u001e<WM\u001d#ve\u0006$\u0018n\u001c8\u0016\u0003a\u0003\"\u0001M-\n\u0005i\u000b$\u0001\u0002'p]\u001e\fAC]1uKR\u0013\u0018nZ4fe\u0012+(/\u0019;j_:\u0004\u0013\u0001D7j]6\u000b\u0007PQ;gM\u0016\u0014X#\u00010\u0011\u0007}#g-D\u0001a\u0015\t\t'-A\u0004nkR\f'\r\\3\u000b\u0005\r\f\u0014AC2pY2,7\r^5p]&\u0011Q\r\u0019\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u00031ObC\u0016B\u000152\u0005\u0019!V\u000f\u001d7fe\u0005iQ.\u001b8NCb\u0014UO\u001a4fe\u0002\nAb\u001a:bG\u00164W\u000f\\*u_B,\u0012\u0001\u001c\t\u0003\u00156L!A\\&\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u000359'/Y2fMVd7\u000b^8qA\u0005AA-\u0019;bM2|w/F\u0001s!\t\u0019(0D\u0001u\u0015\t)h/A\u0003n_\u0012,GN\u0003\u0002xq\u0006!1-\u001e2f\u0015\tIH%\u0001\u0005nKR\fG-\u0019;b\u0013\tYHOA\u0005O\t\u0006$\u0018M\u001a7po\u00069AO]5hO\u0016\u0014X#\u0001@\u0011\u0007}\f9!\u0004\u0002\u0002\u0002)\u00191%a\u0001\u000b\u0007\u0005\u0015\u0011(A\u0002tc2LA!!\u0003\u0002\u0002\t9AK]5hO\u0016\u0014\u0018!\u00033p\u000bb,7-\u001e;f)\t\ty\u0001E\u00021\u0003#I1!a\u00052\u0005\u0011)f.\u001b;\u00027M$\u0018M\u001d;SK\u0006dG/[7f\u0005VLG\u000eZ*ue\u0016\fW.\u001b8h)!\tI\"!\n\u00022\u0005-\u0003\u0003BA\u000e\u0003Ci!!!\b\u000b\u0007\u0005}!%\u0001\u0003k_\n\u001c\u0018\u0002BA\u0012\u0003;\u00111c\u0015;sK\u0006l\u0017N\\4E\r\n+\u0018\u000e\u001c3K_\nDq!a\n\u0016\u0001\u0004\tI#A\btiJ,\u0017-\u001c$mCR$\u0016M\u00197f!\u0011\tY#!\f\u000e\u0003\tJ1!a\f#\u0005a\u0019%/Z1uKN#(/Z1nS:<g\t\\1u)\u0006\u0014G.\u001a\u0005\b\u0003g)\u0002\u0019AA\u001b\u0003)!\u0018.\\3D_2,XN\u001c\t\u0005\u0003o\t)E\u0004\u0003\u0002:\u0005\u0005\u0003cAA\u001ec5\u0011\u0011Q\b\u0006\u0004\u0003\u007fQ\u0013A\u0002\u001fs_>$h(C\u0002\u0002DE\na\u0001\u0015:fI\u00164\u0017\u0002BA$\u0003\u0013\u0012aa\u0015;sS:<'bAA\"c!9\u0011QJ\u000bA\u0002\u0005=\u0013!B9vKJL\bCBA)\u0003'\n9&\u0004\u0002\u0002\u0004%!\u0011QKA\u0002\u0005\u001d!\u0015\r^1tKR\u0004B!!\u0015\u0002Z%!\u00111LA\u0002\u0005\r\u0011vn^\u0001\u0012aJ|7-Z:t\u001b&\u001c'o\u001c\"bi\u000eDGCBA\b\u0003C\n\t\bC\u0004\u0002dY\u0001\r!!\u001a\u0002\u001f5L7M]8CCR\u001c\u0007.\u00128uef\u0004B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003W\u0012\u0013AB2p[6|g.\u0003\u0003\u0002p\u0005%$aD'jGJ|')\u0019;dQ\u0016sGO]=\t\u000bq3\u0002\u0019\u00010\u0002=\u001d,g.\u001a:bi\u0016\u001cFO]3b[F+XM]=G_J|e.Z'pI\u0016dGCAA<!%\u0001\u0014\u0011PA(\u0003k\tI#C\u0002\u0002|E\u0012a\u0001V;qY\u0016\u001c\u0014AE2sK\u0006$Xm\u00159b]:Lgn\u001a+sK\u0016$B!!!\u0002\u000eB!\u00111QAE\u001b\t\t)IC\u0002\u0002\bZ\faaY;c_&$\u0017\u0002BAF\u0003\u000b\u0013QBT*qC:t\u0017N\\4Ue\u0016,\u0007\"\u00029\u0019\u0001\u0004\u0011\u0018aF:uCJ$H+\u00192mKJ+gM]3tQRC'/Z1e)\u0011\ty!a%\t\u000f\u0005\u001d\u0012\u00041\u0001\u0002*\u0005a!/\u001a4sKNDG+\u00192mKR!\u0011qBAM\u0011\u001d\t9C\u0007a\u0001\u0003S\taC]3hSN$XM]*ue\u0016\fW\u000eT5ti\u0016tWM]\u0001\u0014C\u0012$7\u000b[;uI><h\u000eT5ti\u0016tWM]\u0001\fO\u0016$8\u000b^8q\r2\fw\r\u0006\u0002\u0002$B\u0019\u0001'!*\n\u0007\u0005\u001d\u0016GA\u0004C_>dW-\u00198\u0002\u0017M,Go\u0015;pa\u001ac\u0017m\u001a\u000b\u0005\u0003\u001f\ti\u000bC\u0004\u00020z\u0001\r!a)\u0002\u0011M$x\u000e\u001d$mC\u001e\f\u0011\"\u001a8uef|F%Z9\u0015\t\u0005=\u0011Q\u0017\u0005\t\u0003o#\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\u0002\r\u0015tGO]=!\u0003\u0011i\u0017-\u001b8\u0015\t\u0005=\u0011q\u0018\u0005\b\u0003\u00034\u0001\u0019AAb\u0003\u0011\t'oZ:\u0011\u000bA\n)-!\u000e\n\u0007\u0005\u001d\u0017GA\u0003BeJ\f\u00170\u0001\u0003ti>\u0004\b")
public class StreamingEntry
extends StreamingBuildApplication
implements Logging {
    private NDataflow dataflow;
    private Trigger trigger;
    private final AtomicLong tableRefreshAcc;
    private final long rateTriggerDuration;
    private final ArrayBuffer<Tuple2<Object, Object>> minMaxBuffer;
    private final AtomicBoolean gracefulStop;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static void stop() {
        StreamingEntry$.MODULE$.stop();
    }

    public static void main(String[] stringArray) {
        StreamingEntry$.MODULE$.main(stringArray);
    }

    public static void entry_$eq(StreamingEntry streamingEntry) {
        StreamingEntry$.MODULE$.entry_$eq(streamingEntry);
    }

    public static StreamingEntry entry() {
        return StreamingEntry$.MODULE$.entry();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public AtomicLong tableRefreshAcc() {
        return this.tableRefreshAcc;
    }

    public long rateTriggerDuration() {
        return this.rateTriggerDuration;
    }

    public ArrayBuffer<Tuple2<Object, Object>> minMaxBuffer() {
        return this.minMaxBuffer;
    }

    public AtomicBoolean gracefulStop() {
        return this.gracefulStop;
    }

    private NDataflow dataflow$lzycompute() {
        StreamingEntry streamingEntry = this;
        synchronized (streamingEntry) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dataflow = NDataflowManager.getInstance((KylinConfig)this.kylinConfig, (String)this.project).getDataflow(this.dataflowId);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dataflow;
    }

    public NDataflow dataflow() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dataflow$lzycompute() : this.dataflow;
    }

    private Trigger trigger$lzycompute() {
        StreamingEntry streamingEntry = this;
        synchronized (streamingEntry) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.trigger = this.kylinConfig.getTriggerOnce() ? Trigger.Once() : Trigger.ProcessingTime((long)(this.durationSec * 1000));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.trigger;
    }

    public Trigger trigger() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.trigger$lzycompute() : this.trigger;
    }

    @Override
    public void doExecute() {
        this.log().info("StreamingEntry:{}, {}, {}, {}", new Object[]{this.project, this.dataflowId, String.valueOf(this.durationSec), this.distMetaUrl});
        Preconditions.checkState((NProjectManager.getInstance((KylinConfig)this.kylinConfig).getProject(this.project) != null ? 1 : 0) != 0, (String)"metastore can not find this project %s", (Object[])new Object[]{this.project});
        this.registerStreamListener();
        Tuple3<Dataset<Row>, String, CreateStreamingFlatTable> tuple3 = this.generateStreamQueryForOneModel();
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        Dataset query = (Dataset)tuple3._1();
        String timeColumn = (String)tuple3._2();
        CreateStreamingFlatTable streamFlatTable = (CreateStreamingFlatTable)((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)query, (Object)timeColumn, (Object)streamFlatTable);
        Tuple3 tuple33 = tuple32;
        Dataset query2 = (Dataset)tuple33._1();
        String timeColumn2 = (String)tuple33._2();
        CreateStreamingFlatTable streamFlatTable2 = (CreateStreamingFlatTable)((Object)tuple33._3());
        Preconditions.checkState((query2 != null ? 1 : 0) != 0, (String)new StringBuilder(65).append("generate query for one model failed for project:  ").append(this.project).append(" dataflowId: %s").toString(), (Object[])new Object[]{this.dataflowId});
        Preconditions.checkState((timeColumn2 != null ? 1 : 0) != 0, (String)new StringBuilder(77).append("streaming query must have time partition column for project:  ").append(this.project).append(" dataflowId: %s").toString(), (Object[])new Object[]{this.dataflowId});
        StreamingDFBuildJob builder = this.startRealtimeBuildStreaming(streamFlatTable2, timeColumn2, (Dataset<Row>)query2);
        this.addShutdownListener();
        this.startTableRefreshThread(streamFlatTable2);
        while (!this.ss.sparkContext().isStopped()) {
            Boolean bl;
            if (this.getStopFlag()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.ss.streams().active())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.stop();
                    return BoxedUnit.UNIT;
                });
                builder.shutdown();
                this.setStopFlag(false);
                this.closeSparkSession();
                bl = BoxedUnit.UNIT;
                continue;
            }
            bl = BoxesRunTime.boxToBoolean((boolean)this.ss.streams().awaitAnyTermination(10000L));
        }
        this.closeAuditLogStore(this.ss);
        this.systemExit(0);
    }

    public StreamingDFBuildJob startRealtimeBuildStreaming(CreateStreamingFlatTable streamFlatTable, String timeColumn, Dataset<Row> query) {
        NSpanningTree nSpanningTree = this.createSpanningTree(this.dataflow());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("start query for model : ").append(streamFlatTable.model().toString()).toString());
        StreamingDFBuildJob builder = new StreamingDFBuildJob(this.project);
        query.writeStream().option("checkpointLocation", new StringBuilder(1).append(this.baseCheckpointLocation).append("/").append(streamFlatTable.model().getId()).toString()).foreachBatch((Function2 & Serializable & scala.Serializable)(batchDF, batchId) -> {
            StreamingEntry.$anonfun$startRealtimeBuildStreaming$2(this, timeColumn, streamFlatTable, nSpanningTree, builder, batchDF, BoxesRunTime.unboxToLong((Object)batchId));
            return BoxedUnit.UNIT;
        }).queryName("StreamingEntry").trigger(this.trigger()).start();
        return builder;
    }

    public void processMicroBatch(MicroBatchEntry microBatchEntry, ArrayBuffer<Tuple2<Object, Object>> minMaxBuffer) {
        Dataset batchDF = microBatchEntry.batchDF().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        long flatTableCount = batchDF.count();
        String timeColumn = microBatchEntry.timeColumn();
        Row minMaxTime = (Row)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batchDF.agg(functions$.MODULE$.min(functions$.MODULE$.col(timeColumn)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(functions$.MODULE$.col(timeColumn))})).collect())).head();
        long batchId = microBatchEntry.batchId();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("start process batch: ").append(batchId).append(" minMaxTime is ").append(minMaxTime).toString());
        if (minMaxTime.getTimestamp(0) != null && minMaxTime.getTimestamp(1) != null) {
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(minMaxTime.getTimestamp(0).getTime(), minMaxTime.getTimestamp(1).getTime());
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            long minTime = sp2._1$mcJ$sp();
            long maxTime = sp2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(minTime, maxTime);
            Tuple2.mcJJ.sp sp4 = sp3;
            long minTime2 = sp4._1$mcJ$sp();
            long maxTime2 = sp4._2$mcJ$sp();
            minMaxBuffer.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcJJ.sp(minTime2, maxTime2)}));
            NDataSegment batchSeg = StreamingSegmentManager.allocateSegment(this.ss, microBatchEntry.sr(), this.dataflowId, this.project, Predef$.MODULE$.long2Long(minTime2), Predef$.MODULE$.long2Long(maxTime2));
            if (batchSeg != null && !StringUtils.isEmpty((CharSequence)batchSeg.getId())) {
                microBatchEntry.streamFlatTable().seg_$eq(batchSeg);
                Dataset<Row> encodedStreamDataset = microBatchEntry.streamFlatTable().encodeStreamingDataset(batchSeg, microBatchEntry.df().getModel(), (Dataset<Row>)batchDF);
                BuildJobEntry batchBuildJob = new BuildJobEntry(this.ss, this.project, this.dataflowId, flatTableCount, batchSeg, encodedStreamDataset, microBatchEntry.nSpanningTree());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("start build streaming segment: ").append(batchSeg.toString()).append(" spark batchId: ").append(batchId).toString());
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> batchBuildJob.toString());
                microBatchEntry.builder().streamBuild(batchBuildJob);
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("end build streaming segment: ").append(batchSeg.toString()).append(" spark batchId: ").append(batchId).toString());
            }
        }
        batchDF.unpersist(true);
    }

    public Tuple3<Dataset<Row>, String, CreateStreamingFlatTable> generateStreamQueryForOneModel() {
        KylinConfig originConfig = KylinConfig.getInstanceFromEnv();
        String parserName = this.dataflow().getModel().getRootFactTable().getTableDesc().getKafkaConfig().getParserName();
        NCubeJoinedFlatTableDesc flatTableDesc = new NCubeJoinedFlatTableDesc(this.dataflow().getIndexPlan());
        NSpanningTree nSpanningTree = this.createSpanningTree(this.dataflow());
        String partitionColumn = NSparkCubingUtil.convertFromDot((String)this.dataflow().getModel().getPartitionDesc().getBackTickPartitionDateColumn());
        CreateFlatTableEntry flatTableEntry = new CreateFlatTableEntry((IJoinedFlatTableDesc)flatTableDesc, null, nSpanningTree, this.ss, null, partitionColumn, this.watermark, parserName);
        CreateStreamingFlatTable flatTable = CreateStreamingFlatTable$.MODULE$.apply(flatTableEntry);
        StreamingJobManager streamingJobMgr = StreamingJobManager.getInstance(originConfig, this.project);
        StreamingJobMeta jobMeta = streamingJobMgr.getStreamingJobByUuid(this.jobId);
        KylinConfig config = StreamingJobUtils.getStreamingKylinConfig(originConfig, this.getJobParams(jobMeta), this.dataflowId, this.project);
        Dataset<Row> flatDataset = flatTable.generateStreamingDataset(config);
        return new Tuple3(flatDataset, (Object)partitionColumn, (Object)flatTable);
    }

    public NSpanningTree createSpanningTree(NDataflow dataflow) {
        Set layouts = StreamingUtils.getToBuildLayouts((NDataflow)dataflow);
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty((Collection)layouts), (String)"layouts is empty", (Object[])new Object[]{layouts});
        return NSpanningTreeFactory.fromLayouts((Collection)layouts, (String)this.dataflowId);
    }

    public void startTableRefreshThread(CreateStreamingFlatTable streamFlatTable) {
        if (!streamFlatTable.shouldRefreshTable()) {
            return;
        }
        Thread tableRefreshThread = new Thread(this){
            private final /* synthetic */ StreamingEntry $outer;

            public void run() {
                while (this.$outer.isRunning()) {
                    this.$outer.tableRefreshAcc().getAndAdd(1L);
                    StreamingUtils.sleep((long)this.$outer.rateTriggerDuration());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        tableRefreshThread.setDaemon(true);
        tableRefreshThread.start();
    }

    public void refreshTable(CreateStreamingFlatTable streamFlatTable) {
        block0: {
            if (!streamFlatTable.shouldRefreshTable() || this.tableRefreshAcc().get() <= streamFlatTable.tableRefreshInterval()) break block0;
            this.log().info("refresh dimension tables.");
            streamFlatTable.lookupTablesGlobal().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Dataset df = (Dataset)tuple2._2();
                Dataset dataset = df.unpersist(true);
                return dataset;
            });
            streamFlatTable.loadLookupTables();
            this.tableRefreshAcc().set(0L);
        }
    }

    public void registerStreamListener() {
        this.ss.streams().addListener(new StreamingQueryListener(this){
            private final /* synthetic */ StreamingEntry $outer;

            public void onQueryStarted(StreamingQueryListener.QueryStartedEvent queryStarted) {
            }

            public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent queryTerminated) {
            }

            public void onQueryProgress(StreamingQueryListener.QueryProgressEvent queryProgress) {
                StreamingQueryProgress progress = queryProgress.progress();
                long batchRows = progress.numInputRows();
                long time = StreamingEntry.org$apache$kylin$streaming$app$StreamingEntry$$getTime$1(progress.timestamp());
                long now = System.currentTimeMillis();
                long minDataLatency = 0L;
                long maxDataLatency = 0L;
                if (this.$outer.minMaxBuffer().nonEmpty()) {
                    minDataLatency = now - ((Tuple2)this.$outer.minMaxBuffer().apply(0))._1$mcJ$sp() + (long)(this.$outer.durationSec * 1000);
                    maxDataLatency = now - ((Tuple2)this.$outer.minMaxBuffer().apply(0))._2$mcJ$sp() + (long)(this.$outer.durationSec * 1000);
                    this.$outer.minMaxBuffer().clear();
                }
                long durationMs = (Long)progress.durationMs().get("triggerExecution");
                StreamingJobStatsRequest request = new StreamingJobStatsRequest(this.$outer.jobId, this.$outer.project, Predef$.MODULE$.long2Long(batchRows), Predef$.MODULE$.double2Double((double)(batchRows / (long)this.$outer.durationSec)), Predef$.MODULE$.long2Long(durationMs), Predef$.MODULE$.long2Long(time), Predef$.MODULE$.long2Long(minDataLatency), Predef$.MODULE$.long2Long(maxDataLatency));
                try (RestSupport rest = this.$outer.createRestSupport(this.$outer.kylinConfig);){
                    try {
                        request.setJobExecutionId(Predef$.MODULE$.Integer2int(this.$outer.jobExecId));
                        request.setJobType(this.$outer.jobType.name());
                        rest.execute((HttpRequestBase)rest.createHttpPut("/streaming_jobs/stats"), request);
                    }
                    catch (Exception e) {
                        this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Streaming Stats Rest Request Failed...", e);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onQueryProgress$1()}, serializedLambda);
            }
        });
    }

    public void addShutdownListener() {
        this.ss.streams().addListener(new StreamingQueryListener(this){
            private final /* synthetic */ StreamingEntry $outer;

            public void onQueryStarted(StreamingQueryListener.QueryStartedEvent event) {
            }

            public void onQueryProgress(StreamingQueryListener.QueryProgressEvent event) {
                block0: {
                    StreamingUtils.replayAuditlog();
                    if (!this.$outer.isGracefulShutdown(this.$outer.project, this.$outer.jobId)) break block0;
                    this.$outer.log().info(new StringBuilder(56).append("onQueryProgress begin to shutdown streaming build job (").append(event).append(")").toString());
                    this.$outer.setStopFlag(true);
                }
            }

            public void onQueryTerminated(StreamingQueryListener.QueryTerminatedEvent event) {
                this.$outer.log().info(new StringBuilder(58).append("onQueryTerminated begin to shutdown streaming build job (").append(event).append(")").toString());
                JobKiller.killApplication(this.$outer.jobId);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public boolean getStopFlag() {
        return this.gracefulStop().get();
    }

    @Override
    public void setStopFlag(boolean stopFlag) {
        this.gracefulStop().set(stopFlag);
    }

    public static final /* synthetic */ void $anonfun$startRealtimeBuildStreaming$2(StreamingEntry $this, String timeColumn$1, CreateStreamingFlatTable streamFlatTable$1, NSpanningTree nSpanningTree$1, StreamingDFBuildJob builder$1, Dataset batchDF, long batchId) {
        MicroBatchEntry microBatchEntry = new MicroBatchEntry((Dataset<Row>)batchDF, batchId, timeColumn$1, streamFlatTable$1, $this.dataflow(), nSpanningTree$1, builder$1, null);
        $this.processMicroBatch(microBatchEntry, $this.minMaxBuffer());
        $this.refreshTable(streamFlatTable$1);
    }

    public static final long org$apache$kylin$streaming$app$StreamingEntry$$getTime$1(String time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault(Locale.Category.FORMAT));
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.parse(time).getTime();
    }

    public StreamingEntry() {
        Logging.$init$((Logging)this);
        this.tableRefreshAcc = new AtomicLong();
        this.rateTriggerDuration = TimeUnit.MINUTES.toMillis(1L);
        this.minMaxBuffer = new ArrayBuffer(1);
        this.gracefulStop = new AtomicBoolean(false);
    }
}

