/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.MetadataChecker;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Assert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

@MetadataInfo(onlyProps=true)
public class MetadataStoreTest {
    @Test
    public void testVerify(@TempDir File junitFolder) throws Exception {
        ResourceTool.copy(TestUtils.getTestConfig(), KylinConfig.createInstanceFromUri((String)junitFolder.getAbsolutePath()), "ALL");
        TestUtils.getTestConfig().setMetadataUrl(junitFolder.getAbsolutePath());
        MetadataStore metadataStore = MetadataStore.createMetadataStore((KylinConfig)TestUtils.getTestConfig());
        MetadataChecker metadataChecker = new MetadataChecker(metadataStore);
        Paths.get(junitFolder.getAbsolutePath(), "IllegalFile.json").toFile().createNewFile();
        MetadataChecker.VerifyResult verifyResultWithIllegalFile = metadataChecker.verify();
        ((IterableAssert)Assertions.assertThat((Iterable)verifyResultWithIllegalFile.getIllegalFiles()).hasSize(1)).contains((Object[])new String[]{"IllegalFile"});
        Assert.assertFalse((boolean)verifyResultWithIllegalFile.isQualified());
        Paths.get(junitFolder.getAbsolutePath(), "/IllegalFile.json").toFile().delete();
        Paths.get(junitFolder.getAbsolutePath(), "/IllegalProject").toFile().mkdir();
        Paths.get(junitFolder.getAbsolutePath(), "IllegalProject/test.json").toFile().createNewFile();
        MetadataChecker.VerifyResult verifyResultWithIllegalProject = metadataChecker.verify();
        ((IterableAssert)Assertions.assertThat((Iterable)verifyResultWithIllegalProject.getIllegalTables()).hasSize(1)).contains((Object[])new String[]{"IllegalProject"});
        ((IterableAssert)Assertions.assertThat((Iterable)verifyResultWithIllegalProject.getIllegalFiles()).hasSize(1)).contains((Object[])new String[]{"IllegalProject/test"});
        Assert.assertFalse((boolean)verifyResultWithIllegalProject.isQualified());
        Paths.get(junitFolder.getAbsolutePath(), "/IllegalProject/test.json").toFile().delete();
        Paths.get(junitFolder.getAbsolutePath(), "/IllegalProject").toFile().delete();
        Paths.get(junitFolder.getAbsolutePath(), "/legalProject").toFile().mkdir();
        Paths.get(junitFolder.getAbsolutePath(), "/PROJECT").toFile().mkdir();
        Paths.get(junitFolder.getAbsolutePath(), "PROJECT/legalProject.json").toFile().createNewFile();
        MetadataChecker.VerifyResult verifyResultWithLegalProject = metadataChecker.verify();
        Assertions.assertThat((Iterable)verifyResultWithLegalProject.getIllegalFiles()).isEmpty();
        Assertions.assertThat((Iterable)verifyResultWithLegalProject.getIllegalTables()).isEmpty();
        Assert.assertTrue((boolean)verifyResultWithLegalProject.isQualified());
        Assert.assertFalse((boolean)metadataChecker.verify().isExistUUIDFile());
        Paths.get(junitFolder.getAbsolutePath(), "/SYSTEM").toFile().mkdir();
        Paths.get(junitFolder.getAbsolutePath(), "SYSTEM/UUID.json").toFile().createNewFile();
        Assert.assertTrue((boolean)metadataChecker.verify().isExistUUIDFile());
        Assert.assertFalse((boolean)metadataChecker.verify().isExistUserGroupFile());
        Files.createFile(Paths.get(junitFolder.getAbsolutePath(), "/USER_GROUP"), new FileAttribute[0]);
        Assert.assertTrue((boolean)metadataChecker.verify().isExistUserGroupFile());
        Assert.assertFalse((boolean)metadataChecker.verify().isExistUserDir());
        Paths.get(junitFolder.getAbsolutePath(), "/USER_INFO").toFile().mkdir();
        Files.createFile(Paths.get(junitFolder.getAbsolutePath(), "USER_INFO/ADMIN.json"), new FileAttribute[0]);
        Assert.assertTrue((boolean)metadataChecker.verify().isExistUserDir());
        Assert.assertFalse((boolean)metadataChecker.verify().isExistACLDir());
        Paths.get(junitFolder.getAbsolutePath(), MetadataType.OBJECT_ACL.name()).toFile().mkdir();
        Files.createFile(Paths.get(junitFolder.getAbsolutePath(), MetadataType.OBJECT_ACL.name() + "/test.json"), new FileAttribute[0]);
        Assert.assertTrue((boolean)metadataChecker.verify().isExistACLDir());
    }
}

