/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.junit.After;
import org.junit.Before;

public class LogOutputTestCase
extends NLocalFileMetadataTestCase {
    @Before
    public void createLoggerAppender() {
        LoggerContext context = (LoggerContext)LogManager.getContext();
        Configuration configuration = context.getConfiguration();
        MockAppender loggerAppender = new MockAppender();
        configuration.addAppender((Appender)loggerAppender);
        Logger logger = (Logger)LogManager.getLogger((String)"");
        logger.addAppender(configuration.getAppender("mock"));
    }

    @After
    public void removeLoggerAppender() {
        LoggerContext context = (LoggerContext)LogManager.getContext();
        Configuration configuration = context.getConfiguration();
        Logger logger = (Logger)LogManager.getLogger((String)"");
        logger.removeAppender(configuration.getAppender("mock"));
        configuration.removeLogger("mock");
    }

    protected boolean containsLog(String log) {
        return this.getMockAppender().events.contains(log);
    }

    protected void clearLogs() {
        MockAppender appender = this.getMockAppender();
        if (appender != null) {
            appender.events.clear();
        }
    }

    MockAppender getMockAppender() {
        Logger logger = (Logger)LogManager.getLogger((String)"");
        return (MockAppender)((Object)logger.getAppenders().get("mock"));
    }

    public static class MockAppender
    extends AbstractAppender {
        public List<String> events = new ArrayList<String>();

        protected MockAppender() {
            super("mock", null, (Layout)PatternLayout.createDefaultLayout(), true, new Property[0]);
        }

        public void close() {
        }

        public boolean requiresLayout() {
            return false;
        }

        public void append(LogEvent event) {
            this.events.add(event.getMessage().getFormattedMessage());
        }
    }
}

