/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.kylin.common.util.StringHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StringHelperTest {
    StringHelperTest() {
    }

    @Test
    void testMin() {
        Assertions.assertEquals((Object)"", (Object)StringHelper.min(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringHelper.min((String)"", null));
        Assertions.assertEquals((Object)"1", (Object)StringHelper.min((String)"1", (String)"2"));
    }

    @Test
    void testMax() {
        Assertions.assertEquals((Object)"", (Object)StringHelper.max(null, (String)""));
        Assertions.assertEquals((Object)"", (Object)StringHelper.max((String)"", null));
        Assertions.assertEquals((Object)"2", (Object)StringHelper.max((String)"1", (String)"2"));
    }

    @Test
    void testValidateBoolean() {
        Assertions.assertTrue((boolean)StringHelper.validateBoolean((String)"true"));
        Assertions.assertTrue((boolean)StringHelper.validateBoolean((String)"false"));
    }

    @Test
    void testBacktickToDoubleQuote() {
        Assertions.assertEquals((Object)"\"a\".\"b\" + 1", (Object)StringHelper.backtickToDoubleQuote((String)"`a`.`b` + 1"));
        Assertions.assertEquals((Object)"concat(ifnull(\"a\".\"b\", '-'), '\\\\', ifnull(\"c\".\"d\", '-'))", (Object)StringHelper.backtickToDoubleQuote((String)"concat(ifnull(`a`.`b`, '-'), '\\\\', ifnull(`c`.`d`, '-'))"));
        Assertions.assertEquals((Object)"concat('''', ifnull(\"c\".\"d\", '-'))", (Object)StringHelper.backtickToDoubleQuote((String)"concat('\\'', ifnull(`c`.`d`, '-'))"));
        Assertions.assertEquals((Object)"concat('\\\\\\\\', ifnull(\"c\".\"d\", '-'))", (Object)StringHelper.backtickToDoubleQuote((String)"concat('\\\\\\\\', ifnull(`c`.`d`, '-'))"));
        Assertions.assertEquals((Object)"concat(''', ifnull(`c`.`d`, 1)', '-')", (Object)StringHelper.backtickToDoubleQuote((String)"concat('\\', ifnull(`c`.`d`, 1)', '-')"));
    }

    @Test
    void testDoubleQuoteToBackTick() {
        Assertions.assertEquals((Object)"`a`.`b` + '\\'1'", (Object)StringHelper.doubleQuoteToBacktick((String)"\"a\".\"b\" + '''1'"));
        Assertions.assertEquals((Object)"concat(ifnull(`a`.`b`, '-'), '\\\\', ifnull(`c`.`d`, '-'))", (Object)StringHelper.doubleQuoteToBacktick((String)"concat(ifnull(\"a\".\"b\", '-'), '\\\\', ifnull(\"c\".\"d\", '-'))"));
        Assertions.assertEquals((Object)"concat('\\'', ifnull(`c`.`d`, '-'))", (Object)StringHelper.doubleQuoteToBacktick((String)"concat('\\'', ifnull(\"c\".\"d\", '-'))"));
        Assertions.assertEquals((Object)"concat('\\\\\\\\', ifnull(`c`.`d`, '-'))", (Object)StringHelper.doubleQuoteToBacktick((String)"concat('\\\\\\\\', ifnull(\"c\".\"d\", '-'))"));
        Assertions.assertEquals((Object)"concat('\\', ifnull(\"c\".\"d\", 1)', '-')", (Object)StringHelper.doubleQuoteToBacktick((String)"concat('\\', ifnull(\"c\".\"d\", 1)', '-')"));
    }

    @Test
    void testBacktickQuote() {
        Assertions.assertEquals((Object)"`aa`", (Object)StringHelper.backtickQuote((String)"aa"));
    }

    @Test
    void testDoubleQuote() {
        Assertions.assertEquals((Object)"\"aa\"", (Object)StringHelper.doubleQuote((String)"aa"));
    }

    @Test
    void testSubArray() {
        String[] arr = new String[]{"a", "b", "c"};
        try {
            StringHelper.subArray((String[])arr, (int)-1, (int)1);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            StringHelper.subArray((String[])arr, (int)2, (int)1);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        try {
            StringHelper.subArray((String[])arr, (int)1, (int)5);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof IllegalArgumentException));
        }
        String[] arrNew = StringHelper.subArray((String[])arr, (int)0, (int)2);
        Assertions.assertEquals((int)2, (int)arrNew.length);
        Assertions.assertEquals((Object)"a", (Object)arrNew[0]);
        Assertions.assertEquals((Object)"b", (Object)arrNew[1]);
    }

    @Test
    void testSplitAndTrim() {
        String[] arr = StringHelper.splitAndTrim((String)"a, ,b, c", (String)",");
        Assertions.assertEquals((int)3, (int)arr.length);
        Assertions.assertEquals((Object)"a", (Object)arr[0]);
        Assertions.assertEquals((Object)"b", (Object)arr[1]);
        Assertions.assertEquals((Object)"c", (Object)arr[2]);
    }

    @Test
    void testValidateUrl() {
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"127.0.0.1"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"kylin.apache.org"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"kylin"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"http://127.0.0.1"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"https://kylin.apache.org"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"http://kylin"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"http://127.0.0.1/a_p.i"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"https://kylin.apache.org/api/te-st/"));
        Assertions.assertTrue((boolean)StringHelper.validateUrl((String)"http://kylin/"));
    }

    @Test
    void testValidIllegalUrl() {
        Assertions.assertFalse((boolean)StringHelper.validateUrl((String)"http://kylin/$(rm -rf /)"));
        Assertions.assertFalse((boolean)StringHelper.validateUrl((String)"http://kylin/`rm -rf`"));
        Assertions.assertFalse((boolean)StringHelper.validateUrl((String)"http://kylin/'&ls"));
        Assertions.assertFalse((boolean)StringHelper.validateUrl((String)"http://kylin/;ls"));
        Assertions.assertFalse((boolean)StringHelper.validateUrl((String)"http://kylin/>ls"));
        Assertions.assertFalse((boolean)StringHelper.validateUrl((String)""));
    }

    @Test
    void testValidateHost() {
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"127.0.0.1"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"kylin.apache.org"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"kylin"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"http://127.0.0.1"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"http://127.0.0.1:80"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"https://kylin.apache.org"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"http://kylin"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"http://ky-lin"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"http://ky.lin"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"http://ky_lin"));
        Assertions.assertTrue((boolean)StringHelper.validateHost((String)"http://ky_lin:80"));
    }

    @Test
    void testValidIllegalHost() {
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://127.0.0.1/a_p.i"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://127.0.0.1:80/"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://kylin/"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://kylin/$(rm -rf /)"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://kylin/`rm -rf`"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://kylin/'&ls"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://kylin/;ls"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://kylin/>ls"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)""));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://ky-lin:80/"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://ky.lin/"));
        Assertions.assertFalse((boolean)StringHelper.validateHost((String)"http://ky_lin/"));
    }

    @Test
    void testValidateDB() {
        Assertions.assertTrue((boolean)StringHelper.validateDbName((String)"db_TEST-01"));
        Assertions.assertFalse((boolean)StringHelper.validateDbName((String)"db&&ls"));
    }

    @Test
    void testValidateArgument() {
        Assertions.assertTrue((boolean)StringHelper.validateShellArgument((String)"-job"));
        Assertions.assertTrue((boolean)StringHelper.validateShellArgument((String)"uuid-uuid-uuid-uuid"));
        Assertions.assertTrue((boolean)StringHelper.validateShellArgument((String)"-JobId"));
        Assertions.assertTrue((boolean)StringHelper.validateShellArgument((String)"/o-pt.5.0-3/kylin/te_st"));
        Assertions.assertFalse((boolean)StringHelper.validateShellArgument((String)"`ls`"));
        Assertions.assertFalse((boolean)StringHelper.validateShellArgument((String)"$(ls)"));
        Assertions.assertFalse((boolean)StringHelper.validateShellArgument((String)"&&"));
    }

    @Test
    void testEscapeArguments() {
        Assertions.assertEquals((Object)"", (Object)StringHelper.escapeShellArguments((String)""));
        Assertions.assertEquals((Object)"-u 'root'", (Object)StringHelper.escapeShellArguments((String)"-u   root  "));
        Assertions.assertEquals((Object)"-u 'root'", (Object)StringHelper.escapeShellArguments((String)"-u   'root'  "));
        Assertions.assertEquals((Object)"-u \\''root'\\'", (Object)StringHelper.escapeShellArguments((String)"-u   ''root''  "));
        Assertions.assertEquals((Object)"-u \\'", (Object)StringHelper.escapeShellArguments((String)"-u '"));
        Assertions.assertEquals((Object)"-u ", (Object)StringHelper.escapeShellArguments((String)"-u ''"));
        Assertions.assertEquals((Object)"-u 'root'", (Object)StringHelper.escapeShellArguments((String)"-u root"));
        Assertions.assertEquals((Object)"-UserName 'root'", (Object)StringHelper.escapeShellArguments((String)"-UserName root"));
        Assertions.assertEquals((Object)"-user='root'", (Object)StringHelper.escapeShellArguments((String)"-user=root"));
        Assertions.assertEquals((Object)"-user='ro=ot'", (Object)StringHelper.escapeShellArguments((String)"-user=ro=ot"));
        Assertions.assertEquals((Object)"-u 'root'\\''$(ls)'", (Object)StringHelper.escapeShellArguments((String)"-u root'$(ls)"));
        Assertions.assertEquals((Object)"-UserName 'root'\\''$(ls)'", (Object)StringHelper.escapeShellArguments((String)"-UserName root'$(ls)"));
        Assertions.assertEquals((Object)"-user='roo'\\''$(ls)t'", (Object)StringHelper.escapeShellArguments((String)"-user=roo'$(ls)t"));
        Assertions.assertEquals((Object)"-user='roo'\\''$(ls)'\\''t'", (Object)StringHelper.escapeShellArguments((String)"-user='roo'$(ls)'t'"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringHelper.escapeShellArguments((String)"u root"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> StringHelper.escapeShellArguments((String)"-u.ser root"));
    }
}

