/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.VersionedRawResource;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.persistence.transaction.ITransactionManager;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.io.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataStore
implements ITransactionManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetadataStore.class);
    static final Set<String> IMMUTABLE_PREFIX = Sets.newHashSet((Object[])new String[]{"SYSTEM/UUID"});
    static final String PATH_DELIMITER = "/";
    AuditLogStore auditLogStore;

    public static MetadataStore createMetadataStore(KylinConfig config) {
        StorageURL url = config.getMetadataUrl();
        log.info("Creating metadata store by KylinConfig {} from {}", (Object)config, (Object)url.toString());
        String clsName = config.getMetadataStoreImpls().get(url.getScheme());
        try {
            Class<MetadataStore> cls = ClassUtil.forName(clsName, MetadataStore.class);
            return cls.getConstructor(KylinConfig.class).newInstance(config);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create metadata store", e);
        }
    }

    public MetadataStore(KylinConfig kylinConfig) {
    }

    public abstract NavigableSet<String> listAll();

    public abstract void dump(ResourceStore var1) throws IOException, InterruptedException, ExecutionException;

    public void dump(ResourceStore store, Collection<String> resources) throws Exception {
        for (String resPath : resources) {
            RawResource raw = store.getResource(resPath);
            this.save(raw.getMetaType(), raw);
        }
    }

    public void uploadFromFile(File folder) {
        MetadataStore.foreachFile(folder, res -> {
            try {
                if (IMMUTABLE_PREFIX.contains(res.getMetaKey())) {
                    return;
                }
                this.save(res.getMetaType(), (RawResource)res);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("put resource " + res.getMetaKey() + " failed", e);
            }
        });
    }

    static void foreachFile(File root, Consumer<RawResource> resourceConsumer) {
        if (!root.exists()) {
            return;
        }
        Collection files = FileUtils.listFiles((File)root, null, (boolean)true);
        files.forEach(f -> {
            try (FileInputStream fis = new FileInputStream((File)f);){
                RawResource raw;
                String resPath = f.getPath().replace(root.getPath() + PATH_DELIMITER, "");
                ByteSource bs = ByteSource.wrap((byte[])IOUtils.toByteArray((InputStream)fis));
                if (resPath.contains(PATH_DELIMITER)) {
                    Pair<MetadataType, String> meteKeyAndType = MetadataType.splitKeyWithType(resPath);
                    raw = RawResource.constructResource(meteKeyAndType.getFirst(), bs);
                    raw.setMetaKey(meteKeyAndType.getSecond());
                    raw.setTs(f.lastModified());
                } else {
                    raw = new RawResource(resPath, bs, f.lastModified(), 0L);
                }
                resourceConsumer.accept(raw);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("cannot not read file " + f, e);
            }
        });
    }

    public abstract MemoryMetaData reloadAll() throws IOException;

    public abstract <T extends RawResource> List<T> get(MetadataType var1, RawResourceFilter var2, boolean var3, boolean var4);

    public abstract int save(MetadataType var1, RawResource var2);

    @Generated
    public AuditLogStore getAuditLogStore() {
        return this.auditLogStore;
    }

    @Generated
    public void setAuditLogStore(AuditLogStore auditLogStore) {
        this.auditLogStore = auditLogStore;
    }

    public static class MemoryMetaData {
        private final Map<MetadataType, Map<String, VersionedRawResource>> data;
        private Long offset;

        private MemoryMetaData(Map<MetadataType, Map<String, VersionedRawResource>> data) {
            this.data = data;
        }

        public static MemoryMetaData createEmpty() {
            ConcurrentHashMap<MetadataType, Map<String, VersionedRawResource>> data = new ConcurrentHashMap<MetadataType, Map<String, VersionedRawResource>>();
            MetadataType.NEED_CACHED_METADATA.forEach(type -> {
                Map cfr_ignored_0 = data.put((MetadataType)((Object)type), MetadataType.CASE_INSENSITIVE_METADATA.contains(type) ? new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER) : new ConcurrentHashMap());
            });
            return new MemoryMetaData(data);
        }

        public boolean containOffset() {
            return this.offset != null;
        }

        public void put(MetadataType type, VersionedRawResource versionedRawResource) {
            if (MetadataType.NEED_CACHED_METADATA.contains((Object)type)) {
                this.data.get((Object)type).put(versionedRawResource.getRawResource().getMetaKey(), versionedRawResource);
            }
        }

        @Generated
        public Map<MetadataType, Map<String, VersionedRawResource>> getData() {
            return this.data;
        }

        @Generated
        public Long getOffset() {
            return this.offset;
        }

        @Generated
        public void setOffset(Long offset) {
            this.offset = offset;
        }
    }
}

