/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.util.Application;
import org.apache.kylin.common.util.OptionsHelper;

public abstract class ExecutableApplication
implements Application {
    protected abstract Options getOptions();

    protected abstract void execute(OptionsHelper var1) throws Exception;

    public OptionsHelper convertToOptionsHelper(String[] args) {
        OptionsHelper optionsHelper = new OptionsHelper();
        try {
            optionsHelper.parseOptions(this.getOptions(), args);
        }
        catch (ParseException e) {
            optionsHelper.printUsage("error parsing args ", this.getOptions());
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_PARSE_SHELL, "error parsing args", e);
        }
        return optionsHelper;
    }

    @Override
    public void execute(String[] args) {
        OptionsHelper optionsHelper = this.convertToOptionsHelper(args);
        try {
            this.execute(optionsHelper);
        }
        catch (Exception e) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_EXECUTE_SHELL, "error execute " + this.getClass().getName(), e);
        }
    }
}

