/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;

public class CancelFlag {
    public final AtomicBoolean atomicBoolean;
    private static final ThreadLocal<CancelFlag> CONTEXT_CANCEL_FLAG = ThreadLocal.withInitial(() -> new CancelFlag(new AtomicBoolean(false)));

    public CancelFlag(AtomicBoolean atomicBoolean) {
        this.atomicBoolean = (AtomicBoolean)Preconditions.checkNotNull((Object)atomicBoolean);
    }

    public static CancelFlag getContextCancelFlag() {
        return CONTEXT_CANCEL_FLAG.get();
    }

    public boolean isCancelRequested() {
        return this.atomicBoolean.get();
    }

    public void requestCancel() {
        this.atomicBoolean.compareAndSet(false, true);
    }

    public void clearCancel() {
        this.atomicBoolean.compareAndSet(true, false);
    }
}

