/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class PagingUtil {
    private PagingUtil() {
    }

    public static <T> List<T> cutPage(List<T> full, int pageOffset, int pageSize) {
        if (full == null) {
            return Collections.emptyList();
        }
        int begin = pageOffset * pageSize;
        int end = begin + pageSize;
        return PagingUtil.cut(full, begin, end);
    }

    private static <T> List<T> cut(List<T> full, int begin, int end) {
        if (begin >= full.size()) {
            return Collections.emptyList();
        }
        if (end > full.size()) {
            end = full.size();
        }
        return full.subList(begin, end);
    }

    public static List<String> getIdentifierAfterFuzzyMatching(String nameSeg, boolean isCaseSensitive, Collection<String> l) {
        ArrayList<String> identifier = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)nameSeg)) {
            identifier.addAll(l);
        } else {
            for (String u : l) {
                if (!isCaseSensitive && StringUtils.containsIgnoreCase((CharSequence)u, (CharSequence)nameSeg)) {
                    identifier.add(u);
                }
                if (!isCaseSensitive || !StringUtils.contains((CharSequence)u, (CharSequence)nameSeg)) continue;
                identifier.add(u);
            }
        }
        Collections.sort(identifier);
        return identifier;
    }

    public static boolean isInCurrentPage(int totalSize, int offset, int limit) {
        return totalSize >= offset * limit && totalSize < offset * limit + limit;
    }
}

