/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Locale;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.Quoting;
import org.apache.calcite.config.Lex;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigCannotInitException;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.query.engine.PrepareSqlStateParam;
import org.apache.kylin.rest.exception.InternalErrorException;

public class PrepareSQLUtils {
    private static final char LITERAL_QUOTE = '\'';
    private static final char PARAM_PLACEHOLDER = '?';

    private PrepareSQLUtils() {
    }

    public static String fillInParams(String prepareSQL, PrepareSqlStateParam[] params) {
        int paramIdx;
        int startOffset = 0;
        int placeHolderIdx = -1;
        char identQuoting = PrepareSQLUtils.identQuoting();
        placeHolderIdx = PrepareSQLUtils.findNextPlaceHolder(prepareSQL, startOffset, identQuoting);
        for (paramIdx = 0; placeHolderIdx != -1 && paramIdx < params.length; ++paramIdx) {
            String paramLiteral = PrepareSQLUtils.convertToLiteralString(params[paramIdx]);
            prepareSQL = prepareSQL.substring(0, placeHolderIdx) + paramLiteral + prepareSQL.substring(placeHolderIdx + 1);
            startOffset = placeHolderIdx + paramLiteral.length();
            placeHolderIdx = PrepareSQLUtils.findNextPlaceHolder(prepareSQL, startOffset, identQuoting);
        }
        if (paramIdx != params.length) {
            throw new IllegalStateException(String.format(Locale.ROOT, "Invalid PrepareStatement, failed to match params with place holders, sql: %s, params: %s", prepareSQL, Arrays.stream(params).map(PrepareSqlStateParam::getValue)));
        }
        return prepareSQL;
    }

    private static String convertToLiteralString(PrepareSqlStateParam param) {
        Object value = PrepareSQLUtils.getValue(param);
        if (value == null) {
            return "NULL";
        }
        if (value instanceof String) {
            if (param.getClassName().equals(BigDecimal.class.getCanonicalName())) {
                return (String)value;
            }
            return '\'' + (String)value + '\'';
        }
        if (value instanceof Date) {
            return String.format(Locale.ROOT, "date'%s'", DateFormat.formatToDateStr((long)((Date)value).getTime()));
        }
        if (value instanceof Timestamp) {
            return String.format(Locale.ROOT, "timestamp'%s'", DateFormat.formatToTimeStr((long)((Timestamp)value).getTime()));
        }
        return String.valueOf(value);
    }

    private static Object getValue(PrepareSqlStateParam param) {
        boolean isNull;
        Class<?> clazz;
        try {
            clazz = Class.forName(param.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new InternalErrorException((Throwable)e);
        }
        ColumnMetaData.Rep type = ColumnMetaData.Rep.of(clazz);
        String value = param.getValue();
        boolean bl = isNull = null == value;
        if (isNull || value.isEmpty()) {
            return PrepareSQLUtils.getEmptyValue(type, isNull);
        }
        return PrepareSQLUtils.getTypedValue(type, value);
    }

    private static Object getEmptyValue(ColumnMetaData.Rep type, boolean isNull) {
        switch (type) {
            case PRIMITIVE_CHAR: 
            case CHARACTER: 
            case STRING: {
                return isNull ? null : "";
            }
            case PRIMITIVE_INT: 
            case INTEGER: {
                return 0;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                return (short)0;
            }
            case PRIMITIVE_LONG: 
            case LONG: {
                return 0L;
            }
            case PRIMITIVE_FLOAT: 
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case PRIMITIVE_DOUBLE: 
            case DOUBLE: {
                return 0.0;
            }
            case PRIMITIVE_BOOLEAN: 
            case BOOLEAN: {
                return false;
            }
            case PRIMITIVE_BYTE: 
            case BYTE: {
                return (byte)0;
            }
        }
        return null;
    }

    private static Object getTypedValue(ColumnMetaData.Rep type, String value) {
        switch (type) {
            case PRIMITIVE_INT: 
            case INTEGER: {
                return Integer.parseInt(value);
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                return Short.parseShort(value);
            }
            case PRIMITIVE_LONG: 
            case LONG: {
                return Long.parseLong(value);
            }
            case PRIMITIVE_FLOAT: 
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case PRIMITIVE_DOUBLE: 
            case DOUBLE: {
                return Double.parseDouble(value);
            }
            case PRIMITIVE_BOOLEAN: 
            case BOOLEAN: {
                return Boolean.parseBoolean(value);
            }
            case PRIMITIVE_BYTE: 
            case BYTE: {
                return Byte.parseByte(value);
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_DATE: {
                return Date.valueOf(value);
            }
            case JAVA_SQL_TIME: {
                return Time.valueOf(value);
            }
            case JAVA_SQL_TIMESTAMP: {
                return Timestamp.valueOf(value);
            }
        }
        return value;
    }

    private static int findNextPlaceHolder(String prepareSQL, int start, char identQuoting) {
        boolean openingIdentQuote = false;
        boolean openingLiteralQuote = false;
        while (start < prepareSQL.length()) {
            if (prepareSQL.charAt(start) == '\'') {
                openingLiteralQuote = !openingLiteralQuote;
            } else if (!openingLiteralQuote && prepareSQL.charAt(start) == identQuoting) {
                boolean bl = openingIdentQuote = !openingIdentQuote;
            }
            if (openingLiteralQuote || openingIdentQuote) {
                ++start;
                continue;
            }
            if (prepareSQL.charAt(start) == '?') {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private static char identQuoting() {
        KylinConfig kylinConfig;
        try {
            kylinConfig = KylinConfig.getInstanceFromEnv();
        }
        catch (KylinConfigCannotInitException e) {
            return Quoting.DOUBLE_QUOTE.string.charAt(0);
        }
        String quoting = (String)kylinConfig.getCalciteExtrasProperties().get("quoting");
        if (quoting != null) {
            return Quoting.valueOf((String)quoting).string.charAt(0);
        }
        String lex = (String)kylinConfig.getCalciteExtrasProperties().get("lex");
        if (lex != null) {
            return Lex.valueOf((String)lex).quoting.string.charAt(0);
        }
        return Quoting.DOUBLE_QUOTE.string.charAt(0);
    }
}

