/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.builder.NBuildSourceInfo;
import org.apache.kylin.engine.spark.job.DFChooser;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTree;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTreeFactory;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@Deprecated
public class ResourceDetectBeforeCubingJob
extends SparkApplication {
    protected volatile NSpanningTree nSpanningTree;
    protected static final Logger logger = LoggerFactory.getLogger(ResourceDetectBeforeCubingJob.class);

    @Override
    protected void doExecute() throws Exception {
        String dataflowId = this.getParam("dataflowId");
        HashSet segmentIds = Sets.newHashSet((Object[])StringUtils.split((String)this.getParam("segmentIds")));
        Set layoutIds = NSparkCubingUtil.str2Longs((String)this.getParam("layoutIds"));
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
        IndexPlan indexPlan = dfMgr.getDataflow(dataflowId).getIndexPlan();
        Set cuboids = NSparkCubingUtil.toLayouts((IndexPlan)indexPlan, (Set)layoutIds).stream().filter(Objects::nonNull).collect(Collectors.toSet());
        this.nSpanningTree = NSpanningTreeFactory.fromLayouts(cuboids, (String)dataflowId);
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), ResourceDetectUtils.countDistinctSuffix()), (Object)ResourceDetectUtils.findCountDistinctMeasure(cuboids));
        for (String segId : segmentIds) {
            ArrayList<NBuildSourceInfo> sources = new ArrayList<NBuildSourceInfo>();
            NDataSegment seg = dfMgr.getDataflow(dataflowId).getSegment(segId);
            if (Objects.isNull(seg)) {
                logger.info("Skip empty segment {}", (Object)segId);
                continue;
            }
            DFChooser datasetChooser = new DFChooser(this.nSpanningTree, seg, this.jobId, this.ss, this.config, false);
            datasetChooser.decideSources();
            NBuildSourceInfo buildFromFlatTable = datasetChooser.flatTableSource();
            if (buildFromFlatTable != null) {
                sources.add(buildFromFlatTable);
            }
            Map<Long, NBuildSourceInfo> buildFromLayouts = datasetChooser.reuseSources();
            sources.addAll(buildFromLayouts.values());
            HashMap resourceSize = Maps.newHashMap();
            HashMap layoutLeafTaskNums = Maps.newHashMap();
            this.infos.clearSparkPlans();
            for (NBuildSourceInfo source : sources) {
                Dataset<Row> dataset = source.getParentDS();
                String leafNodeNum = ResourceDetectUtils.getPartitions((SparkPlan)dataset.queryExecution().executedPlan());
                logger.info("leaf nodes is: {} ", (Object)leafNodeNum);
                this.infos.recordSparkPlan(dataset.queryExecution().sparkPlan());
                List paths = JavaConversions.seqAsJavaList((Seq)ResourceDetectUtils.getPaths((SparkPlan)dataset.queryExecution().sparkPlan(), (boolean)true));
                resourceSize.put(String.valueOf(source.getLayoutId()), ResourceDetectUtils.getResourceSize((KylinConfig)this.config, (Configuration)SparderEnv.getHadoopConfiguration(), (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(paths.iterator()).asScala()).toSeq()));
                layoutLeafTaskNums.put(String.valueOf(source.getLayoutId()), Integer.parseInt(leafNodeNum));
            }
            ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), segId + "_" + ResourceDetectUtils.fileName()), (Object)resourceSize);
            ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), segId + "_" + ResourceDetectUtils.cubingDetectItemFileSuffix()), (Object)layoutLeafTaskNums);
        }
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeCubingJobInfo();
    }

    public static void main(String[] args) {
        ResourceDetectBeforeCubingJob resourceDetectJob = new ResourceDetectBeforeCubingJob();
        resourceDetectJob.execute(args);
    }
}

