/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.FileSystemMetadataStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.merger.AfterBuildResourceMerger;
import org.apache.kylin.engine.spark.merger.AfterLoadingInternalTableMerger;
import org.apache.kylin.engine.spark.merger.AfterMergeOrRefreshResourceMerger;
import org.apache.kylin.engine.spark.merger.AfterSamplingMerger;
import org.apache.kylin.engine.spark.merger.AfterSnapshotMerger;
import org.apache.kylin.engine.spark.utils.SparkJobFactoryUtils;
import org.apache.kylin.guava30.shaded.common.collect.BiMap;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.MergerInfo;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetails;
import org.apache.kylin.metadata.cube.model.NDataLayoutDetailsManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataMerger {
    private static final Logger log = LoggerFactory.getLogger(MetadataMerger.class);
    private final String project;
    private final KylinConfig config;

    protected MetadataMerger(KylinConfig config, String project) {
        this.config = config;
        this.project = project;
    }

    public KylinConfig getProjectConfig(ResourceStore remoteStore) throws IOException {
        MetadataStore metaStore = remoteStore.getMetadataStore();
        assert (metaStore instanceof FileSystemMetadataStore);
        KylinConfig globalConfig = ((FileSystemMetadataStore)metaStore).getKylinConfigFromFile();
        Map projectConfig = ((ProjectInstance)JsonUtil.readValue((byte[])remoteStore.getResource(MetadataType.mergeKeyWithType((String)this.project, (MetadataType)MetadataType.PROJECT)).getByteSource().read(), ProjectInstance.class)).getLegalOverrideKylinProps();
        return KylinConfigExt.createInstance((KylinConfig)globalConfig, (Map)projectConfig);
    }

    public void merge(AbstractExecutable abstractExecutable) {
        MergerInfo.TaskMergeInfo taskMergeInfo = new MergerInfo.TaskMergeInfo(abstractExecutable, SparkJobFactoryUtils.needBuildSnapshots(abstractExecutable));
        this.merge(taskMergeInfo);
    }

    public abstract <T> T merge(MergerInfo.TaskMergeInfo var1);

    protected void mergeSnapshotMeta(NDataflow dataflow, ResourceStore remoteResourceStore) {
        if (!this.isSnapshotManualManagementEnabled(remoteResourceStore)) {
            NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteResourceStore.getConfig(), (String)this.getProject());
            NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
            dataflow.getModel().getLookupTables().stream().sorted(Comparator.comparing(TableRef::getTableIdentity)).forEach(remoteTableRef -> {
                String tableName = remoteTableRef.getTableIdentity();
                TableDesc localTbDesc = localTblMgr.getTableDesc(tableName);
                TableDesc remoteTbDesc = remoteTblMgr.getTableDesc(tableName);
                if (remoteTbDesc == null) {
                    return;
                }
                TableDesc copy = localTblMgr.copyForWrite(localTbDesc);
                copy.setLastSnapshotPath(remoteTbDesc.getLastSnapshotPath());
                copy.setLastSnapshotSize(remoteTbDesc.getLastSnapshotSize());
                copy.setSnapshotLastModified(remoteTbDesc.getSnapshotLastModified());
                copy.setSnapshotTotalRows(remoteTbDesc.getSnapshotTotalRows());
                localTblMgr.updateTableDesc(copy);
            });
        }
    }

    protected void mergeTableExtMeta(NDataflow dataflow, ResourceStore remoteResourceStore) {
        NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteResourceStore.getConfig(), (String)this.getProject());
        NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        dataflow.getModel().getLookupTables().stream().sorted(Comparator.comparing(TableRef::getTableIdentity)).forEach(remoteTableRef -> {
            String tableName = remoteTableRef.getTableIdentity();
            TableDesc localTbDesc = localTblMgr.getTableDesc(tableName);
            TableDesc remoteTbDesc = remoteTblMgr.getTableDesc(tableName);
            if (remoteTbDesc == null) {
                return;
            }
            TableExtDesc remoteTblExtDesc = remoteTblMgr.getOrCreateTableExt(remoteTbDesc);
            TableExtDesc copyExt = localTblMgr.copyForWrite(localTblMgr.getOrCreateTableExt(localTbDesc));
            if (remoteTblExtDesc.getOriginalSize() != -1L) {
                copyExt.setOriginalSize(remoteTblExtDesc.getOriginalSize());
            }
            copyExt.setTotalRows(remoteTblExtDesc.getTotalRows());
            localTblMgr.saveTableExt(copyExt);
        });
    }

    protected boolean isSnapshotManualManagementEnabled(ResourceStore configStore) {
        try {
            KylinConfig projectConfig = this.getProjectConfig(configStore);
            if (!projectConfig.isSnapshotManualManagementEnabled()) {
                return false;
            }
        }
        catch (IOException e) {
            log.error("Fail to get project config.");
        }
        return true;
    }

    public NDataSegment upsertSegmentPartition(NDataSegment localSegment, NDataSegment newSegment, Set<Long> partitionIds) {
        localSegment.getMultiPartitions().removeIf(partition -> partitionIds.contains(partition.getPartitionId()));
        List<SegmentPartition> upsertPartitions = newSegment.getMultiPartitions().stream().filter(partition -> partitionIds.contains(partition.getPartitionId())).collect(Collectors.toList());
        long lastBuildTime = System.currentTimeMillis();
        upsertPartitions.forEach(partition -> {
            partition.setStatus(PartitionStatusEnum.READY);
            partition.setLastBuildTime(lastBuildTime);
        });
        localSegment.getMultiPartitions().addAll(upsertPartitions);
        List partitions = localSegment.getMultiPartitions();
        localSegment.setSourceCount(partitions.stream().mapToLong(SegmentPartition::getSourceCount).sum());
        if (localSegment.getDimensionRangeInfoMap().isEmpty()) {
            localSegment.setDimensionRangeInfoMap(newSegment.getDimensionRangeInfoMap());
        } else if (newSegment.getDimensionRangeInfoMap().isEmpty()) {
            localSegment.setDimensionRangeInfoMap(localSegment.getDimensionRangeInfoMap());
        } else {
            HashMap mergeDimRangeInfo = Maps.newHashMap();
            BiMap dimCols = newSegment.getDataflow().getIndexPlan().getEffectiveDimCols();
            Map<String, DimensionRangeInfo> calcDimRangeInfoMap = localSegment.getDimensionRangeInfoMap().entrySet().stream().filter(dim -> dimCols.containsKey((Object)Integer.parseInt((String)dim.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Map<String, DimensionRangeInfo> storedDimRangeInfoMap = newSegment.getDimensionRangeInfoMap().entrySet().stream().filter(dim -> dimCols.containsKey((Object)Integer.parseInt((String)dim.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Set<String> combinedKeys = Stream.concat(calcDimRangeInfoMap.keySet().stream(), storedDimRangeInfoMap.keySet().stream()).collect(Collectors.toSet());
            combinedKeys.forEach(column -> {
                DimensionRangeInfo rangeInfo1 = (DimensionRangeInfo)calcDimRangeInfoMap.get(column);
                DimensionRangeInfo rangeInfo2 = (DimensionRangeInfo)storedDimRangeInfoMap.get(column);
                DimensionRangeInfo updateDimRangeInfo = rangeInfo1.merge(rangeInfo2, ((TblColRef)dimCols.get((Object)Integer.parseInt(column))).getType());
                mergeDimRangeInfo.put(column, updateDimRangeInfo);
            });
            localSegment.setDimensionRangeInfoMap((Map)mergeDimRangeInfo);
        }
        HashMap merged = Maps.newHashMap();
        partitions.stream().map(SegmentPartition::getColumnSourceBytes).forEach(item -> item.forEach((k, v) -> merged.put(k, v + merged.getOrDefault(k, 0L))));
        localSegment.setColumnSourceBytes((Map)merged);
        localSegment.setLastBuildTime(newSegment.getLastBuildTime());
        localSegment.setSourceBytesSize(newSegment.getSourceBytesSize());
        localSegment.setLastBuildTime(lastBuildTime);
        return localSegment;
    }

    public NDataLayout upsertLayoutPartition(NDataLayout localLayout, NDataLayout newLayout, Set<Long> partitionIds) {
        if (localLayout == null) {
            return newLayout;
        }
        localLayout.getMultiPartition().removeIf(partition -> partitionIds.contains(partition.getPartitionId()));
        List upsertLayouts = newLayout.getMultiPartition().stream().filter(partition -> partitionIds.contains(partition.getPartitionId())).collect(Collectors.toList());
        localLayout.getMultiPartition().addAll(upsertLayouts);
        List partitions = localLayout.getMultiPartition();
        localLayout.setRows(partitions.stream().mapToLong(LayoutPartition::getRows).sum());
        localLayout.setSourceRows(partitions.stream().mapToLong(LayoutPartition::getSourceRows).sum());
        localLayout.setFileCount(partitions.stream().mapToLong(LayoutPartition::getFileCount).sum());
        localLayout.setByteSize(partitions.stream().mapToLong(LayoutPartition::getByteSize).sum());
        return localLayout;
    }

    public Set<Long> getAvailableLayoutIds(NDataflow dataflow, Set<Long> layoutIds) {
        List layoutInCubeIds = dataflow.getIndexPlan().getAllLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toList());
        return layoutIds.stream().filter(layoutInCubeIds::contains).collect(Collectors.toSet());
    }

    public void updateIndexPlan(String dfId, ResourceStore remoteStore) {
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        IndexPlan remoteIndexPlan = remoteDataflowManager.getDataflow(dfId).getIndexPlan();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        indexPlanManager.updateIndexPlan(dfId, copyForWrite -> {
            Map bucketNumMapping = remoteIndexPlan.getLayoutBucketNumMapping() == null ? Maps.newHashMap() : remoteIndexPlan.getLayoutBucketNumMapping();
            copyForWrite.setLayoutBucketNumMapping(bucketNumMapping);
            RuleBasedIndex remoteRuleIndex = remoteIndexPlan.getRuleBasedIndex();
            RuleBasedIndex currentRuleIndex = copyForWrite.getRuleBasedIndex();
            if (remoteRuleIndex != null && currentRuleIndex != null) {
                if (remoteRuleIndex.getLayoutsOfCostBasedList() != null && currentRuleIndex.getLayoutsOfCostBasedList() == null) {
                    currentRuleIndex.setLayoutsOfCostBasedList(remoteRuleIndex.getLayoutsOfCostBasedList());
                }
                copyForWrite.setRuleBasedIndex(currentRuleIndex);
            }
        });
    }

    public void mergeLayoutDetails(String project, String modelId, Set<Long> layoutIds, NDataSegment addSegment, List<NDataSegment> toRemoveSegment, KylinConfig remoteConfig) {
        NDataLayoutDetailsManager localLayoutDetailsManager = NDataLayoutDetailsManager.getInstance((KylinConfig)this.getConfig(), (String)project);
        NDataLayoutDetailsManager remoteLayoutDetailsManager = NDataLayoutDetailsManager.getInstance((KylinConfig)remoteConfig, (String)project);
        for (long layoutId : layoutIds) {
            NDataLayoutDetails remoteLayoutDetails = remoteLayoutDetailsManager.getNDataLayoutDetails(modelId, layoutId);
            localLayoutDetailsManager.updateLayoutDetails(modelId, layoutId, details -> {
                details.setLayoutId(layoutId);
                details.setTableVersion(remoteLayoutDetails.getTableVersion());
                details.setLocation(remoteLayoutDetails.getLocation());
                details.setNumOfFiles(remoteLayoutDetails.getNumOfFiles());
                details.setSizeInBytes(remoteLayoutDetails.getSizeInBytes());
                details.setNumOfRemoveFiles(remoteLayoutDetails.getNumOfRemoveFiles());
                details.getFragmentRangeSet().add(addSegment.getRange());
                for (NDataSegment removeSegment : toRemoveSegment) {
                    details.getFragmentRangeSet().remove(removeSegment.getRange());
                }
            });
        }
    }

    public static MetadataMerger createMetadataMerger(String project, ExecutableHandler.HandlerType type) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        switch (type) {
            case MERGE_OR_REFRESH: {
                return new AfterMergeOrRefreshResourceMerger(config, project);
            }
            case ADD_CUBOID: 
            case ADD_SEGMENT: {
                return new AfterBuildResourceMerger(config, project);
            }
            case SAMPLING: {
                return new AfterSamplingMerger(config, project);
            }
            case SNAPSHOT: {
                return new AfterSnapshotMerger(config, project);
            }
            case LOAD_INTERNAL_TABLE: {
                return new AfterLoadingInternalTableMerger(config, project);
            }
        }
        throw new IllegalArgumentException("Unknown HandlerType: " + type);
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public KylinConfig getConfig() {
        return this.config;
    }
}

