/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rec;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.rec.AbstractContext;
import org.apache.kylin.rec.AbstractProposer;
import org.apache.kylin.rec.AbstractSemiContext;
import org.apache.kylin.rec.ChainedProposer;
import org.apache.kylin.rec.ModelSelectProposer;
import org.apache.kylin.rec.SQLAnalysisProposer;
import org.apache.kylin.rec.ViewModelSelectProposer;
import org.apache.kylin.rec.common.AccelerateInfo;
import org.apache.kylin.rec.model.ModelTree;

public class ModelSelectContext
extends AbstractSemiContext {
    public ModelSelectContext(KylinConfig kylinConfig, String project, String[] sqls) {
        super(kylinConfig, project, sqls);
        this.canCreateNewModel = this.getSmartConfig().getModelOptRule().equalsIgnoreCase("append");
        this.partialMatch = this.getSmartConfig().getKylinConfig().isQueryMatchPartialInnerJoinModel();
        this.partialMatchNonEqui = this.getSmartConfig().getKylinConfig().partialMatchNonEquiJoins();
    }

    @Override
    public ChainedProposer createProposers() {
        ImmutableList proposers = ImmutableList.of((Object)new SQLAnalysisProposer(this), (Object)new ModelSelectProposer(this), (Object)new ViewModelSelectProposer(this));
        return new ChainedProposer(this, (ImmutableList<AbstractProposer>)proposers);
    }

    @Override
    public IndexPlan getOriginIndexPlan(String modelId) {
        throw new NotImplementedException("Fetch origin indexes is forbidden in ModelSelectAIAugmentedContext!");
    }

    @Override
    public List<NDataModel> getOriginModels() {
        return this.getRelatedModels().stream().filter(model -> this.getExtraMeta().getOnlineModelIds().contains(model.getUuid())).collect(Collectors.toList());
    }

    @Override
    public void handleExceptionAfterModelSelect() {
        for (AbstractContext.ModelContext modelContext : this.getModelContexts()) {
            ModelTree modelTree = modelContext.getModelTree();
            if (modelTree == null || CollectionUtils.isEmpty(modelTree.getOlapContexts())) continue;
            NDataModel originModel = modelContext.getOriginModel();
            modelTree.getOlapContexts().forEach(ctx -> {
                AccelerateInfo accelerateInfo = this.getAccelerateInfoMap().get(ctx.getSql());
                if (originModel != null) {
                    AccelerateInfo.QueryLayoutRelation relation = new AccelerateInfo.QueryLayoutRelation(ctx.getSql(), originModel.getUuid(), -1L, originModel.getSemanticVersion());
                    relation.setModelId(originModel.getId());
                    accelerateInfo.getRelatedLayouts().add(relation);
                }
            });
        }
    }

    @Override
    public void changeModelMainType(NDataModel model) {
        throw new NotImplementedException("Modifying ModelMaintainType is forbidden in ModelSelectAIAugmentedContext");
    }
}

