/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.guava30.shaded.common.eventbus.Subscribe;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.optimization.FrequencyMap;
import org.apache.kylin.metadata.cube.optimization.GarbageLayoutType;
import org.apache.kylin.metadata.cube.optimization.IndexOptimizerFactory;
import org.apache.kylin.metadata.cube.optimization.event.ApproveRecsEvent;
import org.apache.kylin.metadata.cube.utils.IndexPlanReduceUtil;
import org.apache.kylin.metadata.job.JobTokenItem;
import org.apache.kylin.metadata.job.JobTokenManager;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;
import org.apache.kylin.metadata.recommendation.candidate.RawRecItem;
import org.apache.kylin.metadata.recommendation.candidate.RawRecManager;
import org.apache.kylin.metadata.recommendation.entity.CCRecItemV2;
import org.apache.kylin.metadata.recommendation.ref.CCRef;
import org.apache.kylin.metadata.recommendation.ref.DimensionRef;
import org.apache.kylin.metadata.recommendation.ref.MeasureRef;
import org.apache.kylin.metadata.recommendation.ref.ModelColumnRef;
import org.apache.kylin.metadata.recommendation.ref.OptRecManagerV2;
import org.apache.kylin.metadata.recommendation.ref.OptRecV2;
import org.apache.kylin.metadata.recommendation.ref.RecommendationRef;
import org.apache.kylin.metadata.recommendation.util.RawRecUtil;
import org.apache.kylin.rest.request.OptRecRequest;
import org.apache.kylin.rest.response.OpenRecApproveResponse;
import org.apache.kylin.rest.response.OptRecLayoutResponse;
import org.apache.kylin.rest.response.OptRecLayoutsResponse;
import org.apache.kylin.rest.response.OptRecResponse;
import org.apache.kylin.rest.service.BaseIndexUpdateHelper;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.service.FusionIndexService;
import org.apache.kylin.rest.service.IndexPlanService;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.OptRecService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.stereotype.Component;

@EnableDiscoveryClient
@Component(value="optRecApproveService")
public class OptRecApproveService
extends BasicService {
    private static final Logger log = LoggerFactory.getLogger((String)"smart");
    @Autowired
    public AclEvaluate aclEvaluate;
    @Autowired
    private ModelService modelService;
    @Autowired
    private IndexPlanService indexPlanService;
    @Autowired
    private OptRecService optRecService;

    public OptRecResponse approve(String project, OptRecRequest request) {
        if (request.getJobId() != null && request.getToken() != null) {
            JobTokenManager tokenManager = JobTokenManager.getInstance((KylinConfig)this.getConfig());
            JobTokenItem tokenItem = tokenManager.query(request.getJobId());
            String encrypt = tokenManager.encrypt(request.getToken());
            if (tokenItem != null && !encrypt.equalsIgnoreCase(tokenItem.getToken())) {
                OptRecResponse optRecResponse = new OptRecResponse();
                optRecResponse.setProject(project);
                optRecResponse.setModelId(request.getModelId());
                optRecResponse.setAddedLayouts((List)Lists.newArrayList());
                optRecResponse.setRemovedLayouts((List)Lists.newArrayList());
                return optRecResponse;
            }
            OptRecResponse optRecResponse = this.approveInternal(project, request);
            tokenManager.delete(request.getJobId());
            return optRecResponse;
        }
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        return this.approveInternal(project, request);
    }

    private OptRecResponse approveInternal(String project, OptRecRequest request) {
        String modelId = request.getModelId();
        if (!FusionIndexService.checkUpdateIndexEnabled((String)project, (String)modelId)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.STREAMING_INDEX_UPDATE_DISABLE, MsgPicker.getMsg().getStreamingIndexesApprove());
        }
        OptRecResponse response = new OptRecResponse();
        BaseIndexUpdateHelper baseIndexUpdater = new BaseIndexUpdateHelper(((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId), false);
        Map userDefinedRecNameMap = request.getNames();
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            RecApproveContext approveContext = new RecApproveContext(project, modelId, userDefinedRecNameMap);
            this.approveRecItemsToRemoveLayout(request, approveContext);
            this.approveRecItemsToAddLayout(request, approveContext);
            this.updateRecommendationCount(project, modelId);
            response.setProject(request.getProject());
            response.setModelId(request.getModelId());
            response.setAddedLayouts(approveContext.addedLayoutIdList);
            response.setRemovedLayouts(approveContext.removedLayoutIdList);
            return null;
        }, (String)project);
        response.setBaseIndexInfo(baseIndexUpdater.update(this.indexPlanService, false));
        return response;
    }

    public List<OpenRecApproveResponse.RecToIndexResponse> batchApprove(String project, List<String> modelIds, String recActionType, boolean filterByModels, boolean discardTableIndex) {
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        ArrayList allModels = Lists.newArrayList();
        if (filterByModels && CollectionUtils.isNotEmpty(modelIds)) {
            allModels.addAll(modelIds);
        } else if (!filterByModels) {
            allModels.addAll(((NDataModelManager)this.getManager(NDataModelManager.class, project)).listAllModelIds());
        }
        allModels.forEach(modelId -> this.modelService.checkModelPermission(project, modelId));
        ArrayList responseList = Lists.newArrayList();
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowManager systemDfMgr = NDataflowManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)project);
            for (String modelId : allModels) {
                NDataModel model;
                NDataflow df = systemDfMgr.getDataflow(modelId);
                if (df.getStatus() != RealizationStatusEnum.ONLINE || df.getModel().isBroken() || !allModels.contains((model = df.getModel()).getUuid())) continue;
                OpenRecApproveResponse.RecToIndexResponse response = this.approveAllRecItems(project, model.getUuid(), model.getAlias(), recActionType, discardTableIndex);
                responseList.add(response);
            }
            return null;
        }, (String)project);
        return responseList;
    }

    private OpenRecApproveResponse.RecToIndexResponse approveAllRecItems(String project, String modelId, String modelAlias, String recActionType, boolean discardTableIndex) {
        RecApproveContext approveContext = new RecApproveContext(project, modelId, Maps.newHashMap());
        OptRecRequest request = new OptRecRequest();
        request.setProject(project);
        request.setModelId(modelId);
        OptRecV2 recommendation = approveContext.getRecommendation();
        List<Integer> recItemsToAddLayout = this.filterOutTableIndex(recommendation, discardTableIndex);
        ArrayList recItemsToRemoveLayout = Lists.newArrayList();
        recommendation.getRemovalLayoutRefs().forEach((key, value) -> recItemsToRemoveLayout.add(-value.getId()));
        if (recActionType.equalsIgnoreCase(OptRecService.RecActionType.ALL.name())) {
            request.setRecItemsToAddLayout(recItemsToAddLayout);
            request.setRecItemsToRemoveLayout((List)recItemsToRemoveLayout);
        } else if (recActionType.equalsIgnoreCase(OptRecService.RecActionType.ADD_INDEX.name())) {
            request.setRecItemsToAddLayout(recItemsToAddLayout);
            request.setRecItemsToRemoveLayout((List)Lists.newArrayList());
        } else if (recActionType.equalsIgnoreCase(OptRecService.RecActionType.REMOVE_INDEX.name())) {
            request.setRecItemsToAddLayout((List)Lists.newArrayList());
            request.setRecItemsToRemoveLayout((List)recItemsToRemoveLayout);
        } else {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.UNSUPPORTED_REC_OPERATION_TYPE, "The operation types of recommendation includes: add_index, removal_index and all(by default)");
        }
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        BaseIndexUpdateHelper baseIndexUpdater = new BaseIndexUpdateHelper(model, false);
        this.approveRecItemsToRemoveLayout(request, approveContext);
        this.approveRecItemsToAddLayout(request, approveContext);
        this.updateRecommendationCount(project, modelId);
        OpenRecApproveResponse.RecToIndexResponse response = new OpenRecApproveResponse.RecToIndexResponse();
        response.setModelId(modelId);
        response.setModelAlias(modelAlias);
        response.setAddedIndexes(approveContext.addedLayoutIdList);
        response.setRemovedIndexes(approveContext.removedLayoutIdList);
        response.setBaseIndexInfo(baseIndexUpdater.update(this.indexPlanService));
        return response;
    }

    private List<Integer> filterOutTableIndex(OptRecV2 recommendation, boolean discardTableIndex) {
        ArrayList recItemsToAddLayout = Lists.newArrayList();
        recommendation.getAdditionalLayoutRefs().forEach((key, value) -> {
            if (!discardTableIndex || value.isAgg()) {
                recItemsToAddLayout.add(-value.getId());
            }
        });
        return recItemsToAddLayout;
    }

    private void approveRecItemsToRemoveLayout(OptRecRequest request, RecApproveContext approveContext) {
        List recItemsToRemoveLayout = request.getRecItemsToRemoveLayout();
        List<RawRecItem> recItems = approveContext.approveRawRecItems(recItemsToRemoveLayout, false);
        this.updateStatesOfApprovedRecItems(request.getProject(), recItems);
    }

    private void approveRecItemsToAddLayout(OptRecRequest request, RecApproveContext approveContext) {
        List recItemsToAddLayout = request.getRecItemsToAddLayout();
        List<RawRecItem> recItems = approveContext.approveRawRecItems(recItemsToAddLayout, true);
        this.updateStatesOfApprovedRecItems(request.getProject(), recItems);
    }

    private void updateStatesOfApprovedRecItems(String project, List<RawRecItem> recItems) {
        ArrayList nonAppliedItemIds = Lists.newArrayList();
        recItems.forEach(recItem -> {
            if (recItem.getState() == RawRecItem.RawRecState.APPLIED) {
                return;
            }
            nonAppliedItemIds.add(recItem.getId());
        });
        RawRecManager rawManager = RawRecManager.getInstance((String)project);
        rawManager.applyByIds((List)nonAppliedItemIds);
    }

    private void updateRecommendationCount(String project, String modelId) {
        int size = this.optRecService.getOptRecLayoutsResponse(project, modelId, OptRecService.ALL).getSize();
        this.modelService.updateRecommendationsCount(project, modelId, size);
    }

    @Subscribe
    public void approveRawRecItemsByHitCount(ApproveRecsEvent event) {
        String project = event.getProject();
        Map needOptAggressivelyModels = event.getNeedOptAggressivelyModels();
        needOptAggressivelyModels.forEach((dataflow, garbageLayouts) -> {
            IndexPlan indexPlan = dataflow.getIndexPlan();
            List indexesBeforeApprove = indexPlan.getIndexes();
            int approveIndexSize = this.getNeedToBeApprovedIndexSize(indexPlan, (Map<Long, GarbageLayoutType>)garbageLayouts);
            if (approveIndexSize <= 0) {
                return;
            }
            this.approve(project, dataflow.getUuid(), approveIndexSize);
            IndexPlan newestIndexPlan = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getIndexPlan(indexPlan.getUuid());
            this.mergeSameDimLayout(project, newestIndexPlan, indexesBeforeApprove);
        });
    }

    private void approve(String project, String modelId, int approveRecsAmount) {
        OptRecLayoutsResponse optRecs = this.optRecService.getOptRecLayoutsResponseInner(project, modelId, OptRecService.RecActionType.ADD_INDEX.toString());
        List approve = optRecs.getLayouts().stream().filter(layout -> layout.getUsage() != 0).sorted((rec1, rec2) -> rec2.getUsage() - rec1.getUsage()).limit(approveRecsAmount).map(OptRecLayoutResponse::getId).collect(Collectors.toList());
        if (approve.isEmpty()) {
            log.info("no RawRecItems need to be approved");
            return;
        }
        this.aclEvaluate.checkProjectOperationDesignPermission(project);
        OptRecRequest optRecRequest = new OptRecRequest();
        optRecRequest.setProject(project);
        optRecRequest.setModelId(modelId);
        optRecRequest.setRecItemsToAddLayout(approve);
        OptRecResponse approveRes = this.approveInternal(project, optRecRequest);
        log.info("approve added layouts: {} for model: {} under project: {}", new Object[]{approveRes.getAddedLayouts(), modelId, project});
    }

    private int getNeedToBeApprovedIndexSize(IndexPlan indexPlan, Map<Long, GarbageLayoutType> garbageLayouts) {
        int indexSizeBeforeApprove = indexPlan.getIndexes().size();
        int expectIndexSize = indexPlan.getConfig().getExpectedIndexSizeOptimized();
        List<Set<LayoutEntity>> mergedLayouts = this.getMergedLayouts(indexPlan, garbageLayouts);
        int indexSizeAfterClean = indexSizeBeforeApprove - garbageLayouts.size() + mergedLayouts.size();
        int approveIndexSize = expectIndexSize - indexSizeAfterClean;
        log.info("all index is: {}, expected index size after optimization is: {}. Prepare to approve {} index", new Object[]{indexSizeAfterClean, expectIndexSize, approveIndexSize});
        return approveIndexSize;
    }

    private List<Set<LayoutEntity>> getMergedLayouts(IndexPlan indexPlan, Map<Long, GarbageLayoutType> garbageLayouts) {
        ArrayList merged = Lists.newArrayList();
        garbageLayouts.forEach((layoutId, garbageLayoutType) -> {
            LayoutEntity layout = indexPlan.getLayoutEntity(layoutId);
            if (GarbageLayoutType.MERGED == garbageLayoutType && !Objects.isNull(layout)) {
                merged.add(layout);
            }
        });
        return IndexPlanReduceUtil.collectSameDimAggLayouts((List)merged);
    }

    private void mergeSameDimLayout(String project, IndexPlan indexPlan, List<IndexEntity> indexesBeforeApprove) {
        List newestIndexes = indexPlan.getIndexes();
        List approvedIndexes = ListUtils.subtract((List)newestIndexes, indexesBeforeApprove);
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        ArrayList approvedLayouts = Lists.newArrayList();
        approvedIndexes.stream().map(IndexEntity::getLayouts).forEach(approvedLayouts::addAll);
        List sameDimAggLayouts = IndexPlanReduceUtil.collectSameDimAggLayouts((List)approvedLayouts);
        indexPlanManager.updateIndexPlan(indexPlan.getId(), copyForWrite -> {
            IndexPlan.IndexPlanUpdateHandler updateHandler = copyForWrite.createUpdateHandler();
            sameDimAggLayouts.stream().flatMap(Collection::stream).forEachOrdered(layout -> updateHandler.remove(layout, IndexEntity.isAggIndex((long)layout.getId()), false, false));
            updateHandler.complete();
            IndexPlan indexPlanMerged = IndexPlanReduceUtil.mergeSameDimLayout((IndexPlan)copyForWrite, (List)sameDimAggLayouts);
            copyForWrite.setIndexes(indexPlanMerged.getIndexes());
            copyForWrite.setLastModified(System.currentTimeMillis());
        });
    }

    private static class RecNameChecker {
        private RecNameChecker() {
        }

        private static void checkCCRecConflictWithColumn(OptRecV2 recommendation, String project, Map<Integer, String> userDefinedRecNameMap) {
            HashMap checkedTableColumnMap = Maps.newHashMap();
            userDefinedRecNameMap.forEach((id, name) -> {
                if (id >= 0) {
                    return;
                }
                RawRecItem rawRecItem = (RawRecItem)recommendation.getRawRecItemMap().get(-id.intValue());
                if (rawRecItem.getType() == RawRecItem.RawRecType.COMPUTED_COLUMN) {
                    checkedTableColumnMap.putIfAbsent(name.toUpperCase(Locale.ROOT), Sets.newHashSet());
                    ((Set)checkedTableColumnMap.get(name.toUpperCase(Locale.ROOT))).add(id);
                }
            });
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)project);
            NDataModel model = modelManager.getDataModelDesc(recommendation.getUuid());
            String factTableName = model.getRootFactTableName().split("\\.").length < 2 ? model.getRootFactTableName() : model.getRootFactTableName().split("\\.")[1];
            model.getAllNamedColumns().forEach(column -> {
                if (!column.isExist()) {
                    return;
                }
                String[] tableAndColumn = column.getAliasDotColumn().split("\\.");
                if (!tableAndColumn[0].equalsIgnoreCase(factTableName)) {
                    return;
                }
                if (checkedTableColumnMap.containsKey(tableAndColumn[1].toUpperCase(Locale.ROOT))) {
                    ((Set)checkedTableColumnMap.get(tableAndColumn[1])).add(column.getId());
                }
            });
            checkedTableColumnMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).size() < 2);
            if (!checkedTableColumnMap.isEmpty()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_APPROVE_RECOMMENDATION, MsgPicker.getMsg().getAliasConflictOfApprovingRecommendation() + "\n" + JsonUtil.writeValueAsStringQuietly((Object)checkedTableColumnMap));
            }
        }

        private static void checkUserDefinedRecNames(OptRecV2 recommendation, String project, Map<Integer, String> userDefinedRecNameMap) {
            HashMap checkedDimensionMap = Maps.newHashMap();
            HashMap checkedMeasureMap = Maps.newHashMap();
            HashMap checkedCCMap = Maps.newHashMap();
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig(), (String)project);
            NDataModel model = modelManager.getDataModelDesc(recommendation.getUuid());
            model.getAllNamedColumns().forEach(column -> {
                if (column.isDimension()) {
                    checkedDimensionMap.putIfAbsent(column.getName(), Sets.newHashSet());
                    ((Set)checkedDimensionMap.get(column.getName())).add(column.getId());
                }
            });
            model.getAllMeasures().forEach(measure -> {
                if (measure.isTomb()) {
                    return;
                }
                checkedMeasureMap.putIfAbsent(measure.getName(), Sets.newHashSet());
                ((Set)checkedMeasureMap.get(measure.getName())).add(measure.getId());
            });
            userDefinedRecNameMap.forEach((id, name) -> {
                Set idSet;
                if (id >= 0) {
                    return;
                }
                RawRecItem rawRecItem = (RawRecItem)recommendation.getRawRecItemMap().get(-id.intValue());
                if (rawRecItem.getType() == RawRecItem.RawRecType.DIMENSION) {
                    checkedDimensionMap.putIfAbsent(name, Sets.newHashSet());
                    idSet = (Set)checkedDimensionMap.get(name);
                    idSet.remove(rawRecItem.getDependIDs()[0]);
                    idSet.add(id);
                }
                if (rawRecItem.getType() == RawRecItem.RawRecType.COMPUTED_COLUMN) {
                    checkedCCMap.putIfAbsent(name, Sets.newHashSet());
                    idSet = (Set)checkedCCMap.get(name);
                    idSet.add(id);
                }
                if (rawRecItem.getType() == RawRecItem.RawRecType.MEASURE) {
                    checkedMeasureMap.putIfAbsent(name, Sets.newHashSet());
                    ((Set)checkedMeasureMap.get(name)).add(id);
                }
            });
            checkedDimensionMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).size() < 2);
            checkedMeasureMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).size() < 2);
            checkedCCMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).size() < 2);
            HashMap conflictMap = Maps.newHashMap();
            checkedDimensionMap.forEach((name, idSet) -> {
                conflictMap.putIfAbsent(name, Sets.newHashSet());
                ((Set)conflictMap.get(name)).addAll(idSet);
            });
            checkedMeasureMap.forEach((name, idSet) -> {
                conflictMap.putIfAbsent(name, Sets.newHashSet());
                ((Set)conflictMap.get(name)).addAll(idSet);
            });
            checkedCCMap.forEach((name, idSet) -> {
                conflictMap.putIfAbsent(name, Sets.newHashSet());
                ((Set)conflictMap.get(name)).addAll(idSet);
            });
            conflictMap.entrySet().removeIf(entry -> ((Set)entry.getValue()).stream().allMatch(id -> id >= 0));
            if (!conflictMap.isEmpty()) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.FAILED_APPROVE_RECOMMENDATION, MsgPicker.getMsg().getAliasConflictOfApprovingRecommendation() + "\n" + JsonUtil.writeValueAsStringQuietly((Object)conflictMap));
            }
        }
    }

    private static final class RecApproveContext {
        private final Map<Integer, NDataModel.NamedColumn> columns = Maps.newHashMap();
        private final Map<Integer, NDataModel.NamedColumn> dimensions = Maps.newHashMap();
        private final Map<Integer, NDataModel.Measure> measures = Maps.newHashMap();
        private final List<Long> addedLayoutIdList = Lists.newArrayList();
        private final List<Long> removedLayoutIdList = Lists.newArrayList();
        private final Map<String, NDataModel.Measure> functionToMeasureMap = Maps.newHashMap();
        private Set<Integer> abnormalRecIds = Sets.newHashSet();
        private final OptRecV2 recommendation;
        private final Map<Integer, String> userDefinedRecNameMap;
        private final String project;

        private RecApproveContext(String project, String modelId, Map<Integer, String> userDefinedRecNameMap) {
            this.project = project;
            this.userDefinedRecNameMap = userDefinedRecNameMap;
            this.recommendation = OptRecManagerV2.getInstance((String)project).loadOptRecV2(modelId);
            RecNameChecker.checkCCRecConflictWithColumn(this.recommendation, project, userDefinedRecNameMap);
            RecNameChecker.checkUserDefinedRecNames(this.recommendation, project, userDefinedRecNameMap);
        }

        public List<RawRecItem> approveRawRecItems(List<Integer> recItemIds, boolean isAdd) {
            recItemIds.forEach(id -> OptRecService.checkRecItemIsValidAndReturn(this.recommendation, id, isAdd));
            List<RawRecItem> rawRecItems = this.getAllRelatedRecItems(recItemIds, isAdd);
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                if (isAdd) {
                    rawRecItems.sort(Comparator.comparing(RawRecItem::getId));
                    this.abnormalRecIds = this.reduceDupCCRecItems(rawRecItems, this.abnormalRecIds);
                    this.rewriteModel(rawRecItems);
                    Map<Long, RawRecItem> addedLayouts = this.rewriteIndexPlan(rawRecItems);
                    addedLayouts = this.checkAndRemoveDirtyLayouts(addedLayouts);
                    this.addedLayoutIdList.addAll(addedLayouts.keySet());
                    this.addLayoutHitCount(this.recommendation.getProject(), this.recommendation.getUuid(), addedLayouts);
                } else {
                    this.shiftLayoutHitCount(this.recommendation.getProject(), this.recommendation.getUuid(), rawRecItems);
                    List<Long> removedLayouts = this.reduceIndexPlan(rawRecItems);
                    this.removedLayoutIdList.addAll(removedLayouts);
                }
                return null;
            }, (String)this.project);
            return rawRecItems;
        }

        private void addLayoutHitCount(String project, String modelUuid, Map<Long, RawRecItem> rawRecItems) {
            if (MapUtils.isEmpty(rawRecItems)) {
                return;
            }
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
            dfMgr.updateDataflow(modelUuid, copyForWrite -> {
                Map layoutHitCount = copyForWrite.getLayoutHitCount();
                rawRecItems.forEach((id, rawRecItem) -> {
                    if (rawRecItem.getLayoutMetric() != null) {
                        layoutHitCount.put(id, rawRecItem.getLayoutMetric().getFrequencyMap());
                    }
                });
            });
        }

        private Map<Long, RawRecItem> checkAndRemoveDirtyLayouts(Map<Long, RawRecItem> addedLayouts) {
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)kylinConfig, (String)this.project);
            NDataModel model = modelManager.getDataModelDesc(this.recommendation.getUuid());
            HashSet queryScopes = Sets.newHashSet();
            model.getEffectiveDimensions().forEach((id, col) -> queryScopes.add(id));
            model.getEffectiveMeasures().forEach((id, col) -> queryScopes.add(id));
            NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)kylinConfig, (String)this.project);
            IndexPlan indexPlan = indexPlanManager.getIndexPlan(this.recommendation.getUuid());
            Map allLayoutsMap = indexPlan.getAllLayoutsMap();
            return addedLayouts.entrySet().stream().filter(entry -> {
                long layoutId = (Long)entry.getKey();
                return allLayoutsMap.containsKey(layoutId) && queryScopes.containsAll((Collection<?>)((LayoutEntity)allLayoutsMap.get(layoutId)).getColOrder());
            }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public List<RawRecItem> getAllRelatedRecItems(List<Integer> layoutIds, boolean isAdd) {
            LinkedHashSet allRecItems = Sets.newLinkedHashSet();
            Map layoutRefs = isAdd ? this.recommendation.getAdditionalLayoutRefs() : this.recommendation.getRemovalLayoutRefs();
            layoutIds.forEach(id -> {
                if (layoutRefs.containsKey(-id.intValue())) {
                    this.collect(allRecItems, (RecommendationRef)layoutRefs.get(-id.intValue()));
                }
            });
            return Lists.newArrayList((Iterable)allRecItems);
        }

        private void collect(Set<RawRecItem> recItemsCollector, RecommendationRef ref) {
            if (ref instanceof ModelColumnRef) {
                return;
            }
            RawRecItem recItem = (RawRecItem)this.recommendation.getRawRecItemMap().get(-ref.getId());
            if (recItem == null || recItemsCollector.contains(recItem)) {
                return;
            }
            if (!ref.isBroken() && !ref.isExisted()) {
                ref.getDependencies().forEach(dep -> this.collect(recItemsCollector, (RecommendationRef)dep));
                recItemsCollector.add(recItem);
            }
        }

        private void shiftLayoutHitCount(String project, String modelUuid, List<RawRecItem> rawRecItems) {
            if (CollectionUtils.isEmpty(rawRecItems)) {
                return;
            }
            HashSet layoutsToRemove = Sets.newHashSet();
            rawRecItems.forEach(rawRecItem -> {
                long layoutId = RawRecUtil.getLayout((RawRecItem)rawRecItem).getId();
                layoutsToRemove.add(layoutId);
            });
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
            NDataflow originDf = dfMgr.getDataflow(modelUuid);
            NDataflow copiedDf = originDf.copy();
            IndexOptimizerFactory.getOptimizer((NDataflow)copiedDf, (boolean)false, (boolean)true).getGarbageLayoutMap(copiedDf);
            Map layoutHitCount = copiedDf.getLayoutHitCount();
            layoutHitCount.forEach((id, freqMap) -> {
                FrequencyMap oriMap;
                if (!layoutsToRemove.contains(id) && (oriMap = (FrequencyMap)originDf.getLayoutHitCount().get(id)) != null) {
                    layoutHitCount.put(id, oriMap);
                }
            });
            dfMgr.updateDataflow(copiedDf.getUuid(), copyForWrite -> copyForWrite.setLayoutHitCount(layoutHitCount));
        }

        private void rewriteModel(List<RawRecItem> recItems) {
            if (CollectionUtils.isEmpty(recItems)) {
                return;
            }
            this.logBeginRewrite("Model");
            NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
            modelManager.updateDataModel(this.recommendation.getUuid(), copyForWrite -> {
                Object rawRecItem2;
                this.prepareColsMeasData(copyForWrite);
                for (Object rawRecItem2 : recItems) {
                    if (this.isAbnormal((RawRecItem)rawRecItem2)) {
                        this.abnormalRecIds.add(rawRecItem2.getId());
                        continue;
                    }
                    switch (rawRecItem2.getType()) {
                        case DIMENSION: {
                            this.writeDimensionToModel(copyForWrite, (RawRecItem)rawRecItem2);
                            break;
                        }
                        case COMPUTED_COLUMN: {
                            this.writeCCToModel(copyForWrite, (RawRecItem)rawRecItem2);
                            break;
                        }
                        case MEASURE: {
                            this.writeMeasureToModel(copyForWrite, (RawRecItem)rawRecItem2);
                            break;
                        }
                    }
                }
                SetLogCategory ignored = new SetLogCategory("smart");
                rawRecItem2 = null;
                try {
                    log.info(copyForWrite.getUuid());
                }
                catch (Throwable throwable) {
                    rawRecItem2 = throwable;
                    throw throwable;
                }
                finally {
                    if (ignored != null) {
                        if (rawRecItem2 != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)rawRecItem2).addSuppressed(throwable);
                            }
                        } else {
                            ignored.close();
                        }
                    }
                }
                copyForWrite.keepColumnOrder();
                copyForWrite.keepMeasureOrder();
                List existedColumns = copyForWrite.getAllNamedColumns().stream().filter(NDataModel.NamedColumn::isExist).collect(Collectors.toList());
                List existedMeasure = copyForWrite.getAllMeasures().stream().filter(measure -> !measure.isTomb()).collect(Collectors.toList());
                NDataModel.changeNameIfDup(existedColumns);
                NDataModel.checkDuplicateColumn(existedColumns);
                NDataModel.checkDuplicateMeasure(existedMeasure);
                NDataModel.checkDuplicateCC((List)copyForWrite.getComputedColumnDescs());
            });
            this.logFinishRewrite("Model");
        }

        private void prepareColsMeasData(NDataModel copyForWrite) {
            copyForWrite.getAllNamedColumns().forEach(column -> {
                if (column.isExist()) {
                    this.columns.putIfAbsent(column.getId(), (NDataModel.NamedColumn)column);
                }
                if (column.isDimension()) {
                    this.dimensions.putIfAbsent(column.getId(), (NDataModel.NamedColumn)column);
                }
            });
            copyForWrite.getAllMeasures().forEach(measure -> {
                if (!measure.isTomb()) {
                    this.measures.putIfAbsent(measure.getId(), (NDataModel.Measure)measure);
                }
            });
            copyForWrite.getAllMeasures().forEach(measure -> {
                if (!measure.isTomb()) {
                    this.functionToMeasureMap.put(measure.getFunction().toString(), (NDataModel.Measure)measure);
                }
            });
        }

        private Set<Integer> reduceDupCCRecItems(List<RawRecItem> recItems, Set<Integer> abnormalRecIds) {
            List ccRecItems = recItems.stream().filter(rawRecItem -> rawRecItem.getType() == RawRecItem.RawRecType.COMPUTED_COLUMN).collect(Collectors.toList());
            if (ccRecItems.isEmpty()) {
                return abnormalRecIds;
            }
            List sortedCCRecItems = ccRecItems.stream().sorted(Comparator.comparing(o -> ((CCRecItemV2)o.getRecEntity()).getCc().getInnerExpression())).collect(Collectors.toList());
            HashMap dupCCRecItemMap = Maps.newHashMap();
            int resId = ((RawRecItem)sortedCCRecItems.get(0)).getId();
            for (int i = 1; i < sortedCCRecItems.size(); ++i) {
                String expr2;
                RawRecItem curRecItem = (RawRecItem)sortedCCRecItems.get(i);
                RawRecItem prevRecItem = (RawRecItem)sortedCCRecItems.get(i - 1);
                String expr1 = ((CCRecItemV2)curRecItem.getRecEntity()).getCc().getInnerExpression();
                if (expr1.equalsIgnoreCase(expr2 = ((CCRecItemV2)prevRecItem.getRecEntity()).getCc().getInnerExpression())) {
                    int curRecItemId = curRecItem.getId();
                    dupCCRecItemMap.put(curRecItemId, resId);
                    abnormalRecIds.add(curRecItemId);
                    continue;
                }
                resId = curRecItem.getId();
            }
            return abnormalRecIds;
        }

        private void writeMeasureToModel(NDataModel model, RawRecItem rawRecItem) {
            int negRecItemId;
            Map measureRefs = this.recommendation.getMeasureRefs();
            RecommendationRef recommendationRef = (RecommendationRef)measureRefs.get(negRecItemId = -rawRecItem.getId());
            if (recommendationRef.isExisted()) {
                return;
            }
            MeasureRef measureRef = (MeasureRef)recommendationRef;
            NDataModel.Measure measure = measureRef.getMeasure();
            if (this.functionToMeasureMap.containsKey(measure.getFunction().toString())) {
                try (SetLogCategory ignored = new SetLogCategory("smart");){
                    log.error("Fail to rewrite RawRecItem({}) for conflicting function ({})", (Object)rawRecItem.getId(), (Object)measure.getFunction());
                }
                return;
            }
            int maxMeasureId = model.getMaxMeasureId();
            if (this.userDefinedRecNameMap.containsKey(negRecItemId)) {
                measureRef.rebuild(this.userDefinedRecNameMap.get(negRecItemId));
            } else {
                measureRef.rebuild(measure.getName());
            }
            measure = measureRef.getMeasure();
            measure.setId(++maxMeasureId);
            model.getAllMeasures().add(measure);
            this.measures.put(negRecItemId, measure);
            this.measures.put(measure.getId(), measure);
            this.functionToMeasureMap.put(measure.getFunction().toString(), measure);
            this.logWriteProperty(rawRecItem, measure);
        }

        private void writeDimensionToModel(NDataModel model, RawRecItem rawRecItem) {
            int negRecItemId;
            Map mapIdToColumn = model.getAllNamedColumns().stream().collect(Collectors.toMap(NDataModel.NamedColumn::getId, Function.identity()));
            Map dimensionRefs = this.recommendation.getDimensionRefs();
            RecommendationRef dimensionRef = (RecommendationRef)dimensionRefs.get(negRecItemId = -rawRecItem.getId());
            if (dimensionRef.isExisted()) {
                return;
            }
            DimensionRef dimRef = (DimensionRef)dimensionRef;
            NDataModel.NamedColumn column = null;
            if (dimRef.getEntity() instanceof ModelColumnRef) {
                ModelColumnRef columnRef = (ModelColumnRef)dimensionRef.getEntity();
                column = columnRef.getColumn();
            } else if (dimRef.getEntity() instanceof CCRef) {
                CCRef ccRef = (CCRef)dimensionRef.getEntity();
                column = this.columns.get(ccRef.getId());
            }
            Preconditions.checkArgument((column != null ? 1 : 0) != 0, (Object)"Dimension can only depend on a computed column or an existing column");
            if (this.userDefinedRecNameMap.containsKey(negRecItemId)) {
                column.setName(this.userDefinedRecNameMap.get(negRecItemId));
            }
            column.setStatus(NDataModel.ColumnStatus.DIMENSION);
            ((NDataModel.NamedColumn)mapIdToColumn.get(column.getId())).setName(column.getName());
            this.dimensions.putIfAbsent(negRecItemId, column);
            this.columns.get(column.getId()).setStatus(column.getStatus());
            this.columns.get(column.getId()).setName(column.getName());
            this.logWriteProperty(rawRecItem, column);
        }

        private void writeCCToModel(NDataModel model, RawRecItem rawRecItem) {
            int negRecItemId;
            Map ccRefs = this.recommendation.getCcRefs();
            RecommendationRef recommendationRef = (RecommendationRef)ccRefs.get(negRecItemId = -rawRecItem.getId());
            if (recommendationRef.isExisted()) {
                return;
            }
            CCRef ccRef = (CCRef)recommendationRef;
            ComputedColumnDesc cc = ccRef.getCc();
            if (this.userDefinedRecNameMap.containsKey(negRecItemId)) {
                ccRef.rebuild(this.userDefinedRecNameMap.get(negRecItemId));
                cc = ccRef.getCc();
            }
            int lastColumnId = model.getMaxColumnId();
            NDataModel.NamedColumn columnInModel = new NDataModel.NamedColumn();
            columnInModel.setId(++lastColumnId);
            columnInModel.setName(cc.getTableAlias() + "_" + cc.getColumnName());
            columnInModel.setAliasDotColumn(cc.getTableAlias() + "." + cc.getColumnName());
            columnInModel.setStatus(NDataModel.ColumnStatus.EXIST);
            model.getAllNamedColumns().add(columnInModel);
            model.getComputedColumnDescs().add(cc);
            this.columns.put(negRecItemId, columnInModel);
            this.columns.put(lastColumnId, columnInModel);
            this.logWriteProperty(rawRecItem, columnInModel);
        }

        private Map<Long, RawRecItem> rewriteIndexPlan(List<RawRecItem> recItems) {
            if (CollectionUtils.isEmpty(recItems)) {
                return Maps.newHashMap();
            }
            ArrayList layoutIds = Lists.newArrayList();
            this.logBeginRewrite("augment IndexPlan");
            NIndexPlanManager indexMgr = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
            NDataModel model = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project).getDataModelDesc(this.recommendation.getUuid());
            HashMap approvedLayouts = Maps.newHashMap();
            indexMgr.updateIndexPlan(this.recommendation.getUuid(), copyForWrite -> {
                IndexPlan.IndexPlanUpdateHandler updateHandler = copyForWrite.createUpdateHandler();
                for (RawRecItem rawRecItem : recItems) {
                    Throwable throwable;
                    SetLogCategory ignored;
                    if (this.isAbnormal(rawRecItem)) {
                        this.abnormalRecIds.add(rawRecItem.getId());
                        continue;
                    }
                    if (!rawRecItem.isAddLayoutRec()) continue;
                    LayoutEntity layout = RawRecUtil.getLayout((RawRecItem)rawRecItem);
                    ImmutableList colOrder = layout.getColOrder();
                    ArrayList shardBy = Lists.newArrayList((Iterable)layout.getShardByColumns());
                    ArrayList sortBy = Lists.newArrayList((Iterable)layout.getSortByColumns());
                    ArrayList partitionBy = Lists.newArrayList((Iterable)layout.getPartitionByColumns());
                    List<Integer> nColOrder = this.translateToRealIds((List<Integer>)colOrder, "ColOrder");
                    List<Integer> nShardBy = this.translateToRealIds(shardBy, "ShardByColumns");
                    List<Integer> nSortBy = this.translateToRealIds(sortBy, "SortByColumns");
                    List<Integer> nPartitionBy = this.translateToRealIds(partitionBy, "PartitionByColumns");
                    if (this.isInvalidColId(nColOrder, model) || this.isInvalidColId(nShardBy, model) || this.isInvalidColId(nSortBy, model) || this.isInvalidColId(nPartitionBy, model) || Sets.newHashSet(nColOrder).size() != colOrder.size()) {
                        ignored = new SetLogCategory("smart");
                        throwable = null;
                        try {
                            log.error("Fail to rewrite illegal RawRecItem({})", (Object)rawRecItem.getId());
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ignored == null) continue;
                            if (throwable != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ignored.close();
                            continue;
                        }
                    }
                    layout.setColOrder(nColOrder);
                    layout.setShardByColumns(nShardBy);
                    layout.setPartitionByColumns(nPartitionBy);
                    updateHandler.add(layout, rawRecItem.isAgg());
                    ignored = new SetLogCategory("smart");
                    throwable = null;
                    try {
                        approvedLayouts.put(layout.getId(), rawRecItem);
                        log.info("RawRecItem({}) rewrite colOrder({}) to ({})", new Object[]{rawRecItem.getId(), colOrder, nColOrder});
                        log.info("RawRecItem({}) rewrite shardBy({}) to ({})", new Object[]{rawRecItem.getId(), shardBy, nShardBy});
                        log.info("RawRecItem({}) rewrite sortBy({}) to ({})", new Object[]{rawRecItem.getId(), sortBy, nSortBy});
                        log.info("RawRecItem({}) rewrite partitionBy({}) to ({})", new Object[]{rawRecItem.getId(), partitionBy, nPartitionBy});
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (ignored == null) continue;
                        if (throwable != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        ignored.close();
                    }
                }
                updateHandler.complete();
                layoutIds.addAll(updateHandler.getAddedLayouts());
            });
            this.logFinishRewrite("augment IndexPlan");
            return layoutIds.stream().filter(approvedLayouts::containsKey).collect(Collectors.toMap(Function.identity(), approvedLayouts::get));
        }

        private boolean isAbnormal(RawRecItem rawRecItem) {
            return Arrays.stream(rawRecItem.getDependIDs()).anyMatch(id -> this.abnormalRecIds.contains(-id)) || this.abnormalRecIds.contains(rawRecItem.getId());
        }

        private boolean isInvalidColId(List<Integer> cols, NDataModel model) {
            for (Integer colId : cols) {
                if (model.getEffectiveCols().containsKey((Object)colId) || model.getEffectiveMeasures().containsKey((Object)colId)) continue;
                return true;
            }
            return false;
        }

        private List<Integer> translateToRealIds(List<Integer> virtualIds, String layoutPropType) {
            ArrayList realIds = Lists.newArrayList();
            virtualIds.forEach(virtualId -> {
                int realId;
                if (this.recommendation.getDimensionRefs().containsKey(virtualId)) {
                    int refId = ((RecommendationRef)this.recommendation.getDimensionRefs().get(virtualId)).getId();
                    realId = this.dimensions.get(refId).getId();
                } else if (this.recommendation.getMeasureRefs().containsKey(virtualId)) {
                    int refId = ((RecommendationRef)this.recommendation.getMeasureRefs().get(virtualId)).getId();
                    realId = this.measures.get(refId).getId();
                } else if (this.recommendation.getColumnRefs().containsKey(virtualId)) {
                    realId = ((RecommendationRef)this.recommendation.getColumnRefs().get(virtualId)).getId();
                } else {
                    String translateErrorMsg = String.format(Locale.ROOT, "virtual id(%s) in %s(%s) cannot map to real id in model(%s/%s)", virtualId, layoutPropType, virtualIds, this.recommendation.getProject(), this.recommendation.getUuid());
                    throw new IllegalStateException(translateErrorMsg);
                }
                realIds.add(realId);
            });
            return realIds;
        }

        private List<Long> reduceIndexPlan(List<RawRecItem> recItems) {
            if (CollectionUtils.isEmpty(recItems)) {
                return Lists.newArrayList();
            }
            this.logBeginRewrite("reduce IndexPlan");
            ArrayList removedLayoutIds = Lists.newArrayList();
            NIndexPlanManager indexMgr = NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project);
            indexMgr.updateIndexPlan(this.recommendation.getUuid(), copyForWrite -> {
                IndexPlan.IndexPlanUpdateHandler updateHandler = copyForWrite.createUpdateHandler();
                for (RawRecItem rawRecItem : recItems) {
                    if (!rawRecItem.isRemoveLayoutRec()) continue;
                    LayoutEntity layout = RawRecUtil.getLayout((RawRecItem)rawRecItem);
                    updateHandler.remove(layout, rawRecItem.isAgg(), layout.isManual());
                    removedLayoutIds.add(layout.getId());
                }
                updateHandler.complete();
            });
            this.logFinishRewrite("reduce IndexPlan");
            return removedLayoutIds;
        }

        private void logBeginRewrite(String rewriteInfo) {
            try (SetLogCategory ignored = new SetLogCategory("smart");){
                log.info("Start to rewrite RawRecItems to {}({}/{})", new Object[]{rewriteInfo, this.recommendation.getProject(), this.recommendation.getUuid()});
            }
        }

        private void logFinishRewrite(String rewrite) {
            try (SetLogCategory ignored = new SetLogCategory("smart");){
                log.info("Rewrite RawRecItems to {}({}/{}) successfully", new Object[]{rewrite, this.recommendation.getProject(), this.recommendation.getUuid()});
            }
        }

        private void logWriteProperty(RawRecItem recItem, Object obj) {
            if (obj instanceof NDataModel.NamedColumn) {
                NDataModel.NamedColumn column = (NDataModel.NamedColumn)obj;
                try (SetLogCategory ignored = new SetLogCategory("smart");){
                    log.info("Write RawRecItem({}) to model as Column with id({}), name({}), isDimension({})", new Object[]{recItem.getId(), column.getId(), column.getName(), column.isDimension()});
                }
            }
            if (obj instanceof NDataModel.Measure) {
                NDataModel.Measure measure = (NDataModel.Measure)obj;
                try (SetLogCategory ignored = new SetLogCategory("smart");){
                    log.info("Write RawRecItem({}) to model as Measure with id({}), name({}) ", new Object[]{recItem.getId(), measure.getId(), measure.getName()});
                }
            }
        }

        @Generated
        public OptRecV2 getRecommendation() {
            return this.recommendation;
        }
    }
}

