/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.manager;

import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.job.manager.JobManager;
import org.apache.kylin.job.model.JobParam;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NSegmentConfigHelper;
import org.apache.kylin.metadata.model.SegmentConfig;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentAutoMergeUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentAutoMergeUtil.class);

    private SegmentAutoMergeUtil() {
    }

    public static void autoMergeSegments(String project, String modelId, String owner) {
        if (SegmentAutoMergeUtil.canSkipMergeAndClearSeg(project, modelId)) {
            return;
        }
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            SegmentAutoMergeUtil.handleRetention(project, modelId);
            SegmentAutoMergeUtil.doAutoMerge(project, modelId, owner);
            return null;
        }, (String)project, (int)1);
    }

    private static void doAutoMerge(String project, String modelId, String owner) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        NDataflow df = dfManager.getDataflow(modelId);
        SegmentConfig segmentConfig = NSegmentConfigHelper.getModelSegmentConfig((String)project, (String)modelId);
        Preconditions.checkState((segmentConfig != null ? 1 : 0) != 0);
        SegmentRange rangeToMerge = df.getSegments().autoMergeSegments(segmentConfig);
        if (rangeToMerge != null) {
            NDataSegment mergeSeg = null;
            try {
                mergeSeg = NDataflowManager.getInstance((KylinConfig)config, (String)project).mergeSegments(df, rangeToMerge, true);
            }
            catch (Exception e) {
                log.warn("Failed to generate a merge segment", (Throwable)e);
            }
            if (mergeSeg != null) {
                JobParam jobParam = new JobParam(mergeSeg, modelId, owner);
                jobParam.setProject(project);
                JobManager.getInstance(config, project).mergeSegmentJob(jobParam);
            }
        }
    }

    private static void handleRetention(String project, String modelId) {
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataflow df = dfManager.getDataflow(modelId);
        dfManager.handleRetention(df);
    }

    public static boolean canSkipMergeAndClearSeg(String project, String modelId) {
        SegmentConfig segmentConfig = NSegmentConfigHelper.getModelSegmentConfig((String)project, (String)modelId);
        if (segmentConfig == null) {
            log.error("segment config is null");
            return true;
        }
        return segmentConfig.canSkipAutoMerge() && segmentConfig.canSkipHandleRetentionSegment();
    }
}

