/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.util.inifile;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.luke.app.desktop.util.inifile.IniFileReader;
import org.apache.lucene.luke.app.desktop.util.inifile.OptionMap;

public class SimpleIniFileReader
implements IniFileReader {
    private String currentSection = "";

    @Override
    public Map<String, OptionMap> readSections(Path path) throws IOException {
        LinkedHashMap<String, OptionMap> sections = new LinkedHashMap<String, OptionMap>();
        try (BufferedReader r = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            r.lines().forEach(line -> {
                String[] ary;
                if (this.isSectionLine(line = line.trim())) {
                    this.currentSection = line.substring(1, line.length() - 1);
                    sections.putIfAbsent(this.currentSection, new OptionMap());
                } else if (!(this.currentSection.isEmpty() || (ary = line.split("=", 2)).length != 2 || ary[0].trim().isEmpty() || ary[1].trim().isEmpty())) {
                    ((OptionMap)sections.get(this.currentSection)).put(ary[0].trim(), ary[1].trim());
                }
            });
        }
        return sections;
    }

    private boolean isSectionLine(String line) {
        return line.startsWith("[") && line.endsWith("]") && line.substring(1, line.length() - 1).matches("^[a-zA-Z0-9]+$");
    }
}

