/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import org.apache.lucene.replicator.nrt.Node;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.FileDeleter;

class ReplicaFileDeleter {
    private final FileDeleter fileDeleter;
    private final Directory dir;
    private final Node node;

    public ReplicaFileDeleter(Node node, Directory dir) throws IOException {
        this.dir = dir;
        this.node = node;
        this.fileDeleter = new FileDeleter(dir, (msgType, s) -> {
            if (msgType == FileDeleter.MsgType.FILE && Node.VERBOSE_FILES) {
                node.message((String)s);
            }
        });
    }

    public synchronized void incRef(Collection<String> fileNames) throws IOException {
        this.fileDeleter.incRef(fileNames);
    }

    public synchronized void decRef(Collection<String> fileNames) throws IOException {
        this.fileDeleter.decRef(fileNames);
    }

    public synchronized int getRefCount(String fileName) {
        return this.fileDeleter.getRefCount(fileName);
    }

    public synchronized void deleteIfNoRef(String fileName) throws IOException {
        this.fileDeleter.deleteFileIfNoRef(fileName);
    }

    public synchronized void forceDeleteFile(String fileName) throws IOException {
        this.fileDeleter.forceDelete(fileName);
    }

    public synchronized void deleteUnknownFiles(String segmentsFileName) throws IOException {
        Set toDelete = this.fileDeleter.getUnrefedFiles();
        for (String fileName : this.dir.listAll()) {
            if (this.fileDeleter.exists(fileName) || fileName.equals("write.lock") || fileName.equals(segmentsFileName)) continue;
            this.node.message("will delete unknown file \"" + fileName + "\"");
            toDelete.add(fileName);
        }
        this.fileDeleter.deleteFilesIfNoRef((Collection)toDelete);
    }
}

