/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.lucene.monitor.CandidateMatcher;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.monitor.MultiMatchingQueries;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public class PartitionMatcher<T extends QueryMatch>
extends CandidateMatcher<T> {
    private final ExecutorService executor;
    private final MatcherFactory<T> matcherFactory;
    private final int threads;
    private final CandidateMatcher<T> resolvingMatcher;
    private final List<MatchTask> tasks = new ArrayList<MatchTask>();

    private PartitionMatcher(IndexSearcher searcher, ExecutorService executor, MatcherFactory<T> matcherFactory, int threads) {
        super(searcher);
        this.executor = executor;
        this.matcherFactory = matcherFactory;
        this.threads = threads;
        this.resolvingMatcher = matcherFactory.createMatcher(searcher);
    }

    @Override
    protected void matchQuery(String queryId, Query matchQuery, Map<String, String> metadata) {
        this.tasks.add(new MatchTask(queryId, matchQuery, metadata));
    }

    @Override
    public T resolve(T match1, T match2) {
        return this.resolvingMatcher.resolve(match1, match2);
    }

    @Override
    protected void doFinish() {
        ArrayList<MatcherWorker> workers = new ArrayList<MatcherWorker>(this.threads);
        for (List<MatchTask> list : PartitionMatcher.partition(this.tasks, this.threads)) {
            CandidateMatcher<T> matcher = this.matcherFactory.createMatcher(this.searcher);
            workers.add(new MatcherWorker(list, matcher));
        }
        try {
            for (Future future : this.executor.invokeAll(workers)) {
                MultiMatchingQueries matches = (MultiMatchingQueries)future.get();
                for (int doc = 0; doc < matches.getBatchSize(); ++doc) {
                    for (QueryMatch match : matches.getMatches(doc)) {
                        this.addMatch(match, doc);
                    }
                }
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException("Interrupted during match", e);
        }
    }

    public static <T extends QueryMatch> MatcherFactory<T> factory(ExecutorService executor, MatcherFactory<T> matcherFactory, int threads) {
        return new PartitionMatcherFactory<T>(executor, matcherFactory, threads);
    }

    public static <T extends QueryMatch> MatcherFactory<T> factory(ExecutorService executor, MatcherFactory<T> matcherFactory) {
        int threads = Runtime.getRuntime().availableProcessors();
        return new PartitionMatcherFactory<T>(executor, matcherFactory, threads);
    }

    static <T> List<List<T>> partition(List<T> items, int slices) {
        double size = (double)items.size() / (double)slices;
        double accum = 0.0;
        int start = 0;
        ArrayList<List<T>> list = new ArrayList<List<T>>(slices);
        for (int i = 0; i < slices; ++i) {
            int end = (int)Math.floor(accum + size);
            if (i == slices - 1) {
                end = items.size();
            }
            list.add(items.subList(start, end));
            start = (int)Math.floor(accum += size);
        }
        return list;
    }

    private static class PartitionMatcherFactory<T extends QueryMatch>
    implements MatcherFactory<T> {
        private final ExecutorService executor;
        private final MatcherFactory<T> matcherFactory;
        private final int threads;

        PartitionMatcherFactory(ExecutorService executor, MatcherFactory<T> matcherFactory, int threads) {
            this.executor = executor;
            this.matcherFactory = matcherFactory;
            this.threads = threads;
        }

        @Override
        public PartitionMatcher<T> createMatcher(IndexSearcher searcher) {
            return new PartitionMatcher<T>(searcher, this.executor, this.matcherFactory, this.threads);
        }
    }

    private class MatcherWorker
    implements Callable<MultiMatchingQueries<T>> {
        final List<MatchTask> tasks;
        final CandidateMatcher<T> matcher;

        private MatcherWorker(List<MatchTask> tasks, CandidateMatcher<T> matcher) {
            this.tasks = tasks;
            this.matcher = matcher;
        }

        @Override
        public MultiMatchingQueries<T> call() {
            for (MatchTask task : this.tasks) {
                try {
                    this.matcher.matchQuery(task.queryId, task.matchQuery, task.metadata);
                }
                catch (IOException e) {
                    PartitionMatcher.this.reportError(task.queryId, e);
                }
            }
            return this.matcher.finish(0L, 0);
        }
    }

    private static class MatchTask {
        final String queryId;
        final Query matchQuery;
        final Map<String, String> metadata;

        private MatchTask(String queryId, Query matchQuery, Map<String, String> metadata) {
            this.queryId = queryId;
            this.matchQuery = matchQuery;
            this.metadata = metadata;
        }
    }
}

