/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop;

import java.util.ArrayList;
import java.util.List;

public class MessageBroker {
    private static final MessageBroker instance = new MessageBroker();
    private List<MessageReceiver> receivers = new ArrayList<MessageReceiver>();

    public static MessageBroker getInstance() {
        return instance;
    }

    public void registerReceiver(MessageReceiver receiver) {
        this.receivers.add(receiver);
    }

    public void showStatusMessage(String message) {
        for (MessageReceiver receiver : this.receivers) {
            receiver.showStatusMessage(message);
        }
    }

    public void showUnknownErrorMessage() {
        for (MessageReceiver receiver : this.receivers) {
            receiver.showUnknownErrorMessage();
        }
    }

    public void clearStatusMessage() {
        for (MessageReceiver receiver : this.receivers) {
            receiver.clearStatusMessage();
        }
    }

    public static interface MessageReceiver {
        public void showStatusMessage(String var1);

        public void showUnknownErrorMessage();

        public void clearStatusMessage();
    }
}

