/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.fragments.analysis;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.lucene.luke.app.desktop.components.ComponentOperatorRegistry;
import org.apache.lucene.luke.app.desktop.components.TableColumnInfo;
import org.apache.lucene.luke.app.desktop.components.TableModelBase;
import org.apache.lucene.luke.app.desktop.components.dialog.analysis.TokenAttributeDialogFactory;
import org.apache.lucene.luke.app.desktop.components.fragments.analysis.SimpleAnalyzeResultPanelOperator;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.TableUtils;
import org.apache.lucene.luke.models.analysis.Analysis;

public class SimpleAnalyzeResultPanelProvider
implements SimpleAnalyzeResultPanelOperator {
    private final ComponentOperatorRegistry operatorRegistry;
    private final TokenAttributeDialogFactory tokenAttrDialogFactory;
    private final JTable tokensTable = new JTable();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private Analysis analysisModel;
    private List<Analysis.Token> tokens;

    public SimpleAnalyzeResultPanelProvider(TokenAttributeDialogFactory tokenAttrDialogFactory) {
        this.operatorRegistry = ComponentOperatorRegistry.getInstance();
        this.operatorRegistry.register(SimpleAnalyzeResultPanelOperator.class, this);
        this.tokenAttrDialogFactory = tokenAttrDialogFactory;
    }

    public JPanel get() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel hint = new JPanel(new FlowLayout(3));
        hint.setOpaque(false);
        hint.add(new JLabel(MessageUtils.getLocalizedMessage("analysis.hint.show_attributes")));
        panel.add((Component)hint, "First");
        TableUtils.setupTable(this.tokensTable, 0, new TokensTableModel(), new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SimpleAnalyzeResultPanelProvider.this.listeners.showAttributeValues(e);
            }
        }, TokensTableModel.Column.TERM.getColumnWidth(), TokensTableModel.Column.ATTR.getColumnWidth());
        panel.add((Component)new JScrollPane(this.tokensTable), "Center");
        return panel;
    }

    @Override
    public void setAnalysisModel(Analysis analysisModel) {
        this.analysisModel = analysisModel;
    }

    @Override
    public void executeAnalysis(String text) {
        this.tokens = this.analysisModel.analyze(text);
        this.tokensTable.setModel(new TokensTableModel(this.tokens));
        this.tokensTable.setShowGrid(true);
        this.tokensTable.getColumnModel().getColumn(TokensTableModel.Column.TERM.getIndex()).setPreferredWidth(TokensTableModel.Column.TERM.getColumnWidth());
        this.tokensTable.getColumnModel().getColumn(TokensTableModel.Column.ATTR.getIndex()).setPreferredWidth(TokensTableModel.Column.ATTR.getColumnWidth());
    }

    @Override
    public void clearTable() {
        TableUtils.setupTable(this.tokensTable, 0, new TokensTableModel(), null, TokensTableModel.Column.TERM.getColumnWidth(), TokensTableModel.Column.ATTR.getColumnWidth());
    }

    private void showAttributeValues(int selectedIndex) {
        String term = this.tokens.get(selectedIndex).getTerm();
        List<Analysis.TokenAttribute> attributes = this.tokens.get(selectedIndex).getAttributes();
        new DialogOpener<TokenAttributeDialogFactory>(this.tokenAttrDialogFactory).open("Token Attributes", 650, 400, factory -> {
            factory.setTerm(term);
            factory.setAttributes(attributes);
        }, new String[0]);
    }

    private static class TokensTableModel
    extends TableModelBase<Column> {
        TokensTableModel() {
        }

        TokensTableModel(List<Analysis.Token> tokens) {
            super(tokens.size());
            for (int i = 0; i < tokens.size(); ++i) {
                Analysis.Token token = tokens.get(i);
                this.data[i][Column.TERM.getIndex()] = token.getTerm();
                List attValues = token.getAttributes().stream().flatMap(att -> att.getAttValues().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue())).collect(Collectors.toList());
                this.data[i][Column.ATTR.getIndex()] = String.join((CharSequence)",", attValues);
            }
        }

        protected Column[] columnInfos() {
            return Column.values();
        }

        static enum Column implements TableColumnInfo
        {
            TERM("Term", 0, String.class, 150),
            ATTR("Attributes", 1, String.class, 1000);

            private final String colName;
            private final int index;
            private final Class<?> type;
            private final int width;

            private Column(String colName, int index, Class<?> type, int width) {
                this.colName = colName;
                this.index = index;
                this.type = type;
                this.width = width;
            }

            @Override
            public String getColName() {
                return this.colName;
            }

            @Override
            public int getIndex() {
                return this.index;
            }

            @Override
            public Class<?> getType() {
                return this.type;
            }

            @Override
            public int getColumnWidth() {
                return this.width;
            }
        }
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void showAttributeValues(MouseEvent e) {
            if (e.getClickCount() != 2 || e.isConsumed()) {
                return;
            }
            int selectedIndex = SimpleAnalyzeResultPanelProvider.this.tokensTable.rowAtPoint(e.getPoint());
            if (selectedIndex < 0 || selectedIndex >= SimpleAnalyzeResultPanelProvider.this.tokensTable.getRowCount()) {
                return;
            }
            SimpleAnalyzeResultPanelProvider.this.showAttributeValues(selectedIndex);
        }
    }
}

