/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.search;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.luke.models.LukeException;
import org.apache.lucene.luke.models.LukeModel;
import org.apache.lucene.luke.models.search.MLTConfig;
import org.apache.lucene.luke.models.search.QueryParserConfig;
import org.apache.lucene.luke.models.search.Search;
import org.apache.lucene.luke.models.search.SearchResults;
import org.apache.lucene.luke.models.search.SimilarityConfig;
import org.apache.lucene.luke.models.util.IndexUtils;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.queries.mlt.MoreLikeThis;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.standard.StandardQueryParser;
import org.apache.lucene.queryparser.flexible.standard.config.PointsConfig;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.similarities.BM25Similarity;
import org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;

public final class SearchImpl
extends LukeModel
implements Search {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int DEFAULT_PAGE_SIZE = 10;
    private static final int DEFAULT_TOTAL_HITS_THRESHOLD = 1000;
    private final IndexSearcher searcher;
    private int pageSize = 10;
    private int currentPage = -1;
    private TotalHits totalHits;
    private ScoreDoc[] docs = new ScoreDoc[0];
    private boolean exactHitsCount;
    private Query query;
    private Sort sort;
    private Set<String> fieldsToLoad;

    public SearchImpl(IndexReader reader) {
        super(reader);
        this.searcher = new IndexSearcher(reader);
    }

    @Override
    public Collection<String> getSortableFieldNames() {
        return IndexUtils.getFieldNames(this.reader).stream().map(f -> IndexUtils.getFieldInfo(this.reader, f)).filter(info -> !info.getDocValuesType().equals((Object)DocValuesType.NONE)).map(info -> info.name).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getSearchableFieldNames() {
        return IndexUtils.getFieldNames(this.reader).stream().map(f -> IndexUtils.getFieldInfo(this.reader, f)).filter(info -> !info.getIndexOptions().equals((Object)IndexOptions.NONE)).map(info -> info.name).collect(Collectors.toList());
    }

    @Override
    public Collection<String> getRangeSearchableFieldNames() {
        return IndexUtils.getFieldNames(this.reader).stream().map(f -> IndexUtils.getFieldInfo(this.reader, f)).filter(info -> info.getPointDimensionCount() > 0).map(info -> info.name).collect(Collectors.toSet());
    }

    @Override
    public Query getCurrentQuery() {
        return this.query;
    }

    @Override
    public Query parseQuery(String expression, String defField, Analyzer analyzer, QueryParserConfig config, boolean rewrite) {
        Query query;
        Objects.requireNonNull(expression);
        Objects.requireNonNull(defField);
        Objects.requireNonNull(analyzer);
        Objects.requireNonNull(config);
        Query query2 = query = config.isUseClassicParser() ? this.parseByClassicParser(expression, defField, analyzer, config) : this.parseByStandardParser(expression, defField, analyzer, config);
        if (rewrite) {
            try {
                query = query.rewrite(this.searcher);
            }
            catch (IOException e) {
                throw new LukeException(String.format(Locale.ENGLISH, "Failed to rewrite query: %s", query.toString()), e);
            }
        }
        return query;
    }

    private Query parseByClassicParser(String expression, String defField, Analyzer analyzer, QueryParserConfig config) {
        QueryParser parser = new QueryParser(defField, analyzer);
        switch (config.getDefaultOperator()) {
            case OR: {
                parser.setDefaultOperator(QueryParser.Operator.OR);
                break;
            }
            case AND: {
                parser.setDefaultOperator(QueryParser.Operator.AND);
            }
        }
        parser.setSplitOnWhitespace(config.isSplitOnWhitespace());
        parser.setAutoGenerateMultiTermSynonymsPhraseQuery(config.isAutoGenerateMultiTermSynonymsPhraseQuery());
        parser.setAutoGeneratePhraseQueries(config.isAutoGeneratePhraseQueries());
        parser.setEnablePositionIncrements(config.isEnablePositionIncrements());
        parser.setAllowLeadingWildcard(config.isAllowLeadingWildcard());
        parser.setDateResolution(config.getDateResolution());
        parser.setFuzzyMinSim(config.getFuzzyMinSim());
        parser.setFuzzyPrefixLength(config.getFuzzyPrefixLength());
        parser.setLocale(config.getLocale());
        parser.setTimeZone(config.getTimeZone());
        parser.setPhraseSlop(config.getPhraseSlop());
        try {
            return parser.parse(expression);
        }
        catch (ParseException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to parse query expression: %s", expression), e);
        }
    }

    private Query parseByStandardParser(String expression, String defField, Analyzer analyzer, QueryParserConfig config) {
        StandardQueryParser parser = new StandardQueryParser(analyzer);
        switch (config.getDefaultOperator()) {
            case OR: {
                parser.setDefaultOperator(StandardQueryConfigHandler.Operator.OR);
                break;
            }
            case AND: {
                parser.setDefaultOperator(StandardQueryConfigHandler.Operator.AND);
            }
        }
        parser.setEnablePositionIncrements(config.isEnablePositionIncrements());
        parser.setAllowLeadingWildcard(config.isAllowLeadingWildcard());
        parser.setDateResolution(config.getDateResolution());
        parser.setFuzzyMinSim(config.getFuzzyMinSim());
        parser.setFuzzyPrefixLength(config.getFuzzyPrefixLength());
        parser.setLocale(config.getLocale());
        parser.setTimeZone(config.getTimeZone());
        parser.setPhraseSlop(config.getPhraseSlop());
        if (config.getTypeMap() != null) {
            HashMap<String, PointsConfig> pointsConfigMap = new HashMap<String, PointsConfig>();
            for (Map.Entry<String, Class<? extends Number>> entry : config.getTypeMap().entrySet()) {
                PointsConfig pc;
                String field = entry.getKey();
                Class<? extends Number> type = entry.getValue();
                if (type == Integer.class || type == Long.class) {
                    pc = new PointsConfig(NumberFormat.getIntegerInstance(Locale.ROOT), type);
                } else if (type == Float.class || type == Double.class) {
                    pc = new PointsConfig(NumberFormat.getNumberInstance(Locale.ROOT), type);
                } else {
                    log.warning(String.format(Locale.ENGLISH, "Ignored invalid number type: %s.", type.getName()));
                    continue;
                }
                pointsConfigMap.put(field, pc);
            }
            parser.setPointsConfigMap(pointsConfigMap);
        }
        try {
            return parser.parse(expression, defField);
        }
        catch (QueryNodeException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to parse query expression: %s", expression), e);
        }
    }

    @Override
    public Query mltQuery(int docid, MLTConfig mltConfig, Analyzer analyzer) {
        try {
            MoreLikeThis mlt = new MoreLikeThis(this.reader);
            mlt.setAnalyzer(analyzer);
            mlt.setFieldNames(mltConfig.getFieldNames());
            mlt.setMinDocFreq(mltConfig.getMinDocFreq());
            mlt.setMaxDocFreq(mltConfig.getMaxDocFreq());
            mlt.setMinTermFreq(mltConfig.getMinTermFreq());
            return mlt.like(docid);
        }
        catch (IOException e) {
            throw new LukeException("Failed to create MLT query for doc: " + docid, e);
        }
    }

    @Override
    public SearchResults search(Query query, SimilarityConfig simConfig, Set<String> fieldsToLoad, int pageSize, boolean exactHitsCount) {
        return this.search(query, simConfig, null, fieldsToLoad, pageSize, exactHitsCount);
    }

    @Override
    public SearchResults search(Query query, SimilarityConfig simConfig, Sort sort, Set<String> fieldsToLoad, int pageSize, boolean exactHitsCount) {
        if (pageSize < 0) {
            throw new LukeException(new IllegalArgumentException("Negative integer is not acceptable for page size."));
        }
        this.docs = new ScoreDoc[0];
        this.currentPage = 0;
        this.pageSize = pageSize;
        this.exactHitsCount = exactHitsCount;
        this.query = Objects.requireNonNull(query);
        this.sort = sort;
        this.fieldsToLoad = fieldsToLoad == null ? null : Set.copyOf(fieldsToLoad);
        this.searcher.setSimilarity(this.createSimilarity(Objects.requireNonNull(simConfig)));
        try {
            return this.search();
        }
        catch (IOException e) {
            throw new LukeException("Search Failed.", e);
        }
    }

    private SearchResults search() throws IOException {
        TopDocs topDocs;
        ScoreDoc after;
        ScoreDoc scoreDoc = after = this.docs.length == 0 ? null : this.docs[this.docs.length - 1];
        if (this.sort != null) {
            topDocs = this.searcher.searchAfter(after, this.query, this.pageSize, this.sort);
        } else {
            int hitsThreshold = this.exactHitsCount ? Integer.MAX_VALUE : 1000;
            TopScoreDocCollectorManager collectorManager = new TopScoreDocCollectorManager(this.pageSize, after, hitsThreshold, this.searcher.getSlices().length > 1);
            topDocs = (TopDocs)this.searcher.search(this.query, (CollectorManager)collectorManager);
        }
        this.totalHits = topDocs.totalHits;
        ScoreDoc[] newDocs = new ScoreDoc[this.docs.length + topDocs.scoreDocs.length];
        System.arraycopy(this.docs, 0, newDocs, 0, this.docs.length);
        System.arraycopy(topDocs.scoreDocs, 0, newDocs, this.docs.length, topDocs.scoreDocs.length);
        this.docs = newDocs;
        return SearchResults.of(topDocs.totalHits, topDocs.scoreDocs, this.currentPage * this.pageSize, this.searcher, this.fieldsToLoad);
    }

    @Override
    public Optional<SearchResults> nextPage() {
        if (this.currentPage < 0 || this.query == null) {
            throw new LukeException(new IllegalStateException("Search session not started."));
        }
        ++this.currentPage;
        if (this.totalHits.value == 0L || this.totalHits.relation == TotalHits.Relation.EQUAL_TO && (long)this.currentPage * (long)this.pageSize >= this.totalHits.value) {
            log.warning("No more next search results are available.");
            return Optional.empty();
        }
        try {
            if (this.currentPage * this.pageSize < this.docs.length) {
                int from = this.currentPage * this.pageSize;
                int to = Math.min(from + this.pageSize, this.docs.length);
                ScoreDoc[] part = (ScoreDoc[])ArrayUtil.copyOfSubArray((Object[])this.docs, (int)from, (int)to);
                return Optional.of(SearchResults.of(this.totalHits, part, from, this.searcher, this.fieldsToLoad));
            }
            return Optional.of(this.search());
        }
        catch (IOException e) {
            throw new LukeException("Search Failed.", e);
        }
    }

    @Override
    public Optional<SearchResults> prevPage() {
        if (this.currentPage < 0 || this.query == null) {
            throw new LukeException(new IllegalStateException("Search session not started."));
        }
        --this.currentPage;
        if (this.currentPage < 0) {
            log.warning("No more previous search results are available.");
            return Optional.empty();
        }
        try {
            int from = this.currentPage * this.pageSize;
            int to = Math.min(from + this.pageSize, this.docs.length);
            ScoreDoc[] part = (ScoreDoc[])ArrayUtil.copyOfSubArray((Object[])this.docs, (int)from, (int)to);
            return Optional.of(SearchResults.of(this.totalHits, part, from, this.searcher, this.fieldsToLoad));
        }
        catch (IOException e) {
            throw new LukeException("Search Failed.", e);
        }
    }

    private Similarity createSimilarity(SimilarityConfig config) {
        ClassicSimilarity similarity;
        if (config.isUseClassicSimilarity()) {
            ClassicSimilarity tfidf;
            similarity = tfidf = new ClassicSimilarity(config.isDiscountOverlaps());
        } else {
            BM25Similarity bm25 = new BM25Similarity(config.getK1(), config.getB(), config.isDiscountOverlaps());
            similarity = bm25;
        }
        return similarity;
    }

    @Override
    public List<SortField> guessSortTypes(String name) {
        FieldInfo finfo = IndexUtils.getFieldInfo(this.reader, name);
        if (finfo == null) {
            throw new LukeException("No such field: " + name, new IllegalArgumentException());
        }
        DocValuesType dvType = finfo.getDocValuesType();
        switch (dvType) {
            case NONE: {
                return Collections.emptyList();
            }
            case NUMERIC: {
                return Arrays.stream(new SortField[]{new SortField(name, SortField.Type.INT), new SortField(name, SortField.Type.LONG), new SortField(name, SortField.Type.FLOAT), new SortField(name, SortField.Type.DOUBLE)}).collect(Collectors.toList());
            }
            case SORTED_NUMERIC: {
                return Arrays.stream(new SortField[]{new SortedNumericSortField(name, SortField.Type.INT), new SortedNumericSortField(name, SortField.Type.LONG), new SortedNumericSortField(name, SortField.Type.FLOAT), new SortedNumericSortField(name, SortField.Type.DOUBLE)}).collect(Collectors.toList());
            }
            case SORTED: {
                return Arrays.stream(new SortField[]{new SortField(name, SortField.Type.STRING), new SortField(name, SortField.Type.STRING_VAL)}).collect(Collectors.toList());
            }
            case SORTED_SET: {
                return Collections.singletonList(new SortedSetSortField(name, false));
            }
        }
        return Collections.singletonList(new SortField(name, SortField.Type.DOC));
    }

    @Override
    public Optional<SortField> getSortType(String name, String type, boolean reverse) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        List<SortField> candidates = this.guessSortTypes(name);
        if (candidates.isEmpty()) {
            log.warning(String.format(Locale.ENGLISH, "No available sort types for: %s", name));
            return Optional.empty();
        }
        for (SortField sf : candidates) {
            SortField.Type sfType;
            if (sf instanceof SortedSetSortField) {
                return Optional.of(new SortedSetSortField(sf.getField(), reverse));
            }
            if (sf instanceof SortedNumericSortField) {
                sfType = ((SortedNumericSortField)sf).getNumericType();
                if (!sfType.name().equals(type)) continue;
                return Optional.of(new SortedNumericSortField(sf.getField(), sfType, reverse));
            }
            sfType = sf.getType();
            if (!sfType.name().equals(type)) continue;
            return Optional.of(new SortField(sf.getField(), sfType, reverse));
        }
        return Optional.empty();
    }

    @Override
    public Explanation explain(Query query, int docid) {
        try {
            return this.searcher.explain(query, docid);
        }
        catch (IOException e) {
            throw new LukeException(String.format(Locale.ENGLISH, "Failed to create explanation for doc: %d for query: \"%s\"", docid, query.toString()), e);
        }
    }
}

