/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.tests.analysis;

import java.io.IOException;
import java.util.Random;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.tests.analysis.LookaheadTokenFilter;

public final class MockRandomLookaheadTokenFilter
extends LookaheadTokenFilter<LookaheadTokenFilter.Position> {
    private static final boolean DEBUG = false;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final Random random;
    private final long seed;

    public MockRandomLookaheadTokenFilter(Random random, TokenStream in) {
        super(in);
        this.seed = random.nextLong();
        this.random = new Random(this.seed);
    }

    @Override
    public LookaheadTokenFilter.Position newPosition() {
        return new LookaheadTokenFilter.Position();
    }

    @Override
    protected void afterPosition() throws IOException {
        if (!this.end && this.random.nextInt(4) == 2) {
            this.peekToken();
        }
    }

    public boolean incrementToken() throws IOException {
        boolean result;
        if (!this.end) {
            while (this.random.nextInt(3) == 1 && this.peekToken()) {
            }
        }
        if (result = this.nextToken()) {
            // empty if block
        }
        return result;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.random.setSeed(this.seed);
    }
}

