/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.client.api.Property;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.enums.Cardinality;
import org.apache.chemistry.opencmis.commons.enums.PropertyType;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractPropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyImpl<T>
extends AbstractPropertyData<T>
implements Property<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final PropertyDefinition<T> propertyDefinition;

    protected void initialize(PropertyDefinition<?> pd) {
        this.setId(pd.getId());
        this.setDisplayName(pd.getDisplayName());
        this.setLocalName(pd.getLocalName());
        this.setQueryName(pd.getQueryName());
    }

    public PropertyImpl(PropertyDefinition<T> pd, List<T> values) {
        if (pd == null) {
            throw new IllegalArgumentException("Type must be set!");
        }
        if (values == null) {
            throw new IllegalArgumentException("Value must be set!");
        }
        this.propertyDefinition = pd;
        this.initialize(pd);
        this.setValues(values);
    }

    public PropertyImpl(Property<T> property) {
        if (property == null) {
            throw new IllegalArgumentException("Source must be set!");
        }
        this.propertyDefinition = property.getDefinition();
        this.initialize(property.getDefinition());
        this.setValues(new ArrayList(property.getValues()));
    }

    public PropertyDefinition<T> getDefinition() {
        return this.propertyDefinition;
    }

    public PropertyType getType() {
        return this.propertyDefinition.getPropertyType();
    }

    public <U> U getValue() {
        List values = this.getValues();
        if (this.propertyDefinition.getCardinality() == Cardinality.SINGLE) {
            return values.size() == 0 ? null : (U)values.get(0);
        }
        return (U)values;
    }

    public String getValueAsString() {
        List values = this.getValues();
        if (values.size() == 0) {
            return null;
        }
        return this.formatValue(values.get(0));
    }

    public String getValuesAsString() {
        List values = this.getValues();
        StringBuilder result = new StringBuilder();
        for (Object value : values) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(this.formatValue(value));
        }
        return "[" + result.toString() + "]";
    }

    private String formatValue(T value) {
        if (value == null) {
            return null;
        }
        String result = value instanceof GregorianCalendar ? ((GregorianCalendar)value).getTime().toString() : value.toString();
        return result;
    }

    public boolean isMultiValued() {
        return this.propertyDefinition.getCardinality() == Cardinality.MULTI;
    }
}

