/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.system;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.manifoldcf.agents.interfaces.AgentFactory;
import org.apache.manifoldcf.agents.interfaces.AgentManagerFactory;
import org.apache.manifoldcf.agents.interfaces.IAgent;
import org.apache.manifoldcf.agents.interfaces.IAgentManager;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorPoolFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorPoolFactory;
import org.apache.manifoldcf.agents.system.IdleCleanupThread;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IServiceCleanup;
import org.apache.manifoldcf.core.interfaces.IShutdownHook;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class AgentsDaemon {
    public static final String _rcsid = "@(#)$Id: AgentsDaemon.java 1630536 2014-10-09 17:21:23Z kwright $";
    public static final String agentShutdownSignal = "_AGENTRUN_";
    public static final String agentServicePrefix = "AGENT_";
    protected AgentsThread agentsThread = null;
    protected IdleCleanupThread idleCleanupThread = null;
    protected final String processID;
    protected final Map<String, IAgent> runningHash = new HashMap<String, IAgent>();

    public AgentsDaemon(String processID) {
        this.processID = processID;
    }

    public static void assertAgentsShutdownSignal(IThreadContext threadContext) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        lockManager.setGlobalFlag(agentShutdownSignal);
    }

    public static void clearAgentsShutdownSignal(IThreadContext threadContext) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        lockManager.clearGlobalFlag(agentShutdownSignal);
    }

    public void registerAgentsShutdownHook(IThreadContext threadContext) throws ManifoldCFException {
        org.apache.manifoldcf.core.system.ManifoldCF.addShutdownHook((IShutdownHook)new AgentsShutdownHook());
    }

    public void runAgents(IThreadContext threadContext) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        if (lockManager.checkGlobalFlag(agentShutdownSignal)) {
            return;
        }
        this.startAgents(threadContext);
        while (!lockManager.checkGlobalFlag(agentShutdownSignal)) {
            try {
                ManifoldCF.sleep((long)5000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void startAgents(IThreadContext threadContext) throws ManifoldCFException {
        this.idleCleanupThread = new IdleCleanupThread(this.processID);
        this.agentsThread = new AgentsThread();
        this.idleCleanupThread.start();
        this.agentsThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAgents(IThreadContext threadContext) throws ManifoldCFException {
        while (this.agentsThread != null || this.idleCleanupThread != null) {
            if (this.agentsThread != null) {
                this.agentsThread.interrupt();
            }
            if (this.idleCleanupThread != null) {
                this.idleCleanupThread.interrupt();
            }
            if (this.agentsThread != null && !this.agentsThread.isAlive()) {
                this.agentsThread = null;
            }
            if (this.idleCleanupThread == null || this.idleCleanupThread.isAlive()) continue;
            this.idleCleanupThread = null;
        }
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        Map<String, IAgent> map = this.runningHash;
        synchronized (map) {
            Iterator<String> iter = this.runningHash.keySet().iterator();
            while (iter.hasNext()) {
                String className = iter.next();
                IAgent agent = this.runningHash.get(className);
                agent.stopAgent(threadContext);
                lockManager.endServiceActivity(AgentsDaemon.getAgentsClassServiceType(className), this.processID);
                iter.remove();
                agent.cleanUp(threadContext);
            }
        }
        OutputConnectorPoolFactory.make(threadContext).flushUnusedConnectors();
        TransformationConnectorPoolFactory.make(threadContext).flushUnusedConnectors();
    }

    protected static String getAgentsClassServiceType(String agentClassName) {
        return agentServicePrefix + agentClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAgents(IThreadContext threadContext) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)threadContext);
        IAgentManager manager = AgentManagerFactory.make(threadContext);
        Map<String, IAgent> map = this.runningHash;
        synchronized (map) {
            String[] classes = manager.getAllAgents();
            HashSet<String> currentAgentClasses = new HashSet<String>();
            int i = 0;
            while (i < classes.length) {
                String className;
                if (this.runningHash.get(className = classes[i++]) == null) {
                    IAgent agent = AgentFactory.make(className);
                    String serviceType = AgentsDaemon.getAgentsClassServiceType(className);
                    agent.initialize(threadContext);
                    try {
                        lockManager.registerServiceBeginServiceActivity(serviceType, this.processID, (IServiceCleanup)new CleanupAgent(threadContext, agent, this.processID));
                        agent.startAgent(threadContext, this.processID);
                        this.runningHash.put(className, agent);
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() != 2) {
                            agent.cleanUp(threadContext);
                            lockManager.endServiceActivity(serviceType, this.processID);
                        }
                        throw e;
                    }
                }
                currentAgentClasses.add(className);
            }
            Iterator<String> runningAgentsIterator = this.runningHash.keySet().iterator();
            while (runningAgentsIterator.hasNext()) {
                String runningAgentClass = runningAgentsIterator.next();
                if (currentAgentClasses.contains(runningAgentClass)) continue;
                IAgent agent = this.runningHash.get(runningAgentClass);
                agent.stopAgent(threadContext);
                lockManager.endServiceActivity(AgentsDaemon.getAgentsClassServiceType(runningAgentClass), this.processID);
                runningAgentsIterator.remove();
                agent.cleanUp(threadContext);
            }
        }
        map = this.runningHash;
        synchronized (map) {
            for (String agentsClass : this.runningHash.keySet()) {
                IAgent agent = this.runningHash.get(agentsClass);
                CleanupAgent cleanup = new CleanupAgent(threadContext, agent, this.processID);
                String agentsClassServiceType = AgentsDaemon.getAgentsClassServiceType(agentsClass);
                while (!lockManager.cleanupInactiveService(agentsClassServiceType, (IServiceCleanup)cleanup)) {
                }
            }
        }
    }

    protected class AgentsShutdownHook
    implements IShutdownHook {
        public void doCleanup(IThreadContext threadContext) throws ManifoldCFException {
            AgentsDaemon.this.stopAgents(threadContext);
        }
    }

    protected static class CleanupAgent
    implements IServiceCleanup {
        protected final IAgent agent;
        protected final IThreadContext threadContext;
        protected final String processID;

        public CleanupAgent(IThreadContext threadContext, IAgent agent, String processID) {
            this.agent = agent;
            this.threadContext = threadContext;
            this.processID = processID;
        }

        public void cleanUpService(String serviceName) throws ManifoldCFException {
            this.agent.cleanUpAgentData(this.threadContext, this.processID, serviceName);
        }

        public void cleanUpAllServices() throws ManifoldCFException {
            this.agent.cleanUpAllAgentData(this.threadContext, this.processID);
        }

        public void clusterInit() throws ManifoldCFException {
            this.agent.clusterInit(this.threadContext);
        }
    }

    protected class AgentsThread
    extends Thread {
        public AgentsThread() {
            this.setName("Agents thread");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                IThreadContext threadContext = ThreadContextFactory.make();
                while (true) {
                    try {
                        while (true) {
                            if (Thread.currentThread().isInterrupted()) {
                                throw new ManifoldCFException("Interrupted", 2);
                            }
                            AgentsDaemon.this.checkAgents(threadContext);
                            ManifoldCF.sleep((long)5000L);
                        }
                    }
                    catch (InterruptedException e) {
                    }
                    catch (ManifoldCFException e) {
                        if (e.getErrorCode() != 2) {
                            if (e.getErrorCode() == 3) {
                                System.err.println("Misconfigured ManifoldCF agents - shutting down");
                                Logging.agents.fatal((Object)("AgentThread configuration exception tossed: " + e.getMessage()), (Throwable)e);
                                System.exit(-200);
                            }
                            Logging.agents.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                            continue;
                        }
                    }
                    catch (OutOfMemoryError e) {
                        System.err.println("Agents process ran out of memory - shutting down");
                        e.printStackTrace(System.err);
                        System.exit(-200);
                        continue;
                    }
                    catch (Throwable e) {
                        Logging.agents.fatal((Object)("Error tossed: " + e.getMessage()), e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                System.err.println("Agents process could not start - shutting down");
                Logging.agents.fatal((Object)("AgentThread initialization error tossed: " + e.getMessage()), e);
                System.exit(-300);
            }
        }
    }
}

