/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.poi.hssf.util.PaneInformation;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.AutoFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetConditionalFormatting;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.SheetUtil;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.streaming.SheetDataWriter;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSheetFormatPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTWorksheet;

public class SXSSFSheet
implements Sheet,
Cloneable {
    SXSSFWorkbook _workbook;
    XSSFSheet _sh;
    TreeMap<Integer, SXSSFRow> _rows = new TreeMap();
    SheetDataWriter _writer;
    int _randomAccessWindowSize = 100;
    int outlineLevelRow = 0;

    public SXSSFSheet(SXSSFWorkbook workbook, XSSFSheet xSheet) throws IOException {
        this._workbook = workbook;
        this._sh = xSheet;
        this._writer = workbook.createSheetDataWriter();
        this.setRandomAccessWindowSize(this._workbook.getRandomAccessWindowSize());
    }

    SheetDataWriter getSheetDataWriter() {
        return this._writer;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        this.flushRows(0);
        this._writer.close();
        return this._writer.getWorksheetXMLInputStream();
    }

    public Iterator<Row> iterator() {
        return this.rowIterator();
    }

    public Row createRow(int rownum) {
        int maxrow = SpreadsheetVersion.EXCEL2007.getLastRowIndex();
        if (rownum < 0 || rownum > maxrow) {
            throw new IllegalArgumentException("Invalid row number (" + rownum + ") outside allowable range (0.." + maxrow + ")");
        }
        if (rownum <= this._writer.getLastFlushedRow()) {
            throw new IllegalArgumentException("Attempting to write a row[" + rownum + "] " + "in the range [0," + this._writer.getLastFlushedRow() + "] that is already written to disk.");
        }
        if (this._sh.getPhysicalNumberOfRows() > 0 && rownum <= this._sh.getLastRowNum()) {
            throw new IllegalArgumentException("Attempting to write a row[" + rownum + "] " + "in the range [0," + this._sh.getLastRowNum() + "] that is already written to disk.");
        }
        Row previousRow = rownum > 0 ? this.getRow(rownum - 1) : null;
        int initialAllocationSize = 0;
        if (previousRow != null) {
            initialAllocationSize = previousRow.getLastCellNum();
        }
        if (initialAllocationSize <= 0 && this._writer.getNumberOfFlushedRows() > 0) {
            initialAllocationSize = this._writer.getNumberOfCellsOfLastFlushedRow();
        }
        if (initialAllocationSize <= 0) {
            initialAllocationSize = 10;
        }
        SXSSFRow newRow = new SXSSFRow(this, initialAllocationSize);
        this._rows.put(new Integer(rownum), newRow);
        if (this._randomAccessWindowSize >= 0 && this._rows.size() > this._randomAccessWindowSize) {
            try {
                this.flushRows(this._randomAccessWindowSize);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return newRow;
    }

    public void removeRow(Row row) {
        if (row.getSheet() != this) {
            throw new IllegalArgumentException("Specified row does not belong to this sheet");
        }
        Iterator<Map.Entry<Integer, SXSSFRow>> iter = this._rows.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, SXSSFRow> entry = iter.next();
            if (entry.getValue() != row) continue;
            iter.remove();
            return;
        }
    }

    public Row getRow(int rownum) {
        return this._rows.get(new Integer(rownum));
    }

    public int getPhysicalNumberOfRows() {
        return this._rows.size() + this._writer.getNumberOfFlushedRows();
    }

    public int getFirstRowNum() {
        if (this._writer.getNumberOfFlushedRows() > 0) {
            return this._writer.getLowestIndexOfFlushedRows();
        }
        return this._rows.size() == 0 ? 0 : this._rows.firstKey();
    }

    public int getLastRowNum() {
        return this._rows.size() == 0 ? 0 : this._rows.lastKey();
    }

    public void setColumnHidden(int columnIndex, boolean hidden) {
        this._sh.setColumnHidden(columnIndex, hidden);
    }

    public boolean isColumnHidden(int columnIndex) {
        return this._sh.isColumnHidden(columnIndex);
    }

    public void setColumnWidth(int columnIndex, int width) {
        this._sh.setColumnWidth(columnIndex, width);
    }

    public int getColumnWidth(int columnIndex) {
        return this._sh.getColumnWidth(columnIndex);
    }

    public float getColumnWidthInPixels(int columnIndex) {
        return this._sh.getColumnWidthInPixels(columnIndex);
    }

    public void setDefaultColumnWidth(int width) {
        this._sh.setDefaultColumnWidth(width);
    }

    public int getDefaultColumnWidth() {
        return this._sh.getDefaultColumnWidth();
    }

    public short getDefaultRowHeight() {
        return this._sh.getDefaultRowHeight();
    }

    public float getDefaultRowHeightInPoints() {
        return this._sh.getDefaultRowHeightInPoints();
    }

    public void setDefaultRowHeight(short height) {
        this._sh.setDefaultRowHeight(height);
    }

    public void setDefaultRowHeightInPoints(float height) {
        this._sh.setDefaultRowHeightInPoints(height);
    }

    public CellStyle getColumnStyle(int column) {
        return this._sh.getColumnStyle(column);
    }

    public int addMergedRegion(CellRangeAddress region) {
        return this._sh.addMergedRegion(region);
    }

    public void setVerticallyCenter(boolean value) {
        this._sh.setVerticallyCenter(value);
    }

    public void setHorizontallyCenter(boolean value) {
        this._sh.setHorizontallyCenter(value);
    }

    public boolean getHorizontallyCenter() {
        return this._sh.getHorizontallyCenter();
    }

    public boolean getVerticallyCenter() {
        return this._sh.getVerticallyCenter();
    }

    public void removeMergedRegion(int index) {
        this._sh.removeMergedRegion(index);
    }

    public int getNumMergedRegions() {
        return this._sh.getNumMergedRegions();
    }

    public CellRangeAddress getMergedRegion(int index) {
        return this._sh.getMergedRegion(index);
    }

    public Iterator<Row> rowIterator() {
        Iterator<Row> result = this._rows.values().iterator();
        return result;
    }

    public void setAutobreaks(boolean value) {
        this._sh.setAutobreaks(value);
    }

    public void setDisplayGuts(boolean value) {
        this._sh.setDisplayGuts(value);
    }

    public void setDisplayZeros(boolean value) {
        this._sh.setDisplayZeros(value);
    }

    public boolean isDisplayZeros() {
        return this._sh.isDisplayZeros();
    }

    public void setRightToLeft(boolean value) {
        this._sh.setRightToLeft(value);
    }

    public boolean isRightToLeft() {
        return this._sh.isRightToLeft();
    }

    public void setFitToPage(boolean value) {
        this._sh.setFitToPage(value);
    }

    public void setRowSumsBelow(boolean value) {
        this._sh.setRowSumsBelow(value);
    }

    public void setRowSumsRight(boolean value) {
        this._sh.setRowSumsRight(value);
    }

    public boolean getAutobreaks() {
        return this._sh.getAutobreaks();
    }

    public boolean getDisplayGuts() {
        return this._sh.getDisplayGuts();
    }

    public boolean getFitToPage() {
        return this._sh.getFitToPage();
    }

    public boolean getRowSumsBelow() {
        return this._sh.getRowSumsBelow();
    }

    public boolean getRowSumsRight() {
        return this._sh.getRowSumsRight();
    }

    public boolean isPrintGridlines() {
        return this._sh.isPrintGridlines();
    }

    public void setPrintGridlines(boolean show) {
        this._sh.setPrintGridlines(show);
    }

    public PrintSetup getPrintSetup() {
        return this._sh.getPrintSetup();
    }

    public Header getHeader() {
        return this._sh.getHeader();
    }

    public Footer getFooter() {
        return this._sh.getFooter();
    }

    public void setSelected(boolean value) {
        this._sh.setSelected(value);
    }

    public double getMargin(short margin) {
        return this._sh.getMargin(margin);
    }

    public void setMargin(short margin, double size) {
        this._sh.setMargin(margin, size);
    }

    public boolean getProtect() {
        return this._sh.getProtect();
    }

    public void protectSheet(String password) {
        this._sh.protectSheet(password);
    }

    public boolean getScenarioProtect() {
        return this._sh.getScenarioProtect();
    }

    public void setZoom(int numerator, int denominator) {
        this._sh.setZoom(numerator, denominator);
    }

    public short getTopRow() {
        return this._sh.getTopRow();
    }

    public short getLeftCol() {
        return this._sh.getLeftCol();
    }

    public void showInPane(int toprow, int leftcol) {
        this._sh.showInPane(toprow, leftcol);
    }

    public void showInPane(short toprow, short leftcol) {
        this._sh.showInPane(toprow, leftcol);
    }

    public void setForceFormulaRecalculation(boolean value) {
        this._sh.setForceFormulaRecalculation(value);
    }

    public boolean getForceFormulaRecalculation() {
        return this._sh.getForceFormulaRecalculation();
    }

    public void shiftRows(int startRow, int endRow, int n) {
        throw new RuntimeException("NotImplemented");
    }

    public void shiftRows(int startRow, int endRow, int n, boolean copyRowHeight, boolean resetOriginalRowHeight) {
        throw new RuntimeException("NotImplemented");
    }

    public void createFreezePane(int colSplit, int rowSplit, int leftmostColumn, int topRow) {
        this._sh.createFreezePane(colSplit, rowSplit, leftmostColumn, topRow);
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this._sh.createFreezePane(colSplit, rowSplit);
    }

    public void createSplitPane(int xSplitPos, int ySplitPos, int leftmostColumn, int topRow, int activePane) {
        this._sh.createSplitPane(xSplitPos, ySplitPos, leftmostColumn, topRow, activePane);
    }

    public PaneInformation getPaneInformation() {
        return this._sh.getPaneInformation();
    }

    public void setDisplayGridlines(boolean show) {
        this._sh.setDisplayGridlines(show);
    }

    public boolean isDisplayGridlines() {
        return this._sh.isDisplayGridlines();
    }

    public void setDisplayFormulas(boolean show) {
        this._sh.setDisplayFormulas(show);
    }

    public boolean isDisplayFormulas() {
        return this._sh.isDisplayFormulas();
    }

    public void setDisplayRowColHeadings(boolean show) {
        this._sh.setDisplayRowColHeadings(show);
    }

    public boolean isDisplayRowColHeadings() {
        return this._sh.isDisplayRowColHeadings();
    }

    public void setRowBreak(int row) {
        this._sh.setRowBreak(row);
    }

    public boolean isRowBroken(int row) {
        return this._sh.isRowBroken(row);
    }

    public void removeRowBreak(int row) {
        this._sh.removeRowBreak(row);
    }

    public int[] getRowBreaks() {
        return this._sh.getRowBreaks();
    }

    public int[] getColumnBreaks() {
        return this._sh.getColumnBreaks();
    }

    public void setColumnBreak(int column) {
        this._sh.setColumnBreak(column);
    }

    public boolean isColumnBroken(int column) {
        return this._sh.isColumnBroken(column);
    }

    public void removeColumnBreak(int column) {
        this._sh.removeColumnBreak(column);
    }

    public void setColumnGroupCollapsed(int columnNumber, boolean collapsed) {
        this._sh.setColumnGroupCollapsed(columnNumber, collapsed);
    }

    public void groupColumn(int fromColumn, int toColumn) {
        this._sh.groupColumn(fromColumn, toColumn);
    }

    public void ungroupColumn(int fromColumn, int toColumn) {
        this._sh.ungroupColumn(fromColumn, toColumn);
    }

    public void groupRow(int fromRow, int toRow) {
        CTSheetFormatPr pr;
        for (SXSSFRow row : this._rows.subMap(fromRow, toRow + 1).values()) {
            int level = row.getOutlineLevel() + 1;
            row.setOutlineLevel(level);
            if (level <= this.outlineLevelRow) continue;
            this.outlineLevelRow = level;
        }
        CTWorksheet ct = this._sh.getCTWorksheet();
        CTSheetFormatPr cTSheetFormatPr = pr = ct.isSetSheetFormatPr() ? ct.getSheetFormatPr() : ct.addNewSheetFormatPr();
        if (this.outlineLevelRow > 0) {
            pr.setOutlineLevelRow((short)this.outlineLevelRow);
        }
    }

    public void ungroupRow(int fromRow, int toRow) {
        this._sh.ungroupRow(fromRow, toRow);
    }

    public void setRowGroupCollapsed(int row, boolean collapse) {
        if (!collapse) {
            throw new RuntimeException("Not Implemented");
        }
        this.collapseRow(row);
    }

    private void collapseRow(int rowIndex) {
        SXSSFRow row = (SXSSFRow)this.getRow(rowIndex);
        if (row == null) {
            throw new IllegalArgumentException("Invalid row number(" + rowIndex + "). Row does not exist.");
        }
        int startRow = this.findStartOfRowOutlineGroup(rowIndex);
        int lastRow = this.writeHidden(row, startRow, true);
        SXSSFRow lastRowObj = (SXSSFRow)this.getRow(lastRow);
        if (lastRowObj != null) {
            lastRowObj.setCollapsed(true);
        } else {
            SXSSFRow newRow = (SXSSFRow)this.createRow(lastRow);
            newRow.setCollapsed(true);
        }
    }

    private int findStartOfRowOutlineGroup(int rowIndex) {
        Row row = this.getRow(rowIndex);
        int level = ((SXSSFRow)row).getOutlineLevel();
        if (level == 0) {
            throw new IllegalArgumentException("Outline level is zero for the row (" + rowIndex + ").");
        }
        int currentRow = rowIndex;
        while (this.getRow(currentRow) != null) {
            if (((SXSSFRow)this.getRow(currentRow)).getOutlineLevel() < level) {
                return currentRow + 1;
            }
            --currentRow;
        }
        return currentRow + 1;
    }

    private int writeHidden(SXSSFRow xRow, int rowIndex, boolean hidden) {
        int level = xRow.getOutlineLevel();
        SXSSFRow currRow = (SXSSFRow)this.getRow(rowIndex);
        while (currRow != null && currRow.getOutlineLevel() >= level) {
            currRow.setHidden(hidden);
            currRow = (SXSSFRow)this.getRow(++rowIndex);
        }
        return rowIndex;
    }

    public void setDefaultColumnStyle(int column, CellStyle style) {
        this._sh.setDefaultColumnStyle(column, style);
    }

    public void autoSizeColumn(int column) {
        this.autoSizeColumn(column, false);
    }

    public void autoSizeColumn(int column, boolean useMergedCells) {
        double width = SheetUtil.getColumnWidth((Sheet)this, (int)column, (boolean)useMergedCells);
        if (width != -1.0) {
            int maxColumnWidth = 65280;
            if ((width *= 256.0) > (double)maxColumnWidth) {
                width = maxColumnWidth;
            }
            this.setColumnWidth(column, (int)width);
        }
    }

    public Comment getCellComment(int row, int column) {
        return this._sh.getCellComment(row, column);
    }

    public Drawing createDrawingPatriarch() {
        return this._sh.createDrawingPatriarch();
    }

    public Workbook getWorkbook() {
        return this._workbook;
    }

    public String getSheetName() {
        return this._sh.getSheetName();
    }

    public boolean isSelected() {
        return this._sh.isSelected();
    }

    public CellRange<? extends Cell> setArrayFormula(String formula, CellRangeAddress range) {
        return this._sh.setArrayFormula(formula, range);
    }

    public CellRange<? extends Cell> removeArrayFormula(Cell cell) {
        return this._sh.removeArrayFormula(cell);
    }

    public DataValidationHelper getDataValidationHelper() {
        return this._sh.getDataValidationHelper();
    }

    public List<XSSFDataValidation> getDataValidations() {
        return this._sh.getDataValidations();
    }

    public void addValidationData(DataValidation dataValidation) {
        this._sh.addValidationData(dataValidation);
    }

    public AutoFilter setAutoFilter(CellRangeAddress range) {
        return this._sh.setAutoFilter(range);
    }

    public SheetConditionalFormatting getSheetConditionalFormatting() {
        return this._sh.getSheetConditionalFormatting();
    }

    public CellRangeAddress getRepeatingRows() {
        return this._sh.getRepeatingRows();
    }

    public CellRangeAddress getRepeatingColumns() {
        return this._sh.getRepeatingColumns();
    }

    public void setRepeatingRows(CellRangeAddress rowRangeRef) {
        this._sh.setRepeatingRows(rowRangeRef);
    }

    public void setRepeatingColumns(CellRangeAddress columnRangeRef) {
        this._sh.setRepeatingColumns(columnRangeRef);
    }

    public void setRandomAccessWindowSize(int value) {
        if (value == 0 || value < -1) {
            throw new IllegalArgumentException("RandomAccessWindowSize must be either -1 or a positive integer");
        }
        this._randomAccessWindowSize = value;
    }

    public void flushRows(int remaining) throws IOException {
        while (this._rows.size() > remaining) {
            this.flushOneRow();
        }
    }

    public void flushRows() throws IOException {
        this.flushRows(0);
    }

    private void flushOneRow() throws IOException {
        Integer firstRowNum = this._rows.firstKey();
        if (firstRowNum != null) {
            int rowIndex = firstRowNum;
            SXSSFRow row = this._rows.get(firstRowNum);
            this._writer.writeRow(rowIndex, row);
            this._rows.remove(firstRowNum);
        }
    }

    public void changeRowNum(SXSSFRow row, int newRowNum) {
        this.removeRow(row);
        this._rows.put(new Integer(newRowNum), row);
    }

    public int getRowNum(SXSSFRow row) {
        for (Map.Entry<Integer, SXSSFRow> entry : this._rows.entrySet()) {
            if (entry.getValue() != row) continue;
            return entry.getKey();
        }
        return -1;
    }

    boolean dispose() {
        return this._writer.dispose();
    }
}

