/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.javasource;

import java.util.Vector;
import org.exolab.javasource.JAnnotatedElementHelper;
import org.exolab.javasource.JArrayType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JDocComment;
import org.exolab.javasource.JDocDescriptor;
import org.exolab.javasource.JModifiers;
import org.exolab.javasource.JNamedMap;
import org.exolab.javasource.JParameter;
import org.exolab.javasource.JSourceWriter;
import org.exolab.javasource.JType;

public final class JMethodSignature
extends JAnnotatedElementHelper {
    private JModifiers _modifiers = null;
    private JType _returnType = null;
    private String _name = null;
    private final JNamedMap _params;
    private final JDocComment _jdc;
    private final Vector _exceptions;

    public JMethodSignature(String name) {
        if (name == null || name.length() == 0) {
            String err = "The method name must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this._jdc = new JDocComment();
        this._returnType = null;
        this._name = name;
        this._modifiers = new JModifiers();
        this._params = new JNamedMap(3);
        this._exceptions = new Vector(1);
    }

    public JMethodSignature(String name, JType returnType) {
        this(name);
        if (returnType == null) {
            String err = "The return type must not be null or zero-length";
            throw new IllegalArgumentException(err);
        }
        this._returnType = returnType;
    }

    public void addException(JClass exp) {
        if (exp == null) {
            return;
        }
        String expClassName = exp.getName();
        for (int i = 0; i < this._exceptions.size(); ++i) {
            JClass jClass = (JClass)this._exceptions.elementAt(i);
            if (!expClassName.equals(jClass.getName())) continue;
            return;
        }
        this._exceptions.addElement(exp);
    }

    public void addParameter(JParameter parameter) {
        if (parameter == null) {
            return;
        }
        String pName = parameter.getName();
        if (this._params.get(pName) != null) {
            StringBuffer err = new StringBuffer();
            err.append("A parameter already exists for this method, ");
            err.append(this._name);
            err.append(", with the name: ");
            err.append(pName);
            throw new IllegalArgumentException(err.toString());
        }
        this._params.put(pName, parameter);
        this._jdc.addDescriptor(JDocDescriptor.createParamDesc(pName, null));
    }

    public JClass[] getExceptions() {
        Object[] jclasses = new JClass[this._exceptions.size()];
        this._exceptions.copyInto(jclasses);
        return jclasses;
    }

    public JDocComment getJDocComment() {
        return this._jdc;
    }

    public JModifiers getModifiers() {
        return this._modifiers;
    }

    public String getName() {
        return this._name;
    }

    public JParameter getParameter(int index) {
        return (JParameter)this._params.get(index);
    }

    public synchronized JParameter[] getParameters() {
        JParameter[] pArray = new JParameter[this._params.size()];
        for (int i = 0; i < pArray.length; ++i) {
            pArray[i] = (JParameter)this._params.get(i);
        }
        return pArray;
    }

    public JType getReturnType() {
        return this._returnType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setComment(String comment) {
        this._jdc.setComment(comment);
    }

    public void setModifiers(JModifiers modifiers) {
        this._modifiers = modifiers.copy();
        this._modifiers.setFinal(false);
    }

    public void print(JSourceWriter jsw) {
        this.print(jsw, true);
    }

    public void print(JSourceWriter jsw, boolean printJavaDoc) {
        JParameter jParameter;
        int i;
        if (printJavaDoc) {
            this._jdc.print(jsw);
        }
        this.printAnnotations(jsw);
        jsw.write(this._modifiers.toString());
        if (this._modifiers.toString().length() > 0) {
            jsw.write(32);
        }
        if (this._returnType != null) {
            jsw.write(this._returnType);
        } else {
            jsw.write("void");
        }
        jsw.write(32);
        jsw.write(this._name);
        jsw.write(40);
        boolean parameterAnnotations = false;
        for (i = 0; i < this._params.size(); ++i) {
            jParameter = (JParameter)this._params.get(i);
            if (!jParameter.hasAnnotations()) continue;
            parameterAnnotations = true;
            break;
        }
        if (parameterAnnotations) {
            jsw.indent();
        }
        for (i = 0; i < this._params.size(); ++i) {
            if (i > 0) {
                jsw.write(", ");
            }
            if (parameterAnnotations) {
                jsw.writeln();
            }
            jParameter = (JParameter)this._params.get(i);
            jParameter.printAnnotations(jsw);
            String typeAndName = jParameter.toString();
            jsw.write(typeAndName);
        }
        if (parameterAnnotations) {
            jsw.unindent();
        }
        jsw.write(")");
        if (this._exceptions.size() > 0) {
            jsw.writeln();
            jsw.write("    throws ");
            for (i = 0; i < this._exceptions.size(); ++i) {
                if (i > 0) {
                    jsw.write(", ");
                }
                JClass jClass = (JClass)this._exceptions.elementAt(i);
                jsw.write(jClass.getName());
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this._returnType != null) {
            sb.append(this._returnType);
        } else {
            sb.append("void");
        }
        sb.append(' ');
        sb.append(this._name);
        sb.append('(');
        for (int i = 0; i < this._params.size(); ++i) {
            JParameter jParam = (JParameter)this._params.get(i);
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(jParam.getType().getName());
        }
        sb.append(") ");
        return sb.toString();
    }

    protected String[] getParameterClassNames() {
        Vector<String> names = new Vector<String>(this._params.size());
        for (int i = 0; i < this._params.size(); ++i) {
            JType jType = ((JParameter)this._params.get(i)).getType();
            while (jType instanceof JArrayType) {
                jType = ((JArrayType)jType).getComponentType();
            }
            if (jType.isPrimitive()) continue;
            JClass jclass = (JClass)jType;
            names.addElement(jclass.getName());
        }
        Object[] array = new String[names.size()];
        names.copyInto(array);
        return array;
    }
}

