/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.WSConverter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderContainerType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectInFolderListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectListType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectParentsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.NavigationServicePort;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationServiceImpl
extends AbstractWebServicesService
implements NavigationService {
    private final AbstractPortProvider portProvider;

    public NavigationServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        NavigationServicePort port = this.portProvider.getNavigationServicePort(this.getCmisVersion(repositoryId), "getChildren");
        try {
            ObjectInFolderList objectInFolderList = WSConverter.convert((CmisObjectInFolderListType)port.getChildren(repositoryId, folderId, filter, orderBy, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, maxItems, skipCount, WSConverter.convert((ExtensionsData)extension)));
            return objectInFolderList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        NavigationServicePort port = this.portProvider.getNavigationServicePort(this.getCmisVersion(repositoryId), "getDescendants");
        try {
            List containerList = port.getDescendants(repositoryId, folderId, depth, filter, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, WSConverter.convert((ExtensionsData)extension));
            if (containerList == null) {
                List<ObjectInFolderContainer> list = null;
                return list;
            }
            ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
            for (CmisObjectInFolderContainerType container : containerList) {
                result.add(WSConverter.convert((CmisObjectInFolderContainerType)container));
            }
            ArrayList<ObjectInFolderContainer> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String filter, ExtensionsData extension) {
        NavigationServicePort port = this.portProvider.getNavigationServicePort(this.getCmisVersion(repositoryId), "getFolderParent");
        try {
            ObjectData objectData = WSConverter.convert((CmisObjectType)port.getFolderParent(repositoryId, folderId, filter, WSConverter.convert((ExtensionsData)extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        NavigationServicePort port = this.portProvider.getNavigationServicePort(this.getCmisVersion(repositoryId), "getFolderTree");
        try {
            List containerList = port.getFolderTree(repositoryId, folderId, depth, filter, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePathSegment, WSConverter.convert((ExtensionsData)extension));
            if (containerList == null) {
                List<ObjectInFolderContainer> list = null;
                return list;
            }
            ArrayList<ObjectInFolderContainer> result = new ArrayList<ObjectInFolderContainer>();
            for (CmisObjectInFolderContainerType container : containerList) {
                result.add(WSConverter.convert((CmisObjectInFolderContainerType)container));
            }
            ArrayList<ObjectInFolderContainer> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        NavigationServicePort port = this.portProvider.getNavigationServicePort(this.getCmisVersion(repositoryId), "getObjectParents");
        try {
            List parentsList = port.getObjectParents(repositoryId, objectId, filter, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includeRelativePathSegment, WSConverter.convert((ExtensionsData)extension));
            if (parentsList == null) {
                List<ObjectParentData> list = null;
                return list;
            }
            ArrayList<ObjectParentData> result = new ArrayList<ObjectParentData>();
            for (CmisObjectParentsType parent : parentsList) {
                result.add(WSConverter.convert((CmisObjectParentsType)parent));
            }
            ArrayList<ObjectParentData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        NavigationServicePort port = this.portProvider.getNavigationServicePort(this.getCmisVersion(repositoryId), "getCheckedOutDocs");
        try {
            ObjectList objectList = WSConverter.convert((CmisObjectListType)port.getCheckedOutDocs(repositoryId, folderId, filter, orderBy, includeAllowableActions, (EnumIncludeRelationships)WSConverter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, maxItems, skipCount, WSConverter.convert((ExtensionsData)extension)));
            return objectList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

