/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.FieldStatsInfo;

public class PivotField
implements Serializable {
    final String _field;
    final Object _value;
    final int _count;
    final List<PivotField> _pivot;
    final Map<String, FieldStatsInfo> _statsInfo;

    @Deprecated
    public PivotField(String f, Object v, int count, List<PivotField> pivot) {
        this(f, v, count, pivot, null);
    }

    public PivotField(String f, Object v, int count, List<PivotField> pivot, Map<String, FieldStatsInfo> statsInfo) {
        this._field = f;
        this._value = v;
        this._count = count;
        this._pivot = pivot;
        this._statsInfo = statsInfo;
    }

    public String getField() {
        return this._field;
    }

    public Object getValue() {
        return this._value;
    }

    public int getCount() {
        return this._count;
    }

    public List<PivotField> getPivot() {
        return this._pivot;
    }

    public Map<String, FieldStatsInfo> getFieldStatsInfo() {
        return this._statsInfo;
    }

    public String toString() {
        return this._field + ":" + this._value + " [" + this._count + "] " + this._pivot;
    }

    public void write(PrintStream out, int indent) {
        for (int i = 0; i < indent; ++i) {
            out.print("  ");
        }
        out.print(this._field + "=" + this._value + " (" + this._count + ")");
        if (null != this._statsInfo) {
            out.print("->stats:[");
            for (FieldStatsInfo fieldStatsInfo : this._statsInfo.values()) {
                out.print(fieldStatsInfo.toString());
                out.print(",");
            }
            out.print("]");
        }
        out.println();
        if (this._pivot != null) {
            for (PivotField p : this._pivot) {
                p.write(out, indent + 1);
            }
        }
    }
}

