/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

import com.jmatio.types.MLNumericArray;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MLDouble
extends MLNumericArray<Double> {
    public MLDouble(String name, int[] dims, int type, int attributes) {
        super(name, dims, type, attributes);
    }

    public MLDouble(String name, int[] dims) {
        super(name, dims, 6, 0);
    }

    public MLDouble(String name, Double[] vals, int m) {
        super(name, 6, (Number[])vals, m);
    }

    public MLDouble(String name, double[][] vals) {
        this(name, MLDouble.double2DToDouble(vals), vals.length);
    }

    public MLDouble(String name, double[] vals, int m) {
        this(name, MLDouble.castToDouble(vals), m);
    }

    public Double[] createArray(int m, int n) {
        return new Double[m * n];
    }

    public double[][] getArray() {
        double[][] result = new double[this.getM()][];
        for (int m = 0; m < this.getM(); ++m) {
            result[m] = new double[this.getN()];
            for (int n = 0; n < this.getN(); ++n) {
                result[m][n] = (Double)this.getReal(m, n);
            }
        }
        return result;
    }

    private static Double[] castToDouble(double[] d) {
        Double[] dest = new Double[d.length];
        for (int i = 0; i < d.length; ++i) {
            dest[i] = d[i];
        }
        return dest;
    }

    private static Double[] double2DToDouble(double[][] dd) {
        Double[] d = new Double[dd.length * dd[0].length];
        for (int n = 0; n < dd[0].length; ++n) {
            for (int m = 0; m < dd.length; ++m) {
                d[m + n * dd.length] = dd[m][n];
            }
        }
        return d;
    }

    @Override
    public int getBytesAllocated() {
        return 8;
    }

    @Override
    public Double buldFromBytes(byte[] bytes) {
        if (bytes.length != this.getBytesAllocated()) {
            throw new IllegalArgumentException("To build from byte array I need array of size: " + this.getBytesAllocated());
        }
        return ByteBuffer.wrap(bytes).getDouble();
    }

    @Override
    public byte[] getByteArray(Double value) {
        int byteAllocated = this.getBytesAllocated();
        ByteBuffer buff = ByteBuffer.allocate(byteAllocated);
        buff.putDouble(value);
        return buff.array();
    }

    @Override
    public Class<Double> getStorageClazz() {
        return Double.class;
    }
}

