/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.repositories.put;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeOperationAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPutRepositoryAction
extends TransportMasterNodeOperationAction<PutRepositoryRequest, PutRepositoryResponse> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportPutRepositoryAction(Settings settings, TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool) {
        super(settings, transportService, clusterService, threadPool);
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected String transportAction() {
        return "cluster/repository/put";
    }

    @Override
    protected PutRepositoryRequest newRequest() {
        return new PutRepositoryRequest();
    }

    @Override
    protected PutRepositoryResponse newResponse() {
        return new PutRepositoryResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(PutRepositoryRequest request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA, "");
    }

    @Override
    protected void masterOperation(PutRepositoryRequest request, ClusterState state, final ActionListener<PutRepositoryResponse> listener) throws ElasticsearchException {
        this.repositoriesService.registerRepository((RepositoriesService.RegisterRepositoryRequest)((RepositoriesService.RegisterRepositoryRequest)new RepositoriesService.RegisterRepositoryRequest("put_repository [" + request.name() + "]", request.name(), request.type()).settings(request.settings()).masterNodeTimeout(request.masterNodeTimeout())).ackTimeout(request.timeout()), new ActionListener<RepositoriesService.RegisterRepositoryResponse>(){

            @Override
            public void onResponse(RepositoriesService.RegisterRepositoryResponse response) {
                listener.onResponse(new PutRepositoryResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Throwable e) {
                listener.onFailure(e);
            }
        });
    }
}

