/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.internal.InternalClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.EsExecutors;

public class BulkProcessor {
    private final Client client;
    private final Listener listener;
    private final String name;
    private final int concurrentRequests;
    private final int bulkActions;
    private final int bulkSize;
    private final TimeValue flushInterval;
    private final Semaphore semaphore;
    private final ScheduledThreadPoolExecutor scheduler;
    private final ScheduledFuture scheduledFuture;
    private final AtomicLong executionIdGen = new AtomicLong();
    private BulkRequest bulkRequest;
    private volatile boolean closed = false;

    public static Builder builder(Client client, Listener listener) {
        return new Builder(client, listener);
    }

    BulkProcessor(Client client, Listener listener, @Nullable String name, int concurrentRequests, int bulkActions, ByteSizeValue bulkSize, @Nullable TimeValue flushInterval) {
        this.client = client;
        this.listener = listener;
        this.name = name;
        this.concurrentRequests = concurrentRequests;
        this.bulkActions = bulkActions;
        this.bulkSize = bulkSize.bytesAsInt();
        this.semaphore = new Semaphore(concurrentRequests);
        this.bulkRequest = new BulkRequest();
        this.flushInterval = flushInterval;
        if (flushInterval != null) {
            this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory(((InternalClient)client).settings(), (name != null ? "[" + name + "]" : "") + "bulk_processor"));
            this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(new Flush(), flushInterval.millis(), flushInterval.millis(), TimeUnit.MILLISECONDS);
        } else {
            this.scheduler = null;
            this.scheduledFuture = null;
        }
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(false);
            this.scheduler.shutdown();
        }
        if (this.bulkRequest.numberOfActions() > 0) {
            this.execute();
        }
    }

    public BulkProcessor add(IndexRequest request) {
        return this.add((ActionRequest)request);
    }

    public BulkProcessor add(DeleteRequest request) {
        return this.add((ActionRequest)request);
    }

    public BulkProcessor add(ActionRequest request) {
        return this.add(request, null);
    }

    public BulkProcessor add(ActionRequest request, @Nullable Object payload) {
        this.internalAdd(request, payload);
        return this;
    }

    private synchronized void internalAdd(ActionRequest request, @Nullable Object payload) {
        this.bulkRequest.add(request, payload);
        this.executeIfNeeded();
    }

    public BulkProcessor add(BytesReference data, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType) throws Exception {
        return this.add(data, contentUnsafe, defaultIndex, defaultType, null);
    }

    public synchronized BulkProcessor add(BytesReference data, boolean contentUnsafe, @Nullable String defaultIndex, @Nullable String defaultType, @Nullable Object payload) throws Exception {
        this.bulkRequest.add(data, contentUnsafe, defaultIndex, defaultType, null, payload, true);
        this.executeIfNeeded();
        return this;
    }

    private void executeIfNeeded() {
        if (this.closed) {
            throw new ElasticsearchIllegalStateException("bulk process already closed");
        }
        if (!this.isOverTheLimit()) {
            return;
        }
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        final BulkRequest bulkRequest = this.bulkRequest;
        final long executionId = this.executionIdGen.incrementAndGet();
        this.bulkRequest = new BulkRequest();
        if (this.concurrentRequests == 0) {
            try {
                this.listener.beforeBulk(executionId, bulkRequest);
                this.listener.afterBulk(executionId, bulkRequest, this.client.bulk(bulkRequest).actionGet());
            }
            catch (Exception e) {
                this.listener.afterBulk(executionId, bulkRequest, e);
            }
        } else {
            boolean success = false;
            try {
                this.semaphore.acquire();
                this.listener.beforeBulk(executionId, bulkRequest);
                this.client.bulk(bulkRequest, new ActionListener<BulkResponse>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onResponse(BulkResponse response) {
                        try {
                            BulkProcessor.this.listener.afterBulk(executionId, bulkRequest, response);
                        }
                        finally {
                            BulkProcessor.this.semaphore.release();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onFailure(Throwable e) {
                        try {
                            BulkProcessor.this.listener.afterBulk(executionId, bulkRequest, e);
                        }
                        finally {
                            BulkProcessor.this.semaphore.release();
                        }
                    }
                });
                success = true;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.listener.afterBulk(executionId, bulkRequest, e);
            }
            finally {
                if (!success) {
                    this.semaphore.release();
                }
            }
        }
    }

    private boolean isOverTheLimit() {
        if (this.bulkActions != -1 && this.bulkRequest.numberOfActions() > this.bulkActions) {
            return true;
        }
        return this.bulkSize != -1 && this.bulkRequest.estimatedSizeInBytes() > (long)this.bulkSize;
    }

    class Flush
    implements Runnable {
        Flush() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BulkProcessor bulkProcessor = BulkProcessor.this;
            synchronized (bulkProcessor) {
                if (BulkProcessor.this.closed) {
                    return;
                }
                if (BulkProcessor.this.bulkRequest.numberOfActions() == 0) {
                    return;
                }
                BulkProcessor.this.execute();
            }
        }
    }

    public static class Builder {
        private final Client client;
        private final Listener listener;
        private String name;
        private int concurrentRequests = 1;
        private int bulkActions = 1000;
        private ByteSizeValue bulkSize = new ByteSizeValue(5L, ByteSizeUnit.MB);
        private TimeValue flushInterval = null;

        public Builder(Client client, Listener listener) {
            this.client = client;
            this.listener = listener;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setConcurrentRequests(int concurrentRequests) {
            this.concurrentRequests = concurrentRequests;
            return this;
        }

        public Builder setBulkActions(int bulkActions) {
            this.bulkActions = bulkActions;
            return this;
        }

        public Builder setBulkSize(ByteSizeValue bulkSize) {
            this.bulkSize = bulkSize;
            return this;
        }

        public Builder setFlushInterval(TimeValue flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public BulkProcessor build() {
            return new BulkProcessor(this.client, this.listener, this.name, this.concurrentRequests, this.bulkActions, this.bulkSize, this.flushInterval);
        }
    }

    public static interface Listener {
        public void beforeBulk(long var1, BulkRequest var3);

        public void afterBulk(long var1, BulkRequest var3, BulkResponse var4);

        public void afterBulk(long var1, BulkRequest var3, Throwable var4);
    }
}

