/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import org.apache.sis.internal.converter.SystemConverter;
import org.apache.sis.math.FunctionProperty;

abstract class CollectionConverter<T>
extends SystemConverter<Collection<?>, T> {
    private static final long serialVersionUID = -9214936334129327955L;

    CollectionConverter(Class<T> clazz) {
        super(Collection.class, clazz);
    }

    @Override
    public java.util.Set<FunctionProperty> properties() {
        return EnumSet.of(FunctionProperty.SURJECTIVE);
    }

    public static final class Set
    extends CollectionConverter<java.util.Set<?>> {
        private static final long serialVersionUID = -1065360595793529078L;

        public Set() {
            super(java.util.Set.class);
        }

        @Override
        public java.util.Set<?> apply(Collection<?> collection) {
            if (collection == null) {
                return null;
            }
            if (collection instanceof java.util.Set) {
                return (java.util.Set)collection;
            }
            return new LinkedHashSet(collection);
        }
    }

    public static final class List
    extends CollectionConverter<java.util.List<?>> {
        private static final long serialVersionUID = -8680976097058177832L;

        public List() {
            super(java.util.List.class);
        }

        @Override
        public java.util.List<?> apply(Collection<?> collection) {
            if (collection == null) {
                return null;
            }
            if (collection instanceof java.util.List) {
                return (java.util.List)collection;
            }
            return new ArrayList(collection);
        }
    }
}

