/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

public class BytesBlock {
    private int bufSize;
    public byte[] buf;
    private int pos;
    private int startPos = 0;

    public BytesBlock(int sz) {
        this.bufSize = sz;
        this.create();
    }

    public int getPos() {
        return this.pos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public BytesBlock expand(int sz) {
        if (this.bufSize - this.pos >= sz) {
            return this.markPositions(sz);
        }
        if (sz > this.bufSize / 4) {
            return new BytesBlock(sz).expand(sz);
        }
        this.create();
        return this.markPositions(sz);
    }

    private BytesBlock markPositions(int sz) {
        this.startPos = this.pos;
        this.pos += sz;
        return this;
    }

    private void create() {
        this.buf = new byte[this.bufSize];
        this.pos = 0;
        this.startPos = 0;
    }
}

